/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.river.toolboxservice.businessbase.adapter;

import com.huawei.smartkit.river.toolboxservice.businessbase.adapter.Response;
import com.huawei.smartkit.river.toolboxservice.businessbase.application.exception.ApplicationException;
import com.huawei.smartkit.river.toolboxservice.businessbase.domain.exception.SmartKitException;
import com.huawei.smartkit.river.toolboxservice.businessbase.domain.exception.errorcode.SmartKitErrorCode;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControllerHelper.class);

    public static <T> Response<T> handleResponse(Supplier<Response<T>> responseSupplier) {
        try {
            return responseSupplier.get();
        }
        catch (ApplicationException e) {
            return Response.failed(e);
        }
        catch (Exception e) {
            log.error("Request error.", (Throwable)e);
            return Response.failed(new ApplicationException(SmartKitErrorCode.UNEXPECTED_ERROR));
        }
    }

    public static <T> Response<T> getResponseWithCommonExceptionHandle(Supplier<Response<T>> responseSupplier) {
        try {
            return responseSupplier.get();
        }
        catch (SmartKitException e) {
            log.warn("Request error, exception should be caught by module self, please check implementation.", (Throwable)e);
            return Response.failed(SmartKitErrorCode.SYSTEM_ERROR);
        }
        catch (Exception e) {
            log.error("Request error.", (Throwable)e);
            return Response.failed(SmartKitErrorCode.UNEXPECTED_ERROR);
        }
    }

    @Generated
    private ControllerHelper() {
    }
}

