/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.river.toolboxservice.businessbase.adapter;

import com.huawei.smartkit.river.toolboxservice.businessbase.domain.exception.errorcode.ErrorCode;
import com.huawei.smartkit.river.toolboxservice.businessbase.domain.exception.errorcode.ErrorDetail;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Response<T> {
    private static final String SUCCESS_CODE = "0";
    private final String code;
    private final String errorMsg;
    private final String suggestMsg;
    private final T data;

    @NotNull
    public static <T> Response<T> success(@NotNull T data) {
        return new Response<T>(SUCCESS_CODE, null, null, data);
    }

    @NotNull
    public static <T> Response<T> success() {
        return new Response<Object>(SUCCESS_CODE, null, null, null);
    }

    @NotNull
    public static <T> Response<T> failed(@NotNull ErrorDetail errorDetail) {
        return new Response<Object>(errorDetail.getErrorCode().getFullCode(), errorDetail.getErrorMessage(), errorDetail.getSuggestMessage(), null);
    }

    @NotNull
    public static <T> Response<T> failed(@NotNull ErrorCode errorCode) {
        return new Response<Object>(errorCode.getCode(), errorCode.getKey(), "", null);
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Generated
    public String getSuggestMsg() {
        return this.suggestMsg;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public Response(String code, String errorMsg, String suggestMsg, T data) {
        this.code = code;
        this.errorMsg = errorMsg;
        this.suggestMsg = suggestMsg;
        this.data = data;
    }
}

