/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.river.toolboxservice.businessbase.adapter.exception;

import com.huawei.smartkit.river.toolboxservice.businessbase.adapter.Response;
import com.huawei.smartkit.river.toolboxservice.businessbase.adapter.exception.IRestExceptionHandle;
import com.huawei.smartkit.river.toolboxservice.businessbase.adapter.exception.SystemInternalError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalRestExceptionHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalRestExceptionHandle.class);
    private static final Set<String> SCAN_PATHS = new HashSet<String>();
    private final List<IRestExceptionHandle> handles = new ArrayList<IRestExceptionHandle>();
    private ResourceLoader resourceLoader;

    public GlobalRestExceptionHandle() {
        SCAN_PATHS.add("com.huawei.smartkit");
        this.registerRestExceptionHandle();
    }

    public static void registerScanPath(List<String> scanPath) {
        log.info("register scan path: {}", scanPath);
        SCAN_PATHS.addAll(scanPath);
    }

    @ExceptionHandler(value={Throwable.class})
    public Response<?> handleThrowable(Throwable exception) {
        log.error("start handle req error: ", exception);
        return this.handles.stream().filter(handle -> handle.canHandleException(exception.getClass())).findFirst().map(handle -> handle.handleRestException(exception)).orElse(Response.failed(new SystemInternalError()));
    }

    private void registerRestExceptionHandle() {
        this.scanAllClassName().forEach(this::registerHandle);
    }

    private List<String> scanAllClassName() {
        ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
        CachingMetadataReaderFactory metaReader = new CachingMetadataReaderFactory(this.resourceLoader);
        return SCAN_PATHS.stream().map(this::constructScanPath).map(path -> this.getResources((String)path, resolver)).filter(resources -> ((Resource[])resources).length > 0).map(arg_0 -> this.lambda$scanAllClassName$4((MetadataReaderFactory)metaReader, arg_0)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private Resource[] getResources(String scanPath, ResourcePatternResolver resolver) {
        log.info("start scan: {}", (Object)scanPath);
        Resource[] scanResource = new Resource[]{};
        try {
            scanResource = this.getScanResource(scanPath, resolver);
        }
        catch (IOException e) {
            log.error("scan {} error", (Object)scanResource, (Object)e);
        }
        return scanResource;
    }

    private Resource[] getScanResource(String scanPath, ResourcePatternResolver resolver) throws IOException {
        return resolver.getResources(scanPath);
    }

    private String constructScanPath(String scanPath) {
        return String.format("classpath:%s/**/*.class", scanPath.replaceAll("\\.", "/"));
    }

    private List<String> scanClassName(Resource[] scanResource, MetadataReaderFactory metaReader) {
        return Arrays.stream(scanResource).filter(Resource::isReadable).map(resource -> this.getClassName((Resource)resource, metaReader)).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }

    private String getClassName(Resource resource, MetadataReaderFactory metaReader) {
        try {
            return this.getMetadataReader(resource, metaReader).getClassMetadata().getClassName();
        }
        catch (IOException e) {
            log.error("get {} metaReader error", (Object)resource.getFilename(), (Object)e);
            return "";
        }
    }

    private MetadataReader getMetadataReader(Resource resource, MetadataReaderFactory metaReader) throws IOException {
        return metaReader.getMetadataReader(resource);
    }

    private void registerHandle(String className) {
        try {
            Object handle;
            Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            if (IRestExceptionHandle.class.isAssignableFrom(clazz) && clazz != IRestExceptionHandle.class && (handle = clazz.newInstance()) instanceof IRestExceptionHandle) {
                log.info("register exception handle {} success", (Object)clazz.getName());
                this.handles.add((IRestExceptionHandle)handle);
            }
        }
        catch (Throwable e) {
            log.error("register {} exception handle error.", (Object)className);
        }
    }

    @Autowired
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private /* synthetic */ List lambda$scanAllClassName$4(MetadataReaderFactory metaReader, Resource[] resources) {
        return this.scanClassName(resources, metaReader);
    }
}

