/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.river.toolboxservice.businessbase.domain.exception.errorcode;

import com.huawei.smartkit.drop.util.ResourceUtils;
import com.huawei.smartkit.drop.util.StringUtils;
import com.huawei.smartkit.river.toolboxservice.businessbase.domain.exception.errorcode.ErrorCode;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public final class ExceptionResourceUtils {
    private static final String ERROR_RESOURCE_PREFIX = "error_code_";
    private static final String SUGGEST_MESSAGE_KEY = ".suggest";

    @NotNull
    public static String getErrorMessage(ErrorCode errorCode) {
        return ExceptionResourceUtils.getErrorMessage(errorCode, null);
    }

    @NotNull
    public static String getErrorMessage(ErrorCode errorCode, List<Object> errorParams) {
        return Optional.of(ResourceUtils.getString((String)ExceptionResourceUtils.getResourceName(errorCode), (String)errorCode.getKey())).map(str -> ExceptionResourceUtils.getFormatString(str, errorParams)).orElse("");
    }

    @NotNull
    public static String getSuggestMessage(ErrorCode errorCode) {
        return ResourceUtils.getString((String)ExceptionResourceUtils.getResourceName(errorCode), (String)ExceptionResourceUtils.getSuggestKey(errorCode));
    }

    private static String getSuggestKey(ErrorCode errorCode) {
        return errorCode.getKey().concat(SUGGEST_MESSAGE_KEY);
    }

    private static String getResourceName(ErrorCode errorCode) {
        return ERROR_RESOURCE_PREFIX.concat(errorCode.getModule().getName());
    }

    private static String getFormatString(String resourceString, List<Object> param) {
        return CollectionUtils.isEmpty(param) || StringUtils.isEmpty((CharSequence)resourceString) ? resourceString : MessageFormat.format(resourceString, param.toArray(new Object[0]));
    }

    @Generated
    private ExceptionResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

