/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.river.toolboxservice.businessbase.infrustruction.property;

import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

public class YamlPropertySourceFactory
implements PropertySourceFactory {
    @NotNull
    public PropertySource<?> createPropertySource(String name, @NotNull EncodedResource encodedResource) {
        return new PropertiesPropertySource(this.getResourceFileName(encodedResource), this.getProperties(encodedResource));
    }

    @NotNull
    private String getResourceFileName(@NotNull EncodedResource encodedResource) {
        return Objects.requireNonNull(encodedResource.getResource().getFilename());
    }

    @NotNull
    private Properties getProperties(EncodedResource encodedResource) {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{encodedResource.getResource()});
        return Objects.requireNonNull(factory.getObject());
    }
}

