/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClassNamePackageFilter
implements Predicate<String> {
    private static final Predicate<String> ALL_VALID_FILTER = className -> true;
    private static final String PACKAGE_SEPARATOR = ".";
    private final List<String> basePackages;

    private ClassNamePackageFilter(List<String> basePackages) {
        this.basePackages = basePackages;
    }

    public static Predicate<String> create(Collection<String> basePackages) {
        Collection actualBasePackageCollection = ObjectUtils.nullIf(basePackages, Collections.emptyList());
        List<String> actualBasePackages = actualBasePackageCollection.stream().map(StringUtils::trim).filter(StringUtils::isNotBlank).map(ClassNamePackageFilter::appendSeparator).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(actualBasePackages)) {
            return ALL_VALID_FILTER;
        }
        return new ClassNamePackageFilter(actualBasePackages);
    }

    @Override
    public boolean test(String className) {
        return this.basePackages.stream().anyMatch(className::startsWith);
    }

    private static String appendSeparator(String packageName) {
        if (packageName.endsWith(PACKAGE_SEPARATOR)) {
            return packageName;
        }
        return packageName + PACKAGE_SEPARATOR;
    }
}

