/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.PropertyKey;
import java.util.List;
import java.util.stream.Collectors;

public class PropertyKeys {
    private static final char KEY_SEPARATOR = '.';
    private final List<PropertyKey> keys;

    public PropertyKeys(String key) {
        this.keys = StringUtils.splitToList(key, '.').stream().filter(StringUtils::isNotBlank).map(PropertyKey::new).collect(Collectors.toList());
        Validation.isTrue(CollectionUtils.isNotEmpty(this.keys), "Property key must have 1 sub-key at least. [key={0}]", key);
    }

    public PropertyKey get(int index) {
        Validation.between(index, 0, this.keys.size() - 1, "Property key index out of range. [index={0}, keysSize={1}]", index, this.keys.size());
        return this.keys.get(index);
    }

    public boolean isLast(int index) {
        return index == this.keys.size() - 1;
    }
}

