/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.oss.cn.common.anonymize;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.oss.cn.common.ConstantSupport;
import com.huawei.oss.cn.common.anonymize.AnonymizeHandler;
import com.huawei.oss.cn.common.util.CommonUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AnonymizeUtil {
    private static final Logger LOGGER;
    private static final char REPLACE = '*';
    private static Map<String, AnonymizeHandler> traceRuleHandlerMap;
    private static Map<String, AnonymizeHandler> logRuleHandlerMap;
    private static Map<String, AnonymizeHandler> pwdRuleHandlerMap;
    private static List<String> fileRuleList;

    public String anonymizeStr(String content) {
        if (content.contains("anonyMizedMessage")) {
            LOGGER.info("This content has been anonymized, return.");
            return content;
        }
        return this.doContentMapSafe(content, traceRuleHandlerMap);
    }

    public String anonymizeForExport(String content) {
        return this.doContentMapSafe(content, logRuleHandlerMap);
    }

    public String anonymizeForLog(String content) {
        return this.doContentMapSafe(content, pwdRuleHandlerMap);
    }

    public String anonymizeForSystem(String content) {
        return this.doContentMapSafe(content, pwdRuleHandlerMap);
    }

    public String anonymizeForFile(String content) {
        return this.doContentSafe(content, fileRuleList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void parseFileRules(String fileconfile) {
        block10: {
            FileInputStream inputStream = null;
            BufferedInputStream bufInput = null;
            try {
                inputStream = new FileInputStream(fileconfile);
                bufInput = new BufferedInputStream(inputStream);
                Document document = XmlUtils.getSaxReader().read((InputStream)bufInput);
                Element root = document.getRootElement();
                Element rules = root.element("rules");
                if (null != rules) {
                    Iterator mocNameIter = rules.elementIterator("rule");
                    while (mocNameIter.hasNext()) {
                        Element ruleNameEle = (Element)mocNameIter.next();
                        Iterator regexItem = ruleNameEle.elementIterator("regex");
                        while (regexItem.hasNext()) {
                            Element regexItemEle = (Element)regexItem.next();
                            AnonymizeUtil.parseFileRule(regexItemEle);
                        }
                    }
                }
                CommonUtils.safeClose(bufInput);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Can not find anonymizeUtils config file {}.", (Object)new File(fileconfile).getName());
                CommonUtils.safeClose(bufInput);
                CommonUtils.safeClose(inputStream);
                break block10;
            }
            catch (DocumentException | SAXException e2) {
                LOGGER.error("AnonymizeUtils config file parse error.");
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CommonUtils.safeClose(bufInput);
                CommonUtils.safeClose(inputStream);
            }
            CommonUtils.safeClose(inputStream);
        }
    }

    private static void parseRules(Element regexItemEle) {
        String type = regexItemEle.attributeValue("type");
        String regex = regexItemEle.getTextTrim();
        if (null != regex && !regex.isEmpty()) {
            Map<String, AnonymizeHandler> ruleHandlerMap = null;
            if (type.equalsIgnoreCase("log")) {
                ruleHandlerMap = logRuleHandlerMap;
            } else if (type.equalsIgnoreCase("trace")) {
                ruleHandlerMap = traceRuleHandlerMap;
            } else if (type.equalsIgnoreCase("pwd")) {
                ruleHandlerMap = pwdRuleHandlerMap;
            } else {
                LOGGER.error("find not anonymize type");
                return;
            }
            try {
                AnonymizeUtil.addToMap(regexItemEle, regex, ruleHandlerMap);
            }
            catch (InstantiationException e) {
                LOGGER.error("AnonymizeHandler init error" + e);
                ruleHandlerMap.put(regex, null);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("AnonymizeHandler init error" + e);
                ruleHandlerMap.put(regex, null);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("AnonymizeHandler init error" + e);
                ruleHandlerMap.put(regex, null);
            }
        }
    }

    public static void addToMap(Element regexItemEle, String regex, Map<String, AnonymizeHandler> ruleHandlerMap) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz;
        ClassLoader loader;
        String handlerStr = regexItemEle.attributeValue("handler");
        if (handlerStr != null && (loader = AnonymizeUtil.class.getClassLoader()) != null && (clazz = loader.loadClass(handlerStr)) != null) {
            ruleHandlerMap.put(regex, (AnonymizeHandler)clazz.newInstance());
        }
    }

    private static void parseFileRule(Element regexItemEle) {
        regexItemEle.attributeValue("type");
        String regex = regexItemEle.getTextTrim();
        if (null != regex && !regex.isEmpty()) {
            fileRuleList.add(regex);
        }
    }

    private String doContentMapSafe(String content, Map<String, AnonymizeHandler> anonymizeHandlers) {
        if (null == anonymizeHandlers || anonymizeHandlers.isEmpty()) {
            LOGGER.error("anonymizeStr error");
            return "anonymizeStr error";
        }
        for (Map.Entry<String, AnonymizeHandler> anonymizeHandlerEntry : anonymizeHandlers.entrySet()) {
            AnonymizeHandler handler = anonymizeHandlerEntry.getValue();
            String regex = anonymizeHandlerEntry.getKey();
            if (handler == null) {
                content = this.doContentOneRegexSafe(content, regex);
                continue;
            }
            content = handler.handle(regex, content);
        }
        return content;
    }

    private String doContentSafe(String result, List<String> ruleList) {
        if (null == ruleList || ruleList.isEmpty()) {
            LOGGER.error("anonymizeStr error");
            return "anonymizeStr error";
        }
        for (String rule : ruleList) {
            result = this.doContentOneRegexSafe(result, rule);
        }
        return result.replaceAll("[*]{2,}", "*");
    }

    private String doContentOneRegexSafe(String result, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(result);
        int cnt = matcher.groupCount();
        if (cnt <= 0) {
            LOGGER.error("anonymizeStr error, the rule is not right, will return error.");
            return "anonymizeStr error";
        }
        int lastIndex = 0;
        while (matcher.find(lastIndex)) {
            for (int i = 1; i <= cnt; ++i) {
                String temp = this.genReplaceStr(matcher.group(i).length());
                result = result.substring(0, matcher.start(i)) + temp + result.substring(matcher.end(i), result.length());
                lastIndex = matcher.end(i);
            }
        }
        return result;
    }

    private String genReplaceStr(int len) {
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            temp.append('*');
        }
        return temp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        block10: {
            LOGGER = LoggerFactory.getLogger(AnonymizeUtil.class);
            traceRuleHandlerMap = null;
            logRuleHandlerMap = null;
            pwdRuleHandlerMap = null;
            fileRuleList = null;
            traceRuleHandlerMap = new HashMap<String, AnonymizeHandler>();
            logRuleHandlerMap = new HashMap<String, AnonymizeHandler>();
            pwdRuleHandlerMap = new HashMap<String, AnonymizeHandler>();
            fileRuleList = new ArrayList<String>();
            String confile = ConstantSupport.getHomePath() + "configuration" + File.separator + "anonymizeOption.xml";
            String fileconfile = ConstantSupport.getHomePath() + "configuration" + File.separator + "fileoption.xml";
            FileInputStream inputStream = null;
            BufferedInputStream bufInput = null;
            try {
                inputStream = new FileInputStream(confile);
                bufInput = new BufferedInputStream(inputStream);
                Document document = XmlUtils.getSaxReader().read((InputStream)bufInput);
                Element root = document.getRootElement();
                Element rules = root.element("rules");
                if (null != rules) {
                    Iterator mocNameIter = rules.elementIterator("rule");
                    while (mocNameIter.hasNext()) {
                        Element ruleNameEle = (Element)mocNameIter.next();
                        Iterator regexItem = ruleNameEle.elementIterator("regex");
                        while (regexItem.hasNext()) {
                            Element regexItemEle = (Element)regexItem.next();
                            AnonymizeUtil.parseRules(regexItemEle);
                        }
                    }
                }
                AnonymizeUtil.parseFileRules(fileconfile);
                CommonUtils.safeClose(bufInput);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Can not find anonymizeUtils config file {}.", (Object)new File(confile).getName());
                CommonUtils.safeClose(bufInput);
                CommonUtils.safeClose(inputStream);
                break block10;
            }
            catch (DocumentException | SAXException e2) {
                LOGGER.error("AnonymizeUtils config file parse error.");
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CommonUtils.safeClose(bufInput);
                CommonUtils.safeClose(inputStream);
            }
            CommonUtils.safeClose(inputStream);
        }
    }
}

