/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.oss.cn.common.fileutils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.oss.cn.common.fileutils.ConvertFileEncode;
import com.huawei.oss.cn.common.fileutils.FileReader;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtilsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtilsSupport.class);
    private static final String TEMP_FILE_SUBFIX = ".cceutf";

    public static boolean createDir(String baseDir, String subDir) {
        File file;
        String createDir = baseDir;
        if (subDir != null && !subDir.trim().equals("")) {
            createDir = createDir + File.separator + subDir;
        }
        if ((file = FilePathUtils.checkFile(new File(createDir))).exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static void convertFileToUTF8(String src, String dest) throws IOException {
        if (src == null || dest == null) {
            LOGGER.error("convertFileToUTF8 argument input is null");
            return;
        }
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            throw new FileNotFoundException(src);
        }
        if (srcFile.isDirectory()) {
            File[] files = srcFile.listFiles();
            if (files == null) {
                LOGGER.error("Target file is null");
                return;
            }
            for (File tmpFile : files) {
                if (tmpFile.isDirectory()) {
                    FileUtilsSupport.createDir(dest, tmpFile.getName());
                    FileUtilsSupport.convertFileToUTF8(tmpFile.getCanonicalPath(), dest + File.separator + tmpFile.getName());
                    continue;
                }
                FileUtilsSupport.convertOnlyFileToUTF8(tmpFile.getCanonicalPath(), dest + File.separator + tmpFile.getName());
            }
        } else {
            src = srcFile.getCanonicalPath();
            FileUtilsSupport.convertOnlyFileToUTF8(src, dest);
        }
    }

    private static void convertOnlyFileToUTF8(String src, String dest) throws IOException {
        File currentFile = new File(src);
        String storageEncoding = FileUtilsSupport.detect(currentFile);
        if (storageEncoding.equalsIgnoreCase("utf-8")) {
            LOGGER.info("{} is already UTF-8, skip it.", (Object)src);
            return;
        }
        String lowerName = dest.toLowerCase(new Locale("en"));
        if (lowerName.toLowerCase(Locale.ENGLISH).endsWith(".xml") || lowerName.toLowerCase(Locale.ENGLISH).endsWith(".dtd")) {
            FileUtilsSupport.convertXmlFileToUTF8(currentFile, dest, storageEncoding);
        } else if (lowerName.toLowerCase(Locale.ENGLISH).endsWith(".sql")) {
            FileUtilsSupport.convertTextFileToUTF8(currentFile, dest, storageEncoding);
        }
    }

    private static void convertTextFileToUTF8(File currentSrcFile, String outFilePath, String srcCharset) throws IOException {
        File tempOutFile = new File(outFilePath + TEMP_FILE_SUBFIX);
        if (tempOutFile.getParentFile().mkdirs()) {
            LOGGER.error("fail to mkdir: {}", (Object)tempOutFile.getParentFile());
        }
        ConvertFileEncode.convertFileEncode(currentSrcFile.getCanonicalPath(), tempOutFile.getCanonicalPath(), srcCharset, "utf-8");
        File outFile = new File(outFilePath);
        if (outFile.exists()) {
            FileUtils.forceDelete((File)outFile);
        }
        FileUtils.moveFile((File)tempOutFile, (File)outFile);
        LOGGER.error("convert {} succeed", (Object)currentSrcFile.getCanonicalPath());
    }

    private static String processXMLFirstLine(String temp, FileReader input) {
        if (temp.trim().startsWith("<?xml")) {
            String ens = FileUtilsSupport.getXmlEncoding(temp);
            if (temp.contains("encoding=") && ens != null && !ens.equalsIgnoreCase("utf-8")) {
                temp = temp.replaceFirst("encoding=[\"'](.*?)[\"']", "encoding=\"" + "utf-8" + "\"");
            }
            if (ens == null) {
                temp = temp.replaceFirst("\\?>", " encoding=\"" + "utf-8" + "\"?>");
            }
        } else if (!temp.equalsIgnoreCase("\r\n") && !temp.equalsIgnoreCase("\n")) {
            temp = "<?xml version=\"1.0\" encoding=\"" + "utf-8" + "\"?>" + input.getLineSep() + temp;
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertXmlFileToUTF8(File currentSrcFile, String outFilePath, String srcCharset) throws IOException {
        File tempOutFile = new File(outFilePath + TEMP_FILE_SUBFIX);
        if (tempOutFile.getParentFile().mkdirs()) {
            LOGGER.error("fail to mkdir: {}", (Object)tempOutFile.getParentFile());
        }
        FileReader input = null;
        FileInputStream instream = null;
        BufferedWriter outputWriter = null;
        FileOutputStream outstream = null;
        try {
            instream = new FileInputStream(currentSrcFile);
            input = new FileReader(instream, srcCharset);
            outstream = new FileOutputStream(tempOutFile);
            outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)outstream, "utf-8"));
            int lineNum = 0;
            String temp = input.readLine();
            while (temp != null) {
                if (!temp.trim().isEmpty()) {
                    if (lineNum == 0) {
                        temp = FileUtilsSupport.processXMLFirstLine(temp, input);
                    }
                    outputWriter.write(temp);
                    ++lineNum;
                }
                temp = input.readLine();
            }
            outputWriter.flush();
            outputWriter.close();
            outstream.flush();
            outstream.close();
            instream.close();
            File outFile = new File(outFilePath);
            if (outFile.exists()) {
                FileUtils.forceDelete((File)outFile);
            }
            FileUtils.moveFile((File)tempOutFile, (File)outFile);
            LOGGER.error("convert {} succeed", (Object)currentSrcFile);
        }
        catch (Throwable throwable) {
            FileUtilsSupport.checkOutstreamExcep(instream, outputWriter, outstream);
            throw throwable;
        }
        FileUtilsSupport.checkOutstreamExcep(instream, outputWriter, outstream);
    }

    private static void checkOutstreamExcep(FileInputStream instream, BufferedWriter outputWriter, FileOutputStream outstream) {
        if (instream != null) {
            try {
                instream.close();
            }
            catch (IOException e) {
                LOGGER.error("Close instream error");
            }
        }
        if (outputWriter != null) {
            try {
                outputWriter.close();
            }
            catch (IOException e) {
                LOGGER.error("Close BufferedWriter error");
            }
        }
        if (outstream != null) {
            try {
                outstream.close();
            }
            catch (IOException e) {
                LOGGER.error("Close outstream error");
            }
        }
    }

    private static String getXmlEncoding(String encoding) {
        String result = null;
        Pattern pattern = Pattern.compile("encoding=[\"'](.*?)[\"']");
        Matcher match = pattern.matcher(encoding);
        if (match.find()) {
            result = match.group(1);
        }
        return result;
    }

    private static String detectByFirst3Byte(BufferedInputStream in) throws IOException {
        in.mark(0);
        int chr1 = in.read();
        int chr2 = in.read();
        int chr3 = in.read();
        String str1 = Integer.toHexString(0xFF & chr1);
        String str2 = Integer.toHexString(0xFF & chr2);
        String str3 = Integer.toHexString(0xFF & chr3);
        String charset = null;
        if (str1.equalsIgnoreCase("FF") && str2.equalsIgnoreCase("FE")) {
            charset = "UnicodeLittle";
        }
        if (str1.equalsIgnoreCase("FE") && str2.equalsIgnoreCase("FF")) {
            charset = "UnicodeBig";
        }
        if (str1.equalsIgnoreCase("EF") && str2.equalsIgnoreCase("BB") && str3.equalsIgnoreCase("BF")) {
            charset = "utf-8";
        }
        in.reset();
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String detect(File file) throws IOException {
        BufferedInputStream in = null;
        try {
            int chr;
            in = new BufferedInputStream(new FileInputStream(file));
            in.mark(0);
            String charset = FileUtilsSupport.detectByFirst3Byte(in);
            if (charset != null) {
                String string = charset;
                return string;
            }
            boolean bAllAscii = true;
            int cOctets = 0;
            while ((chr = in.read()) != -1) {
                if ((chr & 0x80) != 0) {
                    bAllAscii = false;
                }
                if (cOctets == 0) {
                    if (chr < 128) continue;
                    do {
                        ++cOctets;
                    } while (((chr <<= 1) & 0x80) != 0);
                    if (--cOctets != 0) continue;
                    String string = "GBK";
                    return string;
                }
                if ((chr & 0xC0) != 128) {
                    String string = "GBK";
                    return string;
                }
                --cOctets;
            }
            if (cOctets > 0) {
                String string = "GBK";
                return string;
            }
            if (bAllAscii) {
                String string = "ASCII";
                return string;
            }
            String string = "utf-8";
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("Close BufferedInputStream error when detect file encoding.");
                }
            }
        }
    }

    public static String detectCharSet(File file) throws IOException {
        return FileUtilsSupport.detect(FilePathUtils.checkFile(file));
    }
}

