/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.oss.cn.common.util;

import com.huawei.oss.cn.common.ConstantSupport;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.Normalizer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtils.class);

    public static int getPid() {
        int pid = -1;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            pid = Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (NumberFormatException e) {
            LOGGER.error("get pid error, ", (Throwable)e);
        }
        return pid;
    }

    public static String getOSType() {
        String os = System.getProperty("os.name");
        LOGGER.info("OS is {}", (Object)os);
        if (os != null && (os = Normalizer.normalize(os, Normalizer.Form.NFKC)).toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            return "Windows";
        }
        return "Linux";
    }

    public static final String getAppPath(String appName) {
        return ConstantSupport.getHomePath() + File.separator + "app" + File.separator + appName;
    }

    public static final String getAppRepositoryPath(String appName) {
        return CommonUtils.getAppPath(appName) + File.separator + "repository" + File.separator;
    }

    public static final String getAppResourcePath(String appName) {
        return CommonUtils.getAppPath(appName) + File.separator + "i18n" + File.separator;
    }

    public static final String getAppConfigPath(String appName) {
        return CommonUtils.getAppPath(appName) + File.separator + "config" + File.separator;
    }

    public static final String getAppConfigDBPath(String appName) {
        return CommonUtils.getAppConfigPath(appName) + "db" + File.separator;
    }

    public static final String checkPath(String path) {
        String source = "abcdefghijklmnopqrstuvwxyz\\/.ABCD_EFGHIJKLMNOPQRSTUVWXYZ1234567890:_[]{}()`~@#$%^&+-;'";
        if (null == path) {
            return "";
        }
        int i = 0;
        StringBuffer filePath = new StringBuffer();
        for (i = 0; i < path.length(); ++i) {
            int index = source.indexOf(path.charAt(i));
            if (index == -1) continue;
            filePath.append(source.charAt(index));
        }
        return filePath.toString();
    }

    public static File createFile(String path) {
        File file = new File(path);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            LOGGER.error("create file error, ", (Throwable)e);
            return null;
        }
        if (!(file.setExecutable(false) && file.setReadable(true, true) && file.setWritable(true, true))) {
            LOGGER.error("create file permission error");
            return null;
        }
        return file;
    }

    public static String formatValidInput(String input, String whiteChList) {
        if (input == null) {
            return null;
        }
        char[] validChars = input.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(input.length());
        int idx = -1;
        for (int i = 0; i < validChars.length; ++i) {
            idx = whiteChList.indexOf(validChars[i]);
            if (idx == -1) {
                LOGGER.error("input contains invalied character '{}'", (Object)Character.valueOf(validChars[i]));
                return null;
            }
            stringBuilder.append(whiteChList.charAt(idx));
        }
        return stringBuilder.toString();
    }

    public static String getStringValue(Object object) {
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    public static void clearChar(char[] temp) {
        if (null != temp && temp.length > 0) {
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = '\u0000';
            }
        }
    }

    public static void safeClose(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error("close stream error");
            }
        }
    }
}

