/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.rest.service.cmd;

import com.huawei.baize.base.string.StringFormatUtils;
import com.huawei.smartkit.drop.protocol.rest.entity.Protocol;
import com.huawei.smartkit.drop.protocol.rest.entity.RestException;
import com.huawei.smartkit.drop.util.IpUtils;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnectionCmd {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestConnectionCmd.class);
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final String ip;
    private final int port;

    @NotNull
    public String toUrl() {
        if (this.port <= 0 || this.port > 65535) {
            log.error("Invalid port: {}", (Object)this.port);
            throw new RestException(StringFormatUtils.format((String)"port {} is out of range (0-65535)", (Object[])new Object[]{this.port}));
        }
        return StringFormatUtils.format((String)"{}{}:{}", (Object[])new Object[]{this.protocol.getRequestUri(), this.ipUri(), this.port});
    }

    private String ipUri() {
        if (IpUtils.isValidIpV4((String)this.ip)) {
            return this.ip;
        }
        if (IpUtils.isValidIpV6((String)this.ip)) {
            return StringFormatUtils.format((String)"[{}]", (Object[])new Object[]{this.ip});
        }
        log.error("Invalid ip: {}", (Object)this.ip);
        throw new RestException(StringFormatUtils.format((String)"Invalid ip: {}", (Object[])new Object[]{this.ip}));
    }

    @Generated
    private static Protocol $default$protocol() {
        return Protocol.HTTPS;
    }

    @Generated
    RestConnectionCmd(@NotNull Protocol protocol, @NotNull String ip, int port) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        if (ip == null) {
            throw new NullPointerException("ip is marked non-null but is null");
        }
        this.protocol = protocol;
        this.ip = ip;
        this.port = port;
    }

    @Generated
    public static RestConnectionCmdBuilder builder() {
        return new RestConnectionCmdBuilder();
    }

    @NotNull
    @Generated
    public Protocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public static class RestConnectionCmdBuilder {
        @Generated
        private boolean protocol$set;
        @Generated
        private Protocol protocol$value;
        @Generated
        private String ip;
        @Generated
        private int port;

        @Generated
        RestConnectionCmdBuilder() {
        }

        @Generated
        public RestConnectionCmdBuilder protocol(@NotNull Protocol protocol) {
            this.protocol$value = protocol;
            this.protocol$set = true;
            return this;
        }

        @Generated
        public RestConnectionCmdBuilder ip(@NotNull String ip) {
            this.ip = ip;
            return this;
        }

        @Generated
        public RestConnectionCmdBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public RestConnectionCmd build() {
            Protocol protocol$value = this.protocol$value;
            if (!this.protocol$set) {
                protocol$value = RestConnectionCmd.$default$protocol();
            }
            return new RestConnectionCmd(protocol$value, this.ip, this.port);
        }

        @Generated
        public String toString() {
            return "RestConnectionCmd.RestConnectionCmdBuilder(protocol$value=" + (Object)((Object)this.protocol$value) + ", ip=" + this.ip + ", port=" + this.port + ")";
        }
    }
}

