/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common;

import com.huawei.ism.common.IDataChangeListener;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.message.IMsgHandler;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.model.MOType;
import com.huawei.ism.notification.ChangeInfo;
import com.huawei.ism.service.CommonWorkTaker;
import com.huawei.ism.service.Datacache;
import com.huawei.ism.thread.ThreadPoolManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UIController
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIController.class);
    private static UIController singleton = new UIController();
    private final Collection<IDataChangeListener> eventListeners;
    private BlockingQueue<ChangeInfo> changedDevices = new LinkedBlockingQueue<ChangeInfo>();

    private UIController() {
        this.eventListeners = Collections.synchronizedCollection(new ArrayList(0));
        ThreadPoolManager.getInstance().executeAndLogException(this, "Launcher Changed Processor");
        IsmMsgManager.getInstance().registerIsmMsgHandle("MSG_TYPE_COMPONENT_CHANGE", this.getMsgHandler());
    }

    private IMsgHandler getMsgHandler() {
        return new IMsgHandler(){

            @Override
            public void handleMsg(IsmMsg ismMsg) {
                if (ismMsg.getProperty("PROPERTY_CHANGEINFO") != null) {
                    ChangeInfo info = (ChangeInfo)ismMsg.getProperty("PROPERTY_CHANGEINFO");
                    UIController.this.objectChanged(info);
                } else if (ismMsg.getProperty("DEVICE_ID") != null) {
                    String deviceID = (String)ismMsg.getProperty("DEVICE_ID");
                    UIController.this.objectChanged(deviceID);
                }
            }
        };
    }

    public static UIController getInstance() {
        return singleton;
    }

    public void objectChanged(ChangeInfo info) {
        this.changedDevices.add(info);
    }

    public void objectChanged(String deviceID) {
        this.objectChanged(ChangeInfo.getChangeInfo(deviceID));
    }

    @Override
    public void run() {
        Set<String> changedDeviceIDs = null;
        while (true) {
            try {
                while (true) {
                    if (!(changedDeviceIDs = this.getChangedDevices()).isEmpty()) {
                        this.fireDataChanged(changedDeviceIDs);
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (Throwable e) {
                LOGGER.error("Update UI error:" + e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    private Set<String> getChangedDevices() {
        HashSet<String> launchers = new HashSet<String>(0);
        ChangeInfo info = null;
        boolean isSapshotDirty = false;
        boolean isLUNDirty = false;
        try {
            info = this.changedDevices.take();
            Launcher launcher = null;
            while (null != info) {
                launcher = LauncherManager.getInstance().findDeviceOwner(info.getDeviceID());
                if (launcher == null) {
                    return launchers;
                }
                launchers.add(launcher.getDeviceID());
                if (info.getUUID() != null) {
                    Datacache.getInstance().setDirtyTag(info.getUUID());
                } else if (info.getMoType() != -1) {
                    Datacache.getInstance().setDirtyTag(info.getDeviceID(), info.getMoType());
                    isLUNDirty = this.isHasObject(isLUNDirty, info, MOType.LUN);
                    isSapshotDirty = this.isHasObject(isSapshotDirty, info, MOType.SNAPSHOT);
                }
                info = (ChangeInfo)this.changedDevices.poll();
            }
            if (null != launcher) {
                this.refreshCache(isLUNDirty, isSapshotDirty, launcher.getDeviceID());
            }
        }
        catch (Throwable e) {
            LOGGER.error("", e);
        }
        return launchers;
    }

    private boolean isHasObject(boolean isLUNDirty, ChangeInfo info, MOType type) {
        if (isLUNDirty) {
            return true;
        }
        return info.getMoType() != -1 && type.getValue() == info.getMoType();
    }

    private void refreshCache(boolean isLUNDirty, boolean isSapshotDirty, String deviceID) {
        if (isLUNDirty) {
            CommonWorkTaker.getInstance().retrieveMOs(deviceID, MOType.LUN, CommonWorkTaker.EGetDataMode.FromDevice);
        }
        if (isSapshotDirty) {
            CommonWorkTaker.getInstance().retrieveMOs(deviceID, MOType.SNAPSHOT, CommonWorkTaker.EGetDataMode.FromDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataChangeListener(IDataChangeListener dataChangeListener) {
        Collection<IDataChangeListener> collection = this.eventListeners;
        synchronized (collection) {
            this.eventListeners.add(dataChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataChangeListener(IDataChangeListener dataChangeListener) {
        Collection<IDataChangeListener> collection = this.eventListeners;
        synchronized (collection) {
            this.eventListeners.remove(dataChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataChanged(Set<String> changedDeviceIDs) {
        Collection<IDataChangeListener> collection = this.eventListeners;
        synchronized (collection) {
            IDataChangeListener changeListener2 = null;
            for (IDataChangeListener changeListener2 : this.eventListeners) {
                changeListener2.dataChanged(new IDataChangeListener.DataChangeEvent(this, changedDeviceIDs));
            }
        }
    }
}

