/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.bean;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PerfStatObjectType {
    private ObjectTypeEnum objectType;
    private List<DataTypeEnum> dataTypeList = new ArrayList<DataTypeEnum>(0);
    private List<TimeSpanEnum> timeSpanList = new ArrayList<TimeSpanEnum>(0);
    private int sampleInterval;

    public ObjectTypeEnum getType() {
        return this.objectType;
    }

    public void setType(ObjectTypeEnum objectTypeIn) {
        this.objectType = objectTypeIn;
    }

    public List<DataTypeEnum> getDataTypeList() {
        return this.getDataTypeSortList(this.dataTypeList);
    }

    public List<DataTypeEnum> getDataTypeSortList(List<DataTypeEnum> inList) {
        ArrayList<DataTypeEnum> list = new ArrayList<DataTypeEnum>(0);
        if (null == inList) {
            return list;
        }
        Collections.sort(inList, new MyComparator());
        list.addAll(inList);
        return list;
    }

    public DataTypeEnum getDataType(int index) {
        if (index >= 0 && index < this.dataTypeList.size()) {
            return this.dataTypeList.get(index);
        }
        return null;
    }

    public void addDataTypeList(List<DataTypeEnum> dataTypesList) {
        if (null != dataTypesList) {
            this.dataTypeList.addAll(dataTypesList);
        }
    }

    public void addDataType(DataTypeEnum dataType) {
        this.dataTypeList.add(dataType);
    }

    public List<TimeSpanEnum> getTimeSpanList() {
        return new ArrayList<TimeSpanEnum>(this.timeSpanList);
    }

    public TimeSpanEnum getTimeSpan(int indexIn) {
        if (indexIn >= 0 && indexIn < this.timeSpanList.size()) {
            return this.timeSpanList.get(indexIn);
        }
        return null;
    }

    public void addTimeSpan(List<TimeSpanEnum> periodList) {
        if (null != periodList) {
            this.timeSpanList.addAll(periodList);
        }
    }

    public void addTimeSpan(TimeSpanEnum period) {
        this.timeSpanList.add(period);
    }

    public void setTimeSpan(List<TimeSpanEnum> timeSpans) {
        this.timeSpanList.clear();
        this.timeSpanList.addAll(timeSpans);
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public void setSampleInterval(int sampleInterval) {
        this.sampleInterval = sampleInterval;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PerfStatObjectType)) {
            return false;
        }
        PerfStatObjectType other = (PerfStatObjectType)object;
        return this.getType().equals((Object)other.getType());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("ObjectType", (Object)(this.objectType == null ? "null" : this.objectType.name())).append("DataType", this.dataTypeList).append("Period", this.timeSpanList).append("SamplingInterval", this.objectType == null ? "null" : Integer.valueOf(this.sampleInterval)).toString();
    }

    public int hashCode() {
        if (null == this.objectType) {
            return "null".hashCode();
        }
        return this.objectType.hashCode();
    }

    public static enum TimeSpanEnum {
        None(0),
        Month(1),
        Day(2),
        HalfHour(3),
        Minute(4),
        Year(5);

        private int timeValue;

        private TimeSpanEnum(int value) {
            this.timeValue = value;
        }

        public int getValue() {
            return this.timeValue;
        }

        public long getMilliSecond() {
            int second = 1;
            switch (this) {
                case Minute: {
                    second = 60;
                    break;
                }
                case HalfHour: {
                    second = 1800;
                    break;
                }
                case Day: {
                    second = 86400;
                    break;
                }
                case Month: {
                    second = 2592000;
                    break;
                }
                case Year: {
                    second = 31536000;
                    break;
                }
            }
            return (long)second * 1000L;
        }

        public String getDescription() {
            return ResourceManager.getString(this.toString());
        }

        public static TimeSpanEnum valueOf(int intValue) throws IsmException {
            TimeSpanEnum[] values;
            for (TimeSpanEnum value : values = TimeSpanEnum.values()) {
                if (value.timeValue != intValue) continue;
                return value;
            }
            throw new IsmException(-1L, "wrong StatisticPeriod value ! type:" + intValue);
        }

        public long getSamplingInterval() {
            int second = 1;
            switch (this) {
                case Minute: {
                    second = 2;
                    break;
                }
                case HalfHour: {
                    second = 60;
                    break;
                }
                case Day: {
                    second = 1800;
                    break;
                }
                case Month: {
                    second = 86400;
                    break;
                }
                case Year: {
                    second = 2592000;
                    break;
                }
            }
            return (long)second * 1000L;
        }
    }

    public static enum DataTypeEnum {
        TOTAL_IO_COUNT(1),
        READ_IO_RATIO(2),
        WRITE_IO_RATIO(3),
        CURRENT_BAND_WIDTH(4),
        MAX_BAND_WIDTH(5),
        CURRENT_IOPS(6),
        MAX_IOPS(7),
        MAX_LATENCY(8),
        AVERAGE_LATENCY(9),
        CACHE_HIT(10),
        LOCAL_WRITE_CACHE_RATIO(11),
        MIRROR_WRITE_CACHE_RATIO(12),
        READ_IO_TRAFFIC(13),
        WRITE_IO_TRAFFIC(14),
        MAX_POWER_CONSUME(15),
        AVG_POWER_CONSUME(16),
        MIN_POWER_CONSUME(17),
        USAGE(18),
        QUEUE_SIZE(19),
        RESPONSE_TIME(20),
        BAND_WIDTH(21),
        THROUGHPUT(22),
        READ_BAND_WIDTH(23),
        AVERAGE_READ_IO(24),
        READ_THROUGHPUT(25),
        WRITE_BAND_WIDTH(26),
        AVERAGE_WRITE_IO(27),
        WIRTE_THROUGHPUT(28),
        SERVICE_TIME(29),
        READ_IO_STATISTICS_512_B(30),
        READ_IO_STATISTICS_1_KB(31),
        READ_IO_STATISTICS_2_KB(32),
        READ_IO_STATISTICS_4_KB(33),
        READ_IO_STATISTICS_8_KB(34),
        READ_IO_STATISTICS_16_KB(35),
        READ_IO_STATISTICS_32_KB(36),
        READ_IO_STATISTICS_64_KB(37),
        READ_IO_STATISTICS_128_KB(38),
        READ_IO_STATISTICS_256_KB(39),
        READ_IO_STATISTICS_512_KB(40),
        WRITE_IO_STATISTICS_512_B(41),
        WRITE_IO_STATISTICS_1_KB(42),
        WRITE_IO_STATISTICS_2_KB(43),
        WRITE_IO_STATISTICS_4_KB(44),
        WRITE_IO_STATISTICS_8_KB(45),
        WRITE_IO_STATISTICS_16_KB(46),
        WRITE_IO_STATISTICS_32_KB(47),
        WRITE_IO_STATISTICS_64_KB(48),
        WRITE_IO_STATISTICS_128_KB(49),
        WRITE_IO_STATISTICS_256_KB(50),
        WRITE_IO_STATISTICS_512_KB(51),
        READ_WRITE_IO_STATISTICS_512_B(52),
        READ_WRITE_IO_STATISTICS_1_KB(53),
        READ_WRITE_IO_STATISTICS_2_KB(54),
        READ_WRITE_IO_STATISTICS_4_KB(55),
        READ_WRITE_IO_STATISTICS_8_KB(56),
        READ_WRITE_IO_STATISTICS_16_KB(57),
        READ_WRITE_IO_STATISTICS_32_KB(58),
        READ_WRITE_IO_STATISTICS_64_KB(59),
        READ_WRITE_IO_STATISTICS_128_KB(60),
        READ_WRITE_IO_STATISTICS_256_KB(61),
        READ_WRITE_IO_STATISTICS_512_KB(62),
        WRITE_IO_IN_PERIOD(63),
        READ_IO_IN_PERIOD(64),
        RANDOM_SEQUENCE_RATIO(65),
        USAGE_2(66),
        READ_BAND_WIDTH_USAGE(67),
        CPU_USAGE(68),
        MEMORY_USAGE(69),
        SWAP_USAGE(70),
        NET_READ_TRAFFIC(71),
        NET_WRITE_TRAFFIC(72),
        NET_IN_PACKAGE(73),
        NET_OUT_PACKAGE(74),
        WORK_TEMPERTURE(75),
        POWER_CONSUME(76),
        VOLTAGE(77),
        AVERAGE_IO_RESPONSE_TIME(78),
        MAX_IO_RESPONSE_TIME(79),
        DIRTY_PAGE_RATIO(80),
        REFRESH_CACHE_DIVIDE_WRITE_REQUEST(81),
        REFRESH_CACHE_BAND_WIDTH(82),
        REFRESH_CACHE_BECAUSE_HIGHT_WATER(83),
        REFRESH_CACHE_BECAUSE_SCHEDULE_TIMER(84),
        CACHE_LOW_WATER(85),
        MAX_BAND_WIDTH_WRITE(86),
        FETCH_FLUX(87),
        FETCH_RATIO(88),
        READ_CACHE_HIT(89),
        READ_CACHE_NOT_HIT(90),
        READ_CACHE_HIT_WHEN_WRITE(91),
        READ_CACHE_HIT_WHEN_READ(92),
        READ_CACHE_RATIO(93),
        READ_CACHE_RE_HIT_RATIO(94),
        WRITE_CACHE_HIT_RATIO(95),
        WRITE_CACHE_RE_HIT_RATIO(96),
        WRITE_CACHE_HIT(97),
        WRITE_CACHE_NOT_HIT(98),
        ASYNC_TIME(99),
        ASYNC_DATA(100),
        READE_REQUEST_CNT_FROM_SNAPSHOT(101),
        READE_REQUEST_CNT_FROM_SOURCE_LUN(102),
        WRITE_REQUEST_CNT_FROM_SOURCE_LUN(103),
        READ_REQUEST_CNT_SNAPSHOT_POOL(104),
        WRITE_REQUEST_CNT_SNAPSHOT_POOL(105),
        WRITE_REQUEST_CNT_MORETHAN_CHUNK(106),
        CHUNK_CNT_USED_BY_SNAPSHOT_COPY(107),
        LOCAL_CACHE_USAGE(108),
        MIRROR_CACHE_USAGE(109),
        LOCAL_READ_CACHE_RATIO(110),
        TIME_FOR_HOST_TO_SEND_DATA(111),
        TIME_FOR_SAVING_WRITE_DATA(112),
        TIME_FOR_RELEASING_WRITE_REQUEST_RESOURCES(113),
        TIME_FOR_EXECUTING_A_WRITE_REQUEST(114),
        TIME_FOR_RELEASING_READ_REQUEST_RESOURCES(115),
        CACHE_READ_IO_LATENCY(116),
        CACHE_WRITE_IO_LATENCY(117),
        CACHE_MIRROR_IO_LATENCY(118),
        TIME_FOR_ALLOCATING_MEMORY_TO_A_WRITE_REQUEST(119),
        CACHE_WRITE_USAGE(120),
        NUMBER_OF_CACHE_DATA_FLUSH_IO(121),
        NUMBER_OF_CACHE_DATA_FLUSH_PAGES(122),
        READ_BANDWIDTH_KB(123),
        WRITE_BANDWIDTH_KB(124),
        AVERAGE_READ_IO_CONTROLLER_A(125),
        AVERAGE_WRITE_IO_CONTROLLER_A(126),
        MAX_IO_LATENCY_CONTROLLER_A(127),
        AVERAGE_IO_LATENCY_CONTROLLER_A(128),
        USAGE_RATIO_CONTROLLER_A(129),
        QUEUE_LENGTH_CONTROLLER_A(130),
        SERVICE_TIME_CONTROLLER_A(131),
        NUMBER_OF_COMBINED_READ_IOS_PER_SECOND_CONTROLLER_A(132),
        NUMBER_OF_COMBINED_WRITE_IOS_PER_SECOND_CONTROLLER_A(133),
        READ_WAITING_TIME_CONTROLLER_A(134),
        WRITE_WAITING_TIME_CONTROLLER_A(135),
        AVERAGE_IO_SIZE_CONTROLLER_A(136),
        AVERAGE_READ_IO_CONTROLLER_B(137),
        AVERAGE_WRITE_IO_CONTROLLER_B(138),
        MAX_IO_LATENCY_CONTROLLER_B(139),
        AVERAGE_IO_LATENCY_CONTROLLER_B(140),
        USAGE_RATIO_CONTROLLER_B(141),
        QUEUE_LENGTH_CONTROLLER_B(142),
        SERVICE_TIME_CONTROLLER_B(143),
        NUMBER_OF_COMBINED_READ_IOS_PER_SECOND_CONTROLLER_B(144),
        NUMBER_OF_COMBINED_WRITE_IOS_PER_SECOND_CONTROLLER_B(145),
        READ_WAITING_TIME_CONTROLLER_B(146),
        WRITE_WAITING_TIME_CONTROLLER_B(147),
        AVERAGE_IO_SIZE_CONTROLLER_B(148),
        READ_IO_GRANULARITY_DISTRIBUTION_4_KB(149),
        READ_IO_GRANULARITY_DISTRIBUTION_8_KB(150),
        READ_IO_GRANULARITY_DISTRIBUTION_16_KB(151),
        READ_IO_GRANULARITY_DISTRIBUTION_32_KB(152),
        READ_IO_GRANULARITY_DISTRIBUTION_64_KB(153),
        READ_IO_GRANULARITY_DISTRIBUTION_128_KB(154),
        READ_IO_GRANULARITY_DISTRIBUTION_256_KB(155),
        READ_IO_GRANULARITY_DISTRIBUTION_512_KB(156),
        READ_IO_GRANULARITY_DISTRIBUTION_1_MB(157),
        READ_IO_GRANULARITY_DISTRIBUTION_2_MB(158),
        READ_IO_GRANULARITY_DISTRIBUTION_MORE_THAN_2_MB(159),
        WRITE_IO_GRANULARITY_DISTRIBUTION_4_KB(160),
        WRITE_IO_GRANULARITY_DISTRIBUTION_8_KB(161),
        WRITE_IO_GRANULARITY_DISTRIBUTION_16_KB(162),
        WRITE_IO_GRANULARITY_DISTRIBUTION_32_KB(163),
        WRITE_IO_GRANULARITY_DISTRIBUTION_64_KB(164),
        WRITE_IO_GRANULARITY_DISTRIBUTION_128_KB(165),
        WRITE_IO_GRANULARITY_DISTRIBUTION_256_KB(166),
        WRITE_IO_GRANULARITY_DISTRIBUTION_512_KB(167),
        WRITE_IO_GRANULARITY_DISTRIBUTION_1_MB(168),
        WRITE_IO_GRANULARITY_DISTRIBUTION_2_MB(169),
        WRITE_IO_GRANULARITY_DISTRIBUTION_MORE_THAN_2_MB(170),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_4_KB(171),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_8_KB(172),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_16_KB(173),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_32_KB(174),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_64_KB(175),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_128_KB(176),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_256_KB(177),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_512_KB(178),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_1_MB(179),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_2_MB(180),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_MORE_THAN_2_MB(181),
        OPS(182),
        NUMBEROF_ONLINE_USER(183),
        FILE_SPACE_HARD_QUOTA(184),
        USED_CAPACITY(185),
        TOTAL_CAPACITY(186),
        DEDUPE_RATE(187),
        DISK_BUSY_RATIO(192),
        PACKAGES_RATE(193),
        RVG_BAND_WIDTH(194),
        ERROR_PACKAGE(190),
        DROPPED_PACKAGE(189),
        OVERRUN_PACKAGE(191),
        X_FER_PACKAGE(188),
        MAX_READ_IO_LATENCY(195),
        MAX_WRITE_IO_LATENCY(196),
        AVERAGE_READ_IO_LATENCY(197),
        AVERAGE_WRITE_IO_LATENCY(198),
        READ_IO_LATENCY_DISTRIBUTION_10_MS(199),
        READ_IO_LATENCY_DISTRIBUTION_20_MS(200),
        READ_IO_LATENCY_DISTRIBUTION_50_MS(201),
        READ_IO_LATENCY_DISTRIBUTION_100_MS(202),
        READ_IO_LATENCY_DISTRIBUTION_200_MS(203),
        READ_IO_LATENCY_DISTRIBUTION_MORE_THAN_200_MS(204),
        WRITE_IO_LATENCY_DISTRIBUTION_10_MS(205),
        WRITE_IO_LATENCY_DISTRIBUTION_20_MS(206),
        WRITE_IO_LATENCY_DISTRIBUTION_50_MS(207),
        WRITE_IO_LATENCY_DISTRIBUTION_100_MS(208),
        WRITE_IO_LATENCY_DISTRIBUTION_200_MS(209),
        WRITE_IO_LATENCY_DISTRIBUTION_MORE_THAN_200_MS(210),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_10_MS(211),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_20_MS(212),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_50_MS(213),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_100_MS(214),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_200_MS(215),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_MORE_THAN_200_MS(216),
        MAX_CPU_USAGE(217),
        MAX_MEMORY_USAGE(218),
        NFS_BANDWIDTH(219),
        NFS_IN_BANDWIDTH(220),
        NFS_OUT_BANDWIDTH(221),
        CIFS_BANDWIDTH(222),
        CIFS_IN_BANDWIDTH(223),
        CIFS_OUT_BANDWIDTH(224),
        CONNECTED_CLIENT_COUNT(225),
        CONNECTED_NFS_CLIENT_COUNT(226),
        CONNECTED_CIFS_CLIENT_COUNT(227),
        AVERAGE_IO_SIZE(228),
        NETWORK_PACKET_RATE(229),
        NETWORK_INBOUND_PACKET_RATE(230),
        NETWORK_OUTBOUND_PACKET_RATE(231),
        READ_OPS(232),
        WRITE_OPS(233),
        CLOUD_COPY_BAND_WIDTH(236),
        READ_L2_CACHE_HIT(237),
        READ_L2_CACHE_NOT_HIT(238),
        READ_L2_CACHE_HIT_RATIO(239),
        AVERAGE_QUEUE_SIZE(240),
        COMPLETE_SCSI_COMMANDS_PER_SECOND(241),
        VERIFY_COMMANDS_PER_SECOND(242),
        DISK_TOTAL_CAPACITY(243),
        DISK_ALLOCED_CAPACITY(244),
        DISK_ALLOCED_USAGE(245),
        DISK_FREE_USAGE(246),
        WP_COUNT(247),
        WP_LIMIT(248),
        WP_UTILIZATION(249),
        CACHE_USED(250),
        HOST_HIT(251),
        HOST_READ_HIT(252),
        HOST_WRITE_HIT(253),
        HOST_MISS(254),
        HOST_READ_MISS(255),
        HOST_WRITE_MISS(256),
        BE_REQ(257),
        BE_READ_REQ(258),
        BE_WRITE_REQ(259),
        BEM_BSTRANSFERRED(260),
        BEM_BS_READ(261),
        BEM_BS_WRITTEN(262),
        READ_MISS_RESPONSE_TIME(263),
        WRITE_MISS_RESPONSE_TIME(264),
        READ_PERCENT(265),
        WRITE_PERCENT(266),
        READ_HIT_PERCENT(267),
        WRITE_HIT_PERCENT(268),
        READ_MISS_PERCENT(269),
        WRITE_MISS_PERCENT(270),
        BE_READ_REQUEST_TIME(271),
        BE_DISK_READ_RESPONSE_TIME(272),
        BE_READ_TASK_TIME(273),
        BE_READ_RESPONSE_TIME(274),
        BE_WRITE_RESPONSE_TIME(275),
        BE_AVG_RESPONSE_TIME(276),
        BE_READS_PERCENT(277),
        BE_WRITES_PERCENT(278),
        REQUEST(279),
        READ_REQUEST(280),
        WRITE_REQUEST(281),
        READ_HIT_REQUEST(282),
        WRITE_HIT_REQUEST(283),
        MISS_REQUEST(284),
        READ_MISS_REQUEST(285),
        WRITE_MISS_REQUEST(286),
        READ_REQUEST_PERCENT(287),
        WRITE_REQUEST_PERCENT(288),
        HIT_REQUEST_PERCENT(289),
        READ_REQUEST_HIT_PERCENT(290),
        IOS(291),
        REQUESTS(292),
        READ_REQUESTS(293),
        WRITE_REQUESTS(294),
        FLOW(295),
        PORT_FLOW(296),
        PORT_IOS(297),
        READ_FLOW(298),
        WRITTEN_FLOW(299),
        PORT_AVG_REQ_SIZE(300),
        MAX_WP_THRESHOLD(301),
        RANDOM_HITS(302),
        HIT_PERCENT(303),
        MISSERCENT(304),
        RANDOM_READS_PERCENT(305),
        RANDOM_WRITES_PERCENT(306),
        MAX_IOPSS_PER_SEC(307),
        FAILED_IOS(308),
        FAILED_IOS_PER_SEC(309),
        FAILED_IO_RATIO(310),
        CACHE_WATER(333);

        private int value;

        private DataTypeEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return ResourceManager.getString(this.toString());
        }

        public String getUnitDesc() {
            return this.getUnitDesc(false);
        }

        public String getUnitDesc(boolean isXVEDevice) {
            String result;
            if (isXVEDevice && !"--".equals(result = ResourceManager.getString("XVE_" + this.toString() + "_unit"))) {
                return result;
            }
            return ResourceManager.getString(this.toString() + "_unit");
        }

        public static DataTypeEnum valueOf(int intValue) throws IsmException {
            DataTypeEnum[] values;
            for (DataTypeEnum value : values = DataTypeEnum.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            throw new IsmException(-1L, "wrong DataType value ! type:" + intValue);
        }
    }

    public static enum ObjectTypeEnum {
        ARRAY(2),
        CONTROLLER(3),
        TARGET_PORT(6),
        BACK_END_PORT(7),
        DISK(10),
        LUN(11),
        LINK(13),
        HOST_GROUP(14),
        RAID(15),
        CPU(16),
        HOST(21),
        POWER_SUPPLY(23),
        CPU_CORE(24),
        NODE(25),
        FAN_CHASSIS(26),
        SNAPSHOT(27),
        HYPER_MIRROR(28),
        HYPER_COPY(29),
        THIN_POOL(30),
        DEVICE(31),
        DISK_GROUP(40),
        HOST_ISCSI_PORT(41),
        SYSTEMRESOURCEPOOL(43),
        CLOUDCOPY(44),
        SYSTEM(201),
        ENCLOSURE(206),
        CONTROLLER2(207),
        FC_PORT(212),
        ETH_PORT(213),
        SAS_PORT(214),
        STORAGEPOOL(216),
        STORAGETIER(217),
        LUNCOPY(219),
        FC_LINK(225),
        IOCLASS(230),
        MEMORY(237),
        ISCSI_LINK(243),
        MAPPINGVIEW(245),
        FCOE_PORT(252),
        LUN_GROUP(256),
        PORT_GROUP(257),
        NETGROUP(259),
        SUBNET(258),
        DNS_SERVER(260),
        IP_LINK(261),
        USERGROUP(262),
        REPLICATIONPAIR(263),
        LUNBACKGROUDTASK(265),
        DISKPOOL(266),
        STORAGEENGINE(267),
        CACHEPARTITION(268),
        IOCLASSTEMPLATE(269),
        LUN_DESTROY_DATA(270),
        DISK_DESTROY_DATA(271),
        LUN_PRIORITY_STATISTIC(272),
        SMART_CACHE_PARTITION(273),
        DISK_SCAN_TASK(274),
        SNAS_SYSTEM(16384),
        SNAS_NODE(16385),
        PROTOCOL_CLUSTER(16386),
        PROTOCOL_CLUSTER_NODE(16387),
        PROTOCOL_CLUSTER_ZONE(16388),
        SNAS_IP_POOL(16389),
        SNAS_DNS_CONFIG(16391),
        SNAS_CLIENT(16390),
        SNAS_LOCAL_USER(16392),
        SNAS_USERANDGROUP(16394),
        SNAS_LOCAL_GROUP(16393),
        SNAS_IDMAP_CONFIG(16395),
        SNAS_NODE_FS_SERV(16397),
        SNAS_ROOT_USER(16396),
        SNAS_NODE_SHARE_SERV(16398),
        SNAS_FILE(16400),
        SNAS_CIFS_SERVICE(16399),
        SNAS_NFS_SHARE(16401),
        SNAS_CIFS_SHARE(16402),
        SNAS_USER_QUOTA(16403),
        SNAS_CIFS_SHARE_AUTH_CLIENT(16404),
        SNAS_TASK(16406),
        DATA_RECOVER_SCHEDULE(16405),
        SNAS_KEY_VALUE_STORE(16407),
        SNAS_NFS_SHARE_AUTH_CLIENT(16409),
        SNAS_FILE_QUOTA(16408),
        SNAS_ACL_STRATEGY(16410),
        SNAS_LOCAL_AUTH(16411),
        SNAS_LDAP_CONFIG(16413),
        SNAS_NIS_CONFIG(16412),
        SNAS_AD_CONFIG(16414),
        SNAS_SYS_WATERLEVEL(16415),
        SNAS_ALARM_VOICE(16417),
        SNAS_SYS_ENERGY_SAVING(16416),
        SNAS_SECURITY_POLICY(16418),
        SNAS_HEARTBEAT(16419),
        SNAS_HANDSHAKE(16420),
        SNAS_MGR_NODE(16421),
        SNAS_NODE_PERFORMANCE(16422),
        SNAS_SECURITY_SMTP(16423),
        NOFS(53248);

        private int sortValue = -1;
        private int value;

        private ObjectTypeEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return ResourceManager.getString(this.toString());
        }

        public static ObjectTypeEnum valueOf(int intValue) throws IsmException {
            ObjectTypeEnum[] values;
            for (ObjectTypeEnum value : values = ObjectTypeEnum.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            throw new IsmException(-1L, "wrong StatisticObjectType value ! type:" + intValue);
        }

        private void setSortValue(int sortValue) {
            this.sortValue = sortValue;
        }

        public int getSortValue() {
            return this.sortValue;
        }

        static {
            int sortValue = 1;
            ARRAY.setSortValue(sortValue++);
            CONTROLLER.setSortValue(sortValue++);
            CONTROLLER2.setSortValue(sortValue++);
            LINK.setSortValue(sortValue++);
            TARGET_PORT.setSortValue(sortValue++);
            BACK_END_PORT.setSortValue(sortValue++);
            DISK.setSortValue(sortValue++);
            NODE.setSortValue(sortValue++);
            CPU.setSortValue(sortValue++);
            CPU_CORE.setSortValue(sortValue++);
            POWER_SUPPLY.setSortValue(sortValue++);
            FAN_CHASSIS.setSortValue(sortValue++);
            FC_PORT.setSortValue(sortValue++);
            ETH_PORT.setSortValue(sortValue++);
            sortValue = 256;
            RAID.setSortValue(sortValue++);
            STORAGEPOOL.setSortValue(sortValue++);
            STORAGETIER.setSortValue(sortValue++);
            THIN_POOL.setSortValue(sortValue++);
            DEVICE.setSortValue(sortValue++);
            LUN.setSortValue(sortValue++);
            SNAPSHOT.setSortValue(sortValue++);
            HYPER_COPY.setSortValue(sortValue++);
            LUNCOPY.setSortValue(sortValue++);
            HYPER_MIRROR.setSortValue(sortValue++);
            SYSTEMRESOURCEPOOL.setSortValue(sortValue++);
            sortValue = 65536;
            HOST_GROUP.setSortValue(sortValue++);
            HOST.setSortValue(sortValue++);
            IOCLASS.setSortValue(sortValue++);
            MAPPINGVIEW.setSortValue(sortValue++);
            FC_LINK.setSortValue(sortValue++);
            ISCSI_LINK.setSortValue(sortValue++);
        }
    }

    private static final class MyComparator
    implements Comparator<DataTypeEnum>,
    Serializable {
        private static final long serialVersionUID = 4698234259627238960L;

        private MyComparator() {
        }

        @Override
        public int compare(DataTypeEnum arg0, DataTypeEnum arg1) {
            if (arg0.getValue() > arg1.getValue()) {
                return 1;
            }
            return 0;
        }
    }
}

