/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.entity.alarm;

import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AlarmSyslogConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4427198567467025132L;
    private Event.Level alarmLevel;
    private transient List<String> receiveIps = new ArrayList<String>(0);
    private String arrayId;
    private boolean enableState;
    private String patternStr;

    public AlarmSyslogConfig(String arrayId, boolean enableState, Event.Level level, Collection<String> receiveIps) {
        this(arrayId, enableState, level, "", receiveIps);
    }

    public AlarmSyslogConfig(String arrayId, boolean enableState, Event.Level level, String patternStrIn, Collection<String> receiveIps) {
        this.arrayId = arrayId;
        this.enableState = enableState;
        this.alarmLevel = level;
        this.patternStr = patternStrIn;
        this.receiveIps.addAll(receiveIps);
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object == this) {
            isEqual = true;
        } else if (object == null) {
            isEqual = false;
        } else if (object instanceof AlarmSyslogConfig) {
            AlarmSyslogConfig config = (AlarmSyslogConfig)object;
            if (this.arrayId.equals(config.arrayId) && this.enableState == config.enableState && this.alarmLevel.equals((Object)config.alarmLevel) && String.valueOf(this.patternStr).equals(config.patternStr) && this.receiveIps.equals(config.receiveIps)) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public Event.Level getAlarmLevel() {
        return this.alarmLevel;
    }

    public String getArrayId() {
        return this.arrayId;
    }

    public void setDeviceID(String deviceID) {
        this.arrayId = deviceID;
    }

    public synchronized Collection<String> getReceiveIps() {
        ArrayList<String> receiveNumbers = new ArrayList<String>(0);
        receiveNumbers.addAll(this.receiveIps);
        return receiveNumbers;
    }

    public String getPatternStr() {
        return this.patternStr;
    }

    public void setPatternStr(String patternStrIn) {
        this.patternStr = patternStrIn;
    }

    public synchronized int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.arrayId.hashCode();
        hashCode = 37 * hashCode + this.alarmLevel.hashCode();
        hashCode = 37 * hashCode + Boolean.valueOf(this.enableState).hashCode();
        hashCode = 37 * hashCode + String.valueOf(this.patternStr).hashCode();
        hashCode = 37 * hashCode + this.arrayId.hashCode();
        for (String s : this.receiveIps) {
            hashCode = 37 * hashCode + s.hashCode();
        }
        return hashCode;
    }

    public boolean isEnableState() {
        return this.enableState;
    }

    public synchronized boolean removeIp(String ip) {
        return this.receiveIps.remove(ip);
    }

    public void setAlarmLevel(Event.Level alarmLevel) {
        this.alarmLevel = alarmLevel;
    }

    public void setEnableState(boolean enableState) {
        this.enableState = enableState;
    }

    public String getDetail() {
        StringBuilder builder = new StringBuilder();
        builder.append(ResourceManager.getString("COMMON.TXT.SEND_LEVEL"));
        builder.append(": ");
        builder.append(this.alarmLevel.toString());
        builder.append(" ");
        builder.append(ResourceManager.getString("ALARM_SM_MOTIFICATION_SET_HINT"));
        builder.append(": ");
        String receiverString = null;
        for (int i = 0; i < this.receiveIps.size(); ++i) {
            receiverString = this.receiveIps.get(i);
            builder.append(receiverString);
            if (i == this.receiveIps.size() - 1) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(ResourceManager.getString("COMMON.TXT.SEND_LEVEL"));
        builder.append(": ");
        builder.append(this.alarmLevel.toString());
        builder.append("; ");
        builder.append(ResourceManager.getString("ALARM_SM_MOTIFICATION_SET_HINT"));
        builder.append(": ");
        String receiverStr = null;
        for (int i = 0; i < this.receiveIps.size(); ++i) {
            receiverStr = this.receiveIps.get(i);
            builder.append(receiverStr);
            if (i == this.receiveIps.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public AlarmSyslogConfig clone() throws CloneNotSupportedException {
        AlarmSyslogConfig clone = (AlarmSyslogConfig)super.clone();
        clone.receiveIps = new ArrayList<String>(this.receiveIps);
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

