/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.license;

import com.huawei.ism.common.entity.Type;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class LicenseFunction
implements Serializable {
    private static final long serialVersionUID = 188514556550916821L;
    private final int featureID;
    private LicenseFunction licenseFunc;
    private Type.LicenseFuncFeatureType featureName;
    private int trialTime;
    private String runTime;
    private String func;
    private boolean funcSwitch;

    public LicenseFunction(Type.LicenseFuncFeatureType funcFeatureType, int trialTime, String runTime, String func, boolean funcSwitch, int featureID) {
        this.featureName = funcFeatureType;
        this.trialTime = trialTime;
        this.runTime = runTime;
        this.func = func;
        this.funcSwitch = funcSwitch;
        this.featureID = featureID;
    }

    public void setLicenseFunction(LicenseFunction lf) {
        this.licenseFunc = new LicenseFunction(lf.featureName, this.trialTime, lf.runTime, lf.func, lf.funcSwitch, lf.featureID);
    }

    public LicenseFunction getLicenseFunction() {
        if (this.licenseFunc == null) {
            return new LicenseFunction(this.featureName, this.trialTime, this.runTime, this.func, this.funcSwitch, this.featureID);
        }
        return this.licenseFunc;
    }

    public Type.LicenseFuncFeatureType getFeatureName() {
        return this.featureName;
    }

    public String getFunc() {
        return this.func;
    }

    public boolean isFuncSwitch() {
        return this.funcSwitch;
    }

    public String getRunTime() {
        return this.runTime;
    }

    public String getTrialTime() {
        return LicenseFunction.getTrialTimeStr(this.trialTime);
    }

    public static String getTrialTimeStr(int trialTimeIn) {
        String space = " ";
        if (trialTimeIn < 0) {
            return trialTimeIn + space + ResourceManager.getString("LICENSE_INFO_28");
        }
        int yearThirty = 10950;
        int yearOne = 365;
        if (trialTimeIn > yearThirty) {
            return ResourceManager.getString("LICENSE_INFO_29");
        }
        if (trialTimeIn < yearOne) {
            return trialTimeIn + space + ResourceManager.getString("LICENSE_INFO_28");
        }
        int year = trialTimeIn / 365;
        int totalDays = trialTimeIn % 365;
        int month = totalDays / 30;
        String ret = year + space + ResourceManager.getString("LICENSE_INFO_26");
        if (month != 0) {
            ret = ret + month + space + ResourceManager.getString("LICENSE_INFO_27");
        }
        return ret;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("featureName", (Object)this.featureName).append("trialTime", this.trialTime).append("runTime", (Object)this.runTime).append("func", (Object)this.func).append("funcSwitch", this.funcSwitch).append("featureID", this.featureID).toString();
    }

    public int hashCode() {
        return this.featureID;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (null == obj || !(obj instanceof LicenseFunction)) {
            return false;
        }
        LicenseFunction that = (LicenseFunction)obj;
        return this.featureName.equals((Object)that.featureName);
    }

    public int getFeatureID() {
        return this.featureID;
    }

    public void setFeatureName(Type.LicenseFuncFeatureType name) {
        this.featureName = name;
    }

    public void setTrialTime(int time) {
        this.trialTime = time;
    }

    public void setRunTime(String time) {
        this.runTime = time;
    }

    public void setFunc(String funcIn) {
        this.func = funcIn;
    }

    public void setFuncSwitch(boolean switch1) {
        this.funcSwitch = switch1;
    }
}

