/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.model;

import com.huawei.ism.common.bean.HealthState;
import com.huawei.ism.common.bean.RunningState;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.entity.State;
import com.huawei.ism.common.entity.Type;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.model.IValueConvert;
import com.huawei.ism.tlv.lang.IsmUnsignedInteger;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueConverts {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueConverts.class);

    public static class OSTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int os = ((UnsignedInt32)srcValue).intValue();
            return Type.OperationSystemType.getOperationSystem(os);
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return Type.OperationSystemType.getDescription((Type.OperationSystemType)((Object)srcValue));
        }

        @Override
        public Object moValue2Original(Object srcValue) {
            return Type.OperationSystemType.getValue((Type.OperationSystemType)((Object)srcValue));
        }
    }

    public static class DeviceStateConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iLevel = ((UnsignedInt32)srcValue).intValue();
            HealthState state = State.getInstance().getHealthState("Array", iLevel);
            return state;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return ((HealthState)((Object)srcValue)).getDescription();
        }
    }

    public static class LunWritePolicyConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("LunWritePolicyConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            int nType = Integer.parseInt(srcValue.toString());
            Type.WritePolicyType type = Type.WritePolicyType.getWritePolicy(nType);
            return Type.WritePolicyType.getDiscription(type);
        }
    }

    public static class LunReadPolicyConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("LunReadPolicyConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            int nType = Integer.parseInt(srcValue.toString());
            Type.PrefetchPolicyType type = Type.PrefetchPolicyType.getPrefetchType(nType);
            return Type.PrefetchPolicyType.getDescription(type);
        }
    }

    public static class FCPortSpeedConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("FCPortSpeedConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            String csStr = "--";
            if (0 == Integer.parseInt(srcValue.toString())) {
                csStr = ResourceManager.getString("FC_PORT_SPEED_ZERO");
            } else if (Integer.parseInt(srcValue.toString()) > 0) {
                csStr = srcValue.toString();
            }
            return csStr;
        }
    }

    public static class PortStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("PortStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            RunningState runningState = State.getInstance().getRunningState("Port", String.valueOf(srcValue));
            return runningState.getDescription();
        }
    }

    public static class ControllerStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("ControllerStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            HealthState healthState = State.getInstance().getHealthState("Controller", String.valueOf(srcValue));
            return healthState.getDescription();
        }
    }

    public static class BBUChargeStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("BBUChargeStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return State.BBUChargeState.getChargeState(Integer.parseInt(srcValue.toString())).getDescription();
        }
    }

    public static class BBURunningStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("BBURunningStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            RunningState runningState = State.getInstance().getRunningState("BBU", String.valueOf(srcValue));
            return runningState.getDescription();
        }
    }

    public static class BBUHealthStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("BBUHealthStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return State.getInstance().getHealthState("BBU", String.valueOf(srcValue)).getDescription();
        }
    }

    public static class FanRunningLevelConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("FanRunningLevelConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return Type.FanRunLevel.getFanRunLevel(Integer.parseInt(srcValue.toString())).getDescription();
        }
    }

    public static class FanStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("FanStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            HealthState healthState = State.getInstance().getHealthState("Fan", String.valueOf(srcValue));
            return healthState.getDescription();
        }
    }

    public static class PowerTemperatureStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("PowerTemperatureStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return State.PowerTemperatureState.getTemperatureState(Integer.parseInt(srcValue.toString())).toString();
        }
    }

    public static class PowerStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("PowerStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            RunningState runningState = State.getInstance().getRunningState("PowerSupply", String.valueOf(srcValue));
            return runningState.getDescription();
        }
    }

    public static class ChassisLogicTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("ChassisLogicTypeConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return Type.LogicalChassisType.getDescription(Integer.parseInt(String.valueOf(srcValue)));
        }
    }

    public static class ChassisPhysicalTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("ChassisPhysicalTypeConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return Type.PhysicalChassisType.getPhysicalChassisType(Integer.parseInt(String.valueOf(srcValue))).getDescription();
        }
    }

    public static class ChassisStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("ChassisStatusConvert convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return State.getInstance().getRunningState("ControllerChassis", String.valueOf(srcValue)).getDescription();
        }
    }

    public static class DiskStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("value convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            RunningState runningState = State.getInstance().getRunningState("Drive", Integer.parseInt(srcValue.toString()));
            return runningState.getDescription();
        }
    }

    public static class DiskOwonedGroupConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = Integer.MAX_VALUE;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("value convert error:" + srcValue);
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            Integer intValue = (Integer)srcValue;
            if (intValue == Integer.MAX_VALUE) {
                return "--";
            }
            return srcValue.toString();
        }
    }

    public static class DiskLogicalTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("value convert error:" + srcValue);
            }
            return Type.DiskLogicalType.getDiskLogicalType(iValue);
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return ((Type.DiskLogicalType)((Object)srcValue)).getDescription();
        }
    }

    public static class DiskPhysicalTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("value convert error:" + srcValue);
            }
            return Type.DiskPhysicalType.getPhysicalType(iValue);
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return ((Type.DiskPhysicalType)((Object)srcValue)).getDescription();
        }
    }

    public static class UserStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.valueOf(srcValue.toString());
            }
            catch (Exception e) {
                LOGGER.error("value convert error:" + srcValue);
            }
            if (iValue == 0) {
                return User.Status.Online;
            }
            return User.Status.Offline;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            if (null == srcValue) {
                return "--";
            }
            return ((User.Status)((Object)srcValue)).getDescription();
        }
    }

    public static class UserLevelConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iLevel = ((IsmUnsignedInteger)srcValue).intValue();
            return User.Level.valueOf(iLevel);
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return ((User.Level)((Object)srcValue)).getDescription();
        }
    }

    public static class DefaultValueConvert
    implements IValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            return srcValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return srcValue;
        }

        @Override
        public Object moValue2Original(Object srcValue) {
            return srcValue;
        }
    }
}

