/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskMO
extends HardwareInfoAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskMO.class);
    private final MO mo;
    private String location = "";

    public DiskMO(MO mo) {
        this.mo = mo;
        this.location = mo.getStrProperty(TLV.DISK.LOCATION);
    }

    public DiskMO(Map<String, String> dataDict) {
        this.mo = new MO(new UUID(dataDict.get("deviceId"), Integer.parseInt(dataDict.get("moType")), dataDict.get("id")));
        this.mo.setOtherInfo(dataDict);
        this.location = this.mo.getStrProperty(TLV.DISK.LOCATION);
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.DISK.TYPE).toString()));
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.DISK.ID);
    }

    public int getSlotID() {
        return HardwareUtils.parserID(this.getLocation());
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.DISK.PARENTTYPE).toString());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.DISK.PARENTID);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public int getHealthStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.DISK.HEALTHSTATUS).toString());
    }

    public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
        return EnumDefine.RUNNING_STATUS_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.DISK.RUNNINGSTATUS).toString()));
    }

    public long getCount() {
        return this.mo.getLongProperty(TLV.DISK.COUNT);
    }

    public EnumDefine.DISK_TYPE_E getDiskType() {
        try {
            return EnumDefine.DISK_TYPE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.DISK.DISKTYPE).toString()));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Unknows disk type.", (Throwable)e);
            return EnumDefine.DISK_TYPE_E.UNKNOWN;
        }
    }

    public long getSectors() {
        return this.mo.getLongProperty(TLV.DISK.SECTORS);
    }

    public long getBandwidth() {
        return this.mo.getLongProperty(TLV.DISK.BANDWIDTH);
    }

    public long getSectorSize() {
        return this.mo.getLongProperty(TLV.DISK.SECTORSIZE);
    }

    public long getSpeedRPM() {
        return this.mo.getLongProperty(TLV.DISK.SPEEDRPM);
    }

    public long getTemperature() {
        return this.mo.getLongProperty(TLV.DISK.TEMPERATURE);
    }

    @Override
    public String getModel() {
        return this.mo.getStrProperty(TLV.DISK.MODEL);
    }

    public String getFirmwareVer() {
        return this.mo.getStrProperty(TLV.DISK.FIRMWAREVER);
    }

    public String getManufacturer() {
        return this.mo.getStrProperty(TLV.DISK.MANUFACTURER);
    }

    public String getDiskForm() {
        return this.mo.getStrProperty(TLV.DISK.DISKFORM);
    }

    public String getSerialNumber() {
        return this.mo.getStrProperty(TLV.DISK.SERIALNUMBER);
    }

    public EnumDefine.DISK_LIGHT_STATUS_E getLightStatus() {
        return EnumDefine.DISK_LIGHT_STATUS_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.DISK.LIGHTSTATUS).toString()));
    }

    public EnumDefine.DISK_LOGIC_TYPE_E getLogicType() {
        return EnumDefine.DISK_LOGIC_TYPE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.DISK.LOGICTYPE).toString()));
    }

    public String getPoolID() {
        return this.mo.getStrProperty(TLV.DISK.POOLID);
    }

    public String getPoolName() {
        return this.mo.getStrProperty(TLV.DISK.POOLNAME);
    }

    public String getPoolTierID() {
        return this.mo.getStrProperty(TLV.DISK.POOLTIERID);
    }

    public boolean isIsCofferDisk() {
        return this.mo.getBoolProperty(TLV.DISK.ISCOFFERDISK);
    }

    public long getRunTime() {
        return this.mo.getLongProperty(TLV.DISK.RUNTIME);
    }

    public long getProgress() {
        return this.mo.getLongProperty(TLV.DISK.PROGRESS);
    }

    public boolean isNcqSwitch() {
        return this.mo.getBoolProperty(TLV.DISK.NCQSWITCH);
    }

    public long getUnplug() {
        return this.mo.getLongProperty(TLV.DISK.UNPLUG);
    }

    public boolean isWriteCacheSwitch() {
        return this.mo.getBoolProperty(TLV.DISK.WRITECACHESWITCH);
    }

    public boolean isPreCopySwitch() {
        return this.mo.getBoolProperty(TLV.DISK.PRECOPYSWITCH);
    }

    public long getStartLBA() {
        return this.mo.getLongProperty(TLV.DISK.STARTLBA);
    }

    public long getLen() {
        return this.mo.getLongProperty(TLV.DISK.LEN);
    }

    public String getSmartCachePoolId() {
        return this.mo.getStrProperty(TLV.DISK.SMARTCACHEPOOLID);
    }

    public EnumDefine.BST_TYPE_E getBstType() {
        return EnumDefine.BST_TYPE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.DISK.BSTTYPE).toString()));
    }

    public String getMultiPathStr() {
        StringBuilder sb = new StringBuilder();
        try {
            JSONArray jsonArray = (JSONArray)this.mo.getProperty(TLV.DISK.MULTIPATH);
            if (null == jsonArray) {
                return "--";
            }
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                sb.append((String)jsonArray.get(i));
                if (i >= length - 1) continue;
                sb.append(" ");
                sb.append(",");
                sb.append(" ");
            }
        }
        catch (JSONException e) {
            LOGGER.error("", (Throwable)e);
            return "--";
        }
        return sb.toString();
    }

    public void setMultiPath(List<String> multiPath) {
        this.mo.setProperty(TLV.DISK.MULTIPATH, multiPath);
    }

    public Object getInvalidTime() {
        return this.mo.getProperty(TLV.DISK.INVALIDTIME);
    }

    public int getCapacityUsage() {
        return this.mo.getIntProperty(TLV.DISK.CAPACITYUSAGE);
    }

    public MO getMO() {
        return this.mo;
    }

    @Override
    public boolean isNormal() {
        return true;
    }
}

