/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.exception.IsmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HardwareUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardwareUtils.class);

    private HardwareUtils() {
    }

    public static int parserID(String id) {
        String[] strs = id.split("\\.");
        try {
            return Integer.valueOf(strs[strs.length - 1]);
        }
        catch (Exception e) {
            LOGGER.error("Parser id error: the id is \"" + id + "\"");
            throw new IsmException(-1L, (Throwable)e);
        }
    }

    public static int getPortSlotID(String name) {
        char c;
        if (null == name) {
            LOGGER.error("Parse slot id of port error,The port name is null");
            return -1;
        }
        int slotID = 0;
        char[] arrays = name.toCharArray();
        for (int i = 0; i < arrays.length && Character.isDigit(c = arrays[arrays.length - i - 1]); ++i) {
            Integer dig = Integer.valueOf(String.valueOf(c));
            slotID = slotID * 10 + dig;
        }
        return slotID;
    }

    public static int getLast8Digits(int num) {
        return num & 0xFF;
    }
}

