/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareUtils;

public class IntfModuleMO
extends HardwareInfoAdapter {
    private final MO mo;

    public IntfModuleMO(MO mo) {
        this.mo = mo;
    }

    @Override
    public boolean isNormal() {
        return true;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.INTF_MODULE.TYPE).toString()));
    }

    public String getMOName() {
        return ResourceManager.getStringWithParams("physical.treenode.name.interfacemodule", this.getName());
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.INTF_MODULE.ID);
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.INTF_MODULE.NAME);
    }

    public int getSlotID() {
        return HardwareUtils.parserID(this.getID());
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.INTF_MODULE.PARENTTYPE).toString());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.INTF_MODULE.PARENTID);
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.INTF_MODULE.LOCATION);
    }

    @Override
    public int getHealthStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.INTF_MODULE.HEALTHSTATUS).toString());
    }

    public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
        return EnumDefine.RUNNING_STATUS_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.INTF_MODULE.RUNNINGSTATUS).toString()));
    }

    public long getCount() {
        return this.mo.getLongProperty(TLV.INTF_MODULE.COUNT);
    }

    public EnumDefine.INTF_MODEL_E getModel() {
        return EnumDefine.INTF_MODEL_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.INTF_MODULE.MODEL).toString()));
    }

    public String getElabel() {
        return this.mo.getStrProperty(TLV.INTF_MODULE.ELABEL);
    }

    public String getLogicVer() {
        return this.mo.getStrProperty(TLV.INTF_MODULE.LOGICVER);
    }

    public String getPcbVer() {
        return this.mo.getStrProperty(TLV.INTF_MODULE.PCBVER);
    }

    public MO getMO() {
        return this.mo;
    }
}

