/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.command;

import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandExcutor;
import com.huawei.ism.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class CommandUtils {
    public static boolean isFailedWith(List<Command> commands) {
        Assert.notNull(commands);
        CommandExcutor.CommandState state = null;
        for (Command command : commands) {
            state = command.getCommandState();
            if (CommandExcutor.CommandState.FAILED == state) continue;
            return false;
        }
        return true;
    }

    public static boolean isSucceededWith(List<Command> commands) {
        Assert.notNull(commands);
        CommandExcutor.CommandState state = null;
        for (Command command : commands) {
            state = command.getCommandState();
            if (CommandExcutor.CommandState.SYN_CMD_FINISHED == state || CommandExcutor.CommandState.ASYNC_CMD_COMPLETED == state) continue;
            return false;
        }
        return true;
    }

    public static boolean isFinishedWith(List<Command> commands) {
        Assert.notNull(commands);
        CommandExcutor.CommandState commandState = null;
        for (Command command : commands) {
            commandState = command.getCommandState();
            if (CommandExcutor.CommandState.EXECUTING != commandState && CommandExcutor.CommandState.WAIT_EXECUTE != commandState) continue;
            return false;
        }
        return true;
    }

    public static boolean partialSucceededWith(List<Command> commands) {
        Assert.notNull(commands);
        CommandExcutor.CommandState stat = null;
        for (Command command : commands) {
            stat = command.getCommandState();
            if (CommandExcutor.CommandState.FAILED != stat) continue;
            return false;
        }
        return true;
    }

    public static List<Callable<Boolean>> getAsyncTasksWith(List<Command> commands) {
        Assert.notNull(commands);
        Callable<Boolean> task = null;
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>(0);
        for (final Command command : commands) {
            task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return command.execute();
                }
            };
            tasks.add(task);
        }
        return tasks;
    }

    public static List<Command> getFailedCommands(List<Command> commands) {
        Assert.notNull(commands);
        CommandExcutor.CommandState state = null;
        ArrayList<Command> failedCommands = new ArrayList<Command>(0);
        for (Command command : commands) {
            state = command.getCommandState();
            if (CommandExcutor.CommandState.FAILED != state) continue;
            failedCommands.add(command);
        }
        return failedCommands;
    }
}

