/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.TimerTaskManager;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.ui.module.event.EventManager;
import com.huawei.ism.ui.module.event.EventManagerListener;
import com.huawei.ism.util.CommonUtil;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuzzHandle
implements EventManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBuzzHandle.class);
    private static EventBuzzHandle instance = new EventBuzzHandle();
    private static final int LEVEL_NONE = -1;
    private int eventLevel = 0;
    private boolean buzzerEnable = false;
    private AudioClip audioClip;
    private boolean playing = false;
    private Runnable audioRunnable = null;

    private EventBuzzHandle() {
        this.loadAudioClip();
        this.initBuzzerStatusFromNative();
    }

    @Override
    public void fireSourceRemoved(String ... deviceIDs) {
        this.updateBuzzStatus();
    }

    @Override
    public void fireSourceAdded(String ... sourceIDs) {
        this.updateBuzzStatus();
    }

    @Override
    public void fireFaultEventsAdded(Collection<Event> events) {
        this.updateBuzzStatus();
    }

    @Override
    public void fireFaultEventRemoved(Collection<Event> events) {
        this.updateBuzzStatus();
    }

    @Override
    public void fireFaultEventUpdated(Collection<Event> events) {
        this.updateBuzzStatus();
    }

    @Override
    public void fireFaultCleared(Collection<Event> events, Map<Event.Identifier, Long> failedMap) {
        this.updateBuzzStatus();
    }

    @Override
    public void fireEventsAdded(List<Event> events) {
    }

    public static EventBuzzHandle getInstance() {
        return instance;
    }

    public synchronized boolean isBuzzerEnable() {
        return this.buzzerEnable;
    }

    public synchronized void updateBuzzStatus() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                EventBuzzHandle.this.updateBuzzStatusTask();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            AsyncExcutor.submit(task);
        } else {
            task.run();
        }
    }

    public synchronized void closeBuzz() {
        if (this.playing) {
            this.stopPlayback();
            this.playing = false;
        }
    }

    private synchronized void updateBuzzStatusTask() {
        if (CommonUtil.isV2Integrated()) {
            return;
        }
        if (!this.buzzerEnable) {
            return;
        }
        if (this.shouldBuzz()) {
            if (!this.playing) {
                this.loopPlayback();
                this.playing = true;
            }
        } else {
            this.closeBuzz();
        }
    }

    public synchronized boolean isBuzzEnable() {
        return this.buzzerEnable;
    }

    public synchronized void setBuzzEnable(boolean enable) {
        this.buzzerEnable = enable;
        if (this.buzzerEnable) {
            this.updateBuzzStatus();
        } else {
            this.closeBuzz();
        }
    }

    public synchronized int getLevel() {
        return this.eventLevel;
    }

    public synchronized void setLevel(int level) {
        if (this.eventLevel != level) {
            this.eventLevel = level;
            this.updateBuzzStatus();
        }
    }

    private boolean shouldBuzz() {
        if (this.getLevel() == -1) {
            return false;
        }
        List<Event> events = EventManager.getInstance().getAllFaults();
        for (Event event : events) {
            if (!this.shouldBuzzEvent(event)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldBuzzEvent(Event event) {
        Event.Level level = event.getLevel();
        switch (this.getLevel()) {
            case 3: {
                if (level != Event.Level.CRITICAL && level != Event.Level.MAJOR && level != Event.Level.WARNING) break;
                return true;
            }
            case 5: {
                if (level != Event.Level.CRITICAL && level != Event.Level.MAJOR) break;
                return true;
            }
            case 6: {
                if (level != Event.Level.CRITICAL) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private synchronized void initBuzzerStatusFromNative() {
        CustomResourceManager crManager = CustomResourceManager.getInstance();
        this.eventLevel = crManager.getIntProperty("custom.ClientSoundSwitchAlarmLevel", 0);
        this.buzzerEnable = crManager.getBoolProperty("custom.ClientSoundSwitchStatus", true);
    }

    private String loadAudioFile() {
        String fileRelativePath = ResourceBundle.getBundle("config.framework.configuration.configuration").getString("ALARM_BUZZER_FILE");
        return fileRelativePath;
    }

    private void loopPlayback() {
        if (this.playing || null == this.audioClip) {
            LOGGER.error("isPlaying or the audio file loaded is null!");
            return;
        }
        TimerTaskManager.getInstance().scheduleCommonTask(this.getAudioRunnable(), 0, 5, TimeUnit.SECONDS);
    }

    private void stopPlayback() {
        if (!this.playing) {
            return;
        }
        if (null == this.audioClip) {
            LOGGER.error("the audio file loaded is null!");
            return;
        }
        TimerTaskManager.getInstance().cancel(this.getAudioRunnable());
    }

    private void loadAudioClip() {
        try {
            String fileRelativePath = this.loadAudioFile();
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                throw new EncapsulatedRuntimeException("classloader is null .");
            }
            URL audioURL = classLoader.getResource(fileRelativePath);
            if (audioURL == null) {
                throw new EncapsulatedRuntimeException("audioURL is null .");
            }
            String codeBasePath = audioURL.getPath();
            File file = new File(codeBasePath);
            if (file.exists() && file.isFile()) {
                URL url = file.toURI().toURL();
                this.audioClip = Applet.newAudioClip(url);
                LOGGER.info("Load audio file succeed!");
            } else {
                audioURL = classLoader.getResource(fileRelativePath);
                if (null != audioURL) {
                    this.audioClip = Applet.newAudioClip(audioURL);
                    LOGGER.error("Load audio file succeed!");
                } else {
                    LOGGER.error("Cann't find audio file :" + fileRelativePath);
                }
            }
        }
        catch (MalformedURLException e) {
            LOGGER.error("Load audio file error!");
        }
    }

    public synchronized void setBuzzerStatus(boolean buzzerStatus) {
        if (CommonUtil.isV2Integrated()) {
            this.buzzerEnable = false;
        }
    }

    private Runnable getAudioRunnable() {
        if (null == this.audioRunnable) {
            this.audioRunnable = new LoopAudioClip();
        }
        return this.audioRunnable;
    }

    private final class LoopAudioClip
    implements Runnable {
        private LoopAudioClip() {
        }

        @Override
        public void run() {
            EventBuzzHandle.this.audioClip.play();
        }
    }
}

