/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.control.IsmGradientSeperator;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class EventTabLayout
extends JPanel {
    private static final String SAVE_BUTTON_TEXT = ResourceManager.getString("ABSTRACT_ALARM_PANEL_SAVE");
    private static final char SAVE_BUTTON_MNEMONIC = 'A';
    private static final char REFRESH_BUTTON_MNEMONIC = 'Q';
    private static final String REFRESH_BUTTON_TEXT = ResourceManager.getString("ABSTRACT_ALARM_PANEL_QUERY");
    private static final long serialVersionUID = 1L;
    private static final Dimension BUTTON_DIMENSION = new Dimension(85, 21);
    private static final Dimension COMBOMBOX_DIMENSION = new Dimension(200, 21);
    private static final Dimension ALARM_PANEL_DIMENSION = new Dimension(820, 520);
    private static final int BOX_GAP_TWELVE = 12;
    private IsmTable eventTable;
    private JButton clearFilterButton;
    private JButton saveButton;
    private JButton queryButton;
    private JComboBox deviceComboBox;
    private JComboBox sourceComboBox;
    private JComboBox levelComboBox;
    private KeywordFilterField keywordFilter;

    public EventTabLayout(IsmTable table) {
        this.eventTable = table;
        this.init();
    }

    public void init() {
        this.setOpaque(false);
        Box filterBox = this.initTopFilterPane();
        Box selectDeviceBox = this.initDeviceChoosePane();
        JComponent centerPane = this.createTablePane();
        centerPane.setOpaque(false);
        Box buttonPane = this.initButtonPane();
        buttonPane.setBorder(new EmptyBorder(0, 8, 0, 8));
        buttonPane.setOpaque(false);
        Box contentBox = Box.createVerticalBox();
        contentBox.add(selectDeviceBox);
        contentBox.add(Box.createVerticalStrut(8));
        IsmGradientSeperator seperator = new IsmGradientSeperator();
        seperator.setPreferredSize(new Dimension(seperator.getWidth(), 4));
        seperator.setMaximumSize(new Dimension((int)seperator.getMaximumSize().getWidth(), 4));
        contentBox.add(seperator);
        contentBox.add(Box.createVerticalStrut(8));
        contentBox.add(filterBox);
        contentBox.add(Box.createVerticalStrut(12));
        contentBox.add(centerPane);
        contentBox.add(Box.createVerticalStrut(12));
        contentBox.add(buttonPane);
        contentBox.setBorder(new EmptyBorder(12, 8, 9, 8));
        this.setLayout(new BorderLayout());
        this.add((Component)contentBox, "Center");
        this.setPreferredSize(ALARM_PANEL_DIMENSION);
        this.setMaximumSize(ALARM_PANEL_DIMENSION);
        this.setMinimumSize(ALARM_PANEL_DIMENSION);
    }

    private Box initButtonPane() {
        this.saveButton = new JButton(SAVE_BUTTON_TEXT);
        this.saveButton.setEnabled(false);
        this.saveButton.setPreferredSize(new Dimension(100, 21));
        this.saveButton.setMnemonic('A');
        return this.createBtnBox();
    }

    protected Box createBtnBox() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.saveButton);
        return box;
    }

    private JComponent createTablePane() {
        JPanel tablePanel = new JPanel();
        tablePanel.setOpaque(false);
        tablePanel.setLayout(new BorderLayout());
        this.eventTable.setSelectionMode(2);
        tablePanel.add((Component)new TableScrollPane(this.eventTable, false, true), "Center");
        return tablePanel;
    }

    private Box initTopFilterPane() {
        Box filterBox = Box.createHorizontalBox();
        JLabel label = new JLabel(ResourceManager.getString("EVENT_MANAGER_FILTER_LABEL"));
        this.levelComboBox = new JComboBox();
        Dimension levelDim = new Dimension(95, 21);
        this.levelComboBox.setPreferredSize(levelDim);
        this.levelComboBox.setMinimumSize(levelDim);
        this.levelComboBox.setMaximumSize(levelDim);
        this.clearFilterButton = UCD.createButton(ResourceManager.getString("EVENT_MANAGER_CLEAR_FILTER"), 'F');
        filterBox.add(label);
        filterBox.add(Box.createHorizontalStrut(8));
        filterBox.add(this.levelComboBox);
        filterBox.add(Box.createHorizontalStrut(12));
        this.keywordFilter = new KeywordFilterField(this.eventTable);
        filterBox.add(this.keywordFilter);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(this.clearFilterButton);
        filterBox.add(Box.createGlue());
        this.clearFilterButton.setEnabled(false);
        return filterBox;
    }

    private Box initDeviceChoosePane() {
        Box filterBox = Box.createHorizontalBox();
        JLabel label = new JLabel(ResourceManager.getString("EVENT_MANAGER_SELECT_DEVICE_LABEL"));
        this.queryButton = new JButton(REFRESH_BUTTON_TEXT);
        this.queryButton.setEnabled(false);
        this.queryButton.setPreferredSize(BUTTON_DIMENSION);
        this.queryButton.setMnemonic('Q');
        this.sourceComboBox = new JComboBox();
        this.sourceComboBox.setPreferredSize(COMBOMBOX_DIMENSION);
        this.sourceComboBox.setMaximumSize(COMBOMBOX_DIMENSION);
        this.sourceComboBox.setMinimumSize(COMBOMBOX_DIMENSION);
        this.deviceComboBox = new JComboBox();
        this.deviceComboBox.setPreferredSize(COMBOMBOX_DIMENSION);
        this.deviceComboBox.setMaximumSize(COMBOMBOX_DIMENSION);
        this.deviceComboBox.setMinimumSize(COMBOMBOX_DIMENSION);
        filterBox.add(label);
        filterBox.add(Box.createHorizontalStrut(8));
        filterBox.add(this.deviceComboBox);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(this.sourceComboBox);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(this.queryButton);
        filterBox.add(Box.createGlue());
        return filterBox;
    }

    public JButton getClearFilterButton() {
        return this.clearFilterButton;
    }

    public void setClearFilterButton(JButton clearFilterButton) {
        this.clearFilterButton = clearFilterButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public void setSaveButton(JButton saveButton) {
        this.saveButton = saveButton;
    }

    public JButton getQueryButton() {
        return this.queryButton;
    }

    public void setQueryButton(JButton queryButton) {
        this.queryButton = queryButton;
    }

    public JComboBox getDeviceComboBox() {
        return this.deviceComboBox;
    }

    public void setDeviceComboBox(JComboBox deviceComboBox) {
        this.deviceComboBox = deviceComboBox;
    }

    public JComboBox getSourceComboBox() {
        return this.sourceComboBox;
    }

    public void setSourceComboBox(JComboBox sourceComboBox) {
        this.sourceComboBox = sourceComboBox;
    }

    public JComboBox getLevelComboBox() {
        return this.levelComboBox;
    }

    public void setLevelComboBox(JComboBox levelComboBox) {
        this.levelComboBox = levelComboBox;
    }

    public KeywordFilterField getKeywordFilter() {
        return this.keywordFilter;
    }

    public void setKeywordFilter(KeywordFilterField keywordFilter) {
        this.keywordFilter = keywordFilter;
    }
}

