/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTimeRefreshTaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventTimeRefreshTaskManager.class);
    private static final int ONE_MINITUES = 60000;
    private static EventTimeRefreshTaskManager instance;
    private static final int ONE_DAY = 1;
    private static long interval;
    private static int hour;
    private static int minute;
    private static int second;
    private static int millisecond;
    private static boolean isOpen;
    private static final Object lock;
    private boolean isStartRefreshTask = false;

    private EventTimeRefreshTaskManager() {
    }

    public static synchronized EventTimeRefreshTaskManager getInstance() {
        if (null == instance) {
            instance = new EventTimeRefreshTaskManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRefreshTask() {
        Object object = lock;
        synchronized (object) {
            if (!this.isStartRefreshTask && isOpen) {
                LOGGER.info("Start refresh alarm timer at everyday !");
                Calendar now = Calendar.getInstance();
                Calendar clock = Calendar.getInstance();
                clock.set(11, hour);
                clock.set(12, minute);
                clock.set(13, second);
                clock.set(14, millisecond);
                if (now.after(clock)) {
                    clock.add(6, 1);
                }
                Timer time = new Timer("Refresh Alarm Timer");
                time.scheduleAtFixedRate((TimerTask)new AlarmRefreshTask(), clock.getTime(), interval);
                this.isStartRefreshTask = true;
            }
        }
    }

    public void releaseAlarmDialog() {
    }

    static {
        lock = new Object();
        interval = 86400000L;
        hour = 3;
        minute = 0;
        second = 0;
        millisecond = 0;
        isOpen = true;
    }

    private static class AlarmRefreshTask
    extends TimerTask {
        private AlarmRefreshTask() {
        }

        @Override
        public void run() {
            block6: {
                try {
                    LOGGER.info("start timing refresh Alarm");
                    LauncherManager launcherManagement = LauncherManager.getInstance();
                    List<Launcher> launchers = launcherManagement.getAllActiveLauncher();
                    for (Launcher launcher : launchers) {
                        block5: {
                            if (null == launcher.getDeviceContext().getDeviceID()) continue;
                            try {
                                LOGGER.info("Alarm Refresh");
                            }
                            catch (Exception e) {
                                if (!LOGGER.isErrorEnabled()) break block5;
                                LOGGER.error("AlarmTimeRefreshThread query alarm error! current array id:" + launcher.getDeviceContext().getDeviceID() + e);
                            }
                        }
                        Thread.currentThread();
                        Thread.sleep(60000L);
                    }
                    LOGGER.info("Timing refresh Alarm completed!");
                }
                catch (Throwable e) {
                    if (!LOGGER.isErrorEnabled()) break block6;
                    LOGGER.error("AlarmTimeRefreshThread query alarm error casue by Throwable!" + e);
                }
            }
        }
    }
}

