/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.notification;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.notification.GFCommon;
import com.huawei.ism.ui.module.notification.GFString;
import com.huawei.ism.ui.module.notification.SevenBitBean;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PduPack {
    private static Map<Integer, SevenBitBean> iso8859To7bitmap = new HashMap<Integer, SevenBitBean>(0);
    private String smsc;
    private String addr;
    private String msgCoding;
    private int msgLen;
    private String msgContent;
    private String countryCode;

    public PduPack() {
    }

    public PduPack(String smsc) {
        this.smsc = smsc;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setSmsc(String str) {
        if (str == null) {
            return;
        }
        String tmp = this.addPrefix(str.startsWith("+") ? str.substring(1) : str, this.getCountryCode());
        tmp = GFString.interChange(tmp);
        tmp = this.addPrefix(tmp, "91");
        int addrLen = tmp.length() / 2;
        this.smsc = GFCommon.byte2hex((byte)addrLen) + tmp;
    }

    public void setAddr(String addr) {
        String tmp = this.addPrefix(addr, this.getCountryCode());
        int addrLen = tmp.length();
        tmp = this.addPrefix(GFString.interChange(tmp), "91");
        this.addr = GFCommon.byte2hex((byte)addrLen) + tmp;
    }

    private String addPrefix(String inStr, String prefix) {
        if (inStr == null || inStr.length() < 1) {
            return inStr;
        }
        String ret = inStr;
        if (prefix != null && prefix.length() > 0 && !ret.startsWith(prefix)) {
            ret = prefix + ret;
        }
        return ret;
    }

    public void setMsgCoding(int encoding) {
        this.msgCoding = encoding == 8 ? "08" : (encoding == 4 ? "04" : "00");
    }

    public void setMsgContent(String content, boolean is160) throws UnsupportedEncodingException {
        if (content != null) {
            if (is160) {
                this.msgCoding = "00";
                this.msgContent = this.encode7bit(content);
            } else {
                this.msgCoding = "08";
                this.msgContent = GFString.gb2uni(content);
                if (this.msgContent != null) {
                    this.msgLen = this.msgContent.length() / 2;
                }
            }
            if (this.msgContent != null) {
                this.msgContent = this.msgContent.toUpperCase(ResourceManager.getLocale());
            }
        }
    }

    public String getContentCodedResult() {
        String result = null;
        String tpPdutype = "11";
        String tpMr = "00";
        String tpPid = "00";
        String tpDcs = this.msgCoding;
        String tpVp = "AA";
        if (this.addr != null && this.msgContent != null) {
            result = this.smsc + "11" + "00" + this.addr + "00" + tpDcs + "AA" + GFCommon.byte2hex((byte)this.msgLen) + this.msgContent;
            result = result.toUpperCase(ResourceManager.getLocale());
        }
        return result;
    }

    public int getCmgsLen() {
        String sendMsg = this.getContentCodedResult();
        if (sendMsg != null && sendMsg.startsWith(this.smsc)) {
            return sendMsg.substring(this.smsc.length()).length() / 2;
        }
        return 0;
    }

    public String getAddr() {
        return this.addr;
    }

    public String getMsgCoding() {
        return this.msgCoding;
    }

    public String getMsgContent() {
        return this.msgContent;
    }

    public int getMsgLen() {
        return this.msgLen;
    }

    public String getSmsc() {
        return this.smsc;
    }

    public String encode7bit(String src) throws UnsupportedEncodingException {
        StringBuffer tempBuf = new StringBuffer("");
        StringBuffer result = new StringBuffer("");
        String hex = null;
        byte left = 0;
        Byte[] b = this.get7BitBytes(src);
        this.msgLen = b.length;
        for (Byte element : b) {
            tempBuf.append(GFCommon.byte2hex(element));
        }
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            j = i & 7;
            if (j == 0) {
                left = b[i];
                continue;
            }
            byte value = (byte)(b[i] << 8 - j | left);
            left = (byte)(b[i] >> j);
            hex = GFCommon.byte2hex(value);
            result.append(hex);
        }
        result.append(GFCommon.byte2hex(left));
        return result.toString().toUpperCase(Locale.ENGLISH);
    }

    private Byte[] get7BitBytes(String str) throws UnsupportedEncodingException {
        ArrayList<Byte> result = new ArrayList<Byte>(0);
        SevenBitBean servenBit = null;
        byte[] temp = null;
        for (int j = 0; j < str.length(); ++j) {
            servenBit = iso8859To7bitmap.get(str.charAt(j));
            if (null == servenBit) {
                result.add((byte)42);
                continue;
            }
            for (byte element : temp = servenBit.getBytes()) {
                result.add(element);
            }
        }
        return result.toArray(new Byte[result.size()]);
    }

    static {
        iso8859To7bitmap.put(64, new SevenBitBean(new byte[]{0}));
        iso8859To7bitmap.put(163, new SevenBitBean(new byte[]{1}));
        iso8859To7bitmap.put(36, new SevenBitBean(new byte[]{2}));
        iso8859To7bitmap.put(165, new SevenBitBean(new byte[]{3}));
        iso8859To7bitmap.put(232, new SevenBitBean(new byte[]{4}));
        iso8859To7bitmap.put(233, new SevenBitBean(new byte[]{5}));
        iso8859To7bitmap.put(249, new SevenBitBean(new byte[]{6}));
        iso8859To7bitmap.put(236, new SevenBitBean(new byte[]{7}));
        iso8859To7bitmap.put(242, new SevenBitBean(new byte[]{8}));
        iso8859To7bitmap.put(199, new SevenBitBean(new byte[]{9}));
        iso8859To7bitmap.put(10, new SevenBitBean(new byte[]{10}));
        iso8859To7bitmap.put(216, new SevenBitBean(new byte[]{11}));
        iso8859To7bitmap.put(248, new SevenBitBean(new byte[]{12}));
        iso8859To7bitmap.put(13, new SevenBitBean(new byte[]{13}));
        iso8859To7bitmap.put(197, new SevenBitBean(new byte[]{14}));
        iso8859To7bitmap.put(229, new SevenBitBean(new byte[]{15}));
        iso8859To7bitmap.put(95, new SevenBitBean(new byte[]{17}));
        iso8859To7bitmap.put(934, new SevenBitBean(new byte[]{18}));
        iso8859To7bitmap.put(915, new SevenBitBean(new byte[]{19}));
        iso8859To7bitmap.put(923, new SevenBitBean(new byte[]{20}));
        iso8859To7bitmap.put(937, new SevenBitBean(new byte[]{21}));
        iso8859To7bitmap.put(928, new SevenBitBean(new byte[]{22}));
        iso8859To7bitmap.put(936, new SevenBitBean(new byte[]{23}));
        iso8859To7bitmap.put(931, new SevenBitBean(new byte[]{24}));
        iso8859To7bitmap.put(920, new SevenBitBean(new byte[]{25}));
        iso8859To7bitmap.put(926, new SevenBitBean(new byte[]{26}));
        iso8859To7bitmap.put(27, new SevenBitBean(new byte[]{27}));
        iso8859To7bitmap.put(12, new SevenBitBean(new byte[]{27, 10}));
        iso8859To7bitmap.put(94, new SevenBitBean(new byte[]{27, 20}));
        iso8859To7bitmap.put(123, new SevenBitBean(new byte[]{27, 40}));
        iso8859To7bitmap.put(125, new SevenBitBean(new byte[]{27, 41}));
        iso8859To7bitmap.put(92, new SevenBitBean(new byte[]{27, 47}));
        iso8859To7bitmap.put(91, new SevenBitBean(new byte[]{27, 60}));
        iso8859To7bitmap.put(126, new SevenBitBean(new byte[]{27, 61}));
        iso8859To7bitmap.put(93, new SevenBitBean(new byte[]{27, 62}));
        iso8859To7bitmap.put(124, new SevenBitBean(new byte[]{27, 64}));
        iso8859To7bitmap.put(164, new SevenBitBean(new byte[]{27, 101}));
        iso8859To7bitmap.put(198, new SevenBitBean(new byte[]{28}));
        iso8859To7bitmap.put(230, new SevenBitBean(new byte[]{29}));
        iso8859To7bitmap.put(223, new SevenBitBean(new byte[]{30}));
        iso8859To7bitmap.put(201, new SevenBitBean(new byte[]{31}));
        iso8859To7bitmap.put(32, new SevenBitBean(new byte[]{32}));
        iso8859To7bitmap.put(33, new SevenBitBean(new byte[]{33}));
        iso8859To7bitmap.put(34, new SevenBitBean(new byte[]{34}));
        iso8859To7bitmap.put(35, new SevenBitBean(new byte[]{35}));
        iso8859To7bitmap.put(164, new SevenBitBean(new byte[]{36}));
        iso8859To7bitmap.put(37, new SevenBitBean(new byte[]{37}));
        iso8859To7bitmap.put(38, new SevenBitBean(new byte[]{38}));
        iso8859To7bitmap.put(39, new SevenBitBean(new byte[]{39}));
        iso8859To7bitmap.put(40, new SevenBitBean(new byte[]{40}));
        iso8859To7bitmap.put(41, new SevenBitBean(new byte[]{41}));
        iso8859To7bitmap.put(42, new SevenBitBean(new byte[]{42}));
        iso8859To7bitmap.put(43, new SevenBitBean(new byte[]{43}));
        iso8859To7bitmap.put(44, new SevenBitBean(new byte[]{44}));
        iso8859To7bitmap.put(45, new SevenBitBean(new byte[]{45}));
        iso8859To7bitmap.put(46, new SevenBitBean(new byte[]{46}));
        iso8859To7bitmap.put(47, new SevenBitBean(new byte[]{47}));
        iso8859To7bitmap.put(48, new SevenBitBean(new byte[]{48}));
        iso8859To7bitmap.put(49, new SevenBitBean(new byte[]{49}));
        iso8859To7bitmap.put(50, new SevenBitBean(new byte[]{50}));
        iso8859To7bitmap.put(51, new SevenBitBean(new byte[]{51}));
        iso8859To7bitmap.put(52, new SevenBitBean(new byte[]{52}));
        iso8859To7bitmap.put(53, new SevenBitBean(new byte[]{53}));
        iso8859To7bitmap.put(54, new SevenBitBean(new byte[]{54}));
        iso8859To7bitmap.put(55, new SevenBitBean(new byte[]{55}));
        iso8859To7bitmap.put(56, new SevenBitBean(new byte[]{56}));
        iso8859To7bitmap.put(57, new SevenBitBean(new byte[]{57}));
        iso8859To7bitmap.put(58, new SevenBitBean(new byte[]{58}));
        iso8859To7bitmap.put(59, new SevenBitBean(new byte[]{59}));
        iso8859To7bitmap.put(60, new SevenBitBean(new byte[]{60}));
        iso8859To7bitmap.put(61, new SevenBitBean(new byte[]{61}));
        iso8859To7bitmap.put(62, new SevenBitBean(new byte[]{62}));
        iso8859To7bitmap.put(63, new SevenBitBean(new byte[]{63}));
        iso8859To7bitmap.put(161, new SevenBitBean(new byte[]{64}));
        iso8859To7bitmap.put(65, new SevenBitBean(new byte[]{65}));
        iso8859To7bitmap.put(66, new SevenBitBean(new byte[]{66}));
        iso8859To7bitmap.put(67, new SevenBitBean(new byte[]{67}));
        iso8859To7bitmap.put(68, new SevenBitBean(new byte[]{68}));
        iso8859To7bitmap.put(69, new SevenBitBean(new byte[]{69}));
        iso8859To7bitmap.put(70, new SevenBitBean(new byte[]{70}));
        iso8859To7bitmap.put(71, new SevenBitBean(new byte[]{71}));
        iso8859To7bitmap.put(72, new SevenBitBean(new byte[]{72}));
        iso8859To7bitmap.put(73, new SevenBitBean(new byte[]{73}));
        iso8859To7bitmap.put(74, new SevenBitBean(new byte[]{74}));
        iso8859To7bitmap.put(75, new SevenBitBean(new byte[]{75}));
        iso8859To7bitmap.put(76, new SevenBitBean(new byte[]{76}));
        iso8859To7bitmap.put(77, new SevenBitBean(new byte[]{77}));
        iso8859To7bitmap.put(78, new SevenBitBean(new byte[]{78}));
        iso8859To7bitmap.put(79, new SevenBitBean(new byte[]{79}));
        iso8859To7bitmap.put(80, new SevenBitBean(new byte[]{80}));
        iso8859To7bitmap.put(81, new SevenBitBean(new byte[]{81}));
        iso8859To7bitmap.put(82, new SevenBitBean(new byte[]{82}));
        iso8859To7bitmap.put(83, new SevenBitBean(new byte[]{83}));
        iso8859To7bitmap.put(84, new SevenBitBean(new byte[]{84}));
        iso8859To7bitmap.put(85, new SevenBitBean(new byte[]{85}));
        iso8859To7bitmap.put(86, new SevenBitBean(new byte[]{86}));
        iso8859To7bitmap.put(87, new SevenBitBean(new byte[]{87}));
        iso8859To7bitmap.put(88, new SevenBitBean(new byte[]{88}));
        iso8859To7bitmap.put(89, new SevenBitBean(new byte[]{89}));
        iso8859To7bitmap.put(90, new SevenBitBean(new byte[]{90}));
        iso8859To7bitmap.put(196, new SevenBitBean(new byte[]{91}));
        iso8859To7bitmap.put(214, new SevenBitBean(new byte[]{92}));
        iso8859To7bitmap.put(209, new SevenBitBean(new byte[]{93}));
        iso8859To7bitmap.put(220, new SevenBitBean(new byte[]{94}));
        iso8859To7bitmap.put(167, new SevenBitBean(new byte[]{95}));
        iso8859To7bitmap.put(191, new SevenBitBean(new byte[]{96}));
        iso8859To7bitmap.put(97, new SevenBitBean(new byte[]{97}));
        iso8859To7bitmap.put(98, new SevenBitBean(new byte[]{98}));
        iso8859To7bitmap.put(99, new SevenBitBean(new byte[]{99}));
        iso8859To7bitmap.put(100, new SevenBitBean(new byte[]{100}));
        iso8859To7bitmap.put(101, new SevenBitBean(new byte[]{101}));
        iso8859To7bitmap.put(102, new SevenBitBean(new byte[]{102}));
        iso8859To7bitmap.put(103, new SevenBitBean(new byte[]{103}));
        iso8859To7bitmap.put(104, new SevenBitBean(new byte[]{104}));
        iso8859To7bitmap.put(105, new SevenBitBean(new byte[]{105}));
        iso8859To7bitmap.put(106, new SevenBitBean(new byte[]{106}));
        iso8859To7bitmap.put(107, new SevenBitBean(new byte[]{107}));
        iso8859To7bitmap.put(108, new SevenBitBean(new byte[]{108}));
        iso8859To7bitmap.put(109, new SevenBitBean(new byte[]{109}));
        iso8859To7bitmap.put(110, new SevenBitBean(new byte[]{110}));
        iso8859To7bitmap.put(111, new SevenBitBean(new byte[]{111}));
        iso8859To7bitmap.put(112, new SevenBitBean(new byte[]{112}));
        iso8859To7bitmap.put(113, new SevenBitBean(new byte[]{113}));
        iso8859To7bitmap.put(114, new SevenBitBean(new byte[]{114}));
        iso8859To7bitmap.put(115, new SevenBitBean(new byte[]{115}));
        iso8859To7bitmap.put(116, new SevenBitBean(new byte[]{116}));
        iso8859To7bitmap.put(117, new SevenBitBean(new byte[]{117}));
        iso8859To7bitmap.put(118, new SevenBitBean(new byte[]{118}));
        iso8859To7bitmap.put(119, new SevenBitBean(new byte[]{119}));
        iso8859To7bitmap.put(120, new SevenBitBean(new byte[]{120}));
        iso8859To7bitmap.put(121, new SevenBitBean(new byte[]{121}));
        iso8859To7bitmap.put(122, new SevenBitBean(new byte[]{122}));
        iso8859To7bitmap.put(228, new SevenBitBean(new byte[]{123}));
        iso8859To7bitmap.put(246, new SevenBitBean(new byte[]{124}));
        iso8859To7bitmap.put(241, new SevenBitBean(new byte[]{125}));
        iso8859To7bitmap.put(252, new SevenBitBean(new byte[]{126}));
        iso8859To7bitmap.put(224, new SevenBitBean(new byte[]{127}));
    }
}

