/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.perfhis.proxy;

import com.huawei.ism.common.bean.PerfStatObjectType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.module.perfhis.pojo.PerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.pojo.PerfStatHisObject;
import com.huawei.ism.util.ByteUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfStatHisFileProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfStatHisFileProxy.class);
    private static final int INFO_HEAD_LENGTH = 337;
    private static final int CHECK_CODE_LENGTH = 32;
    private static final int VERSION_LENGTH = 4;
    private static final int DEVICE_SN_LENGTH = 256;
    private static final int DEVICE_NAME_LENGTH = 41;
    private static final int DATA_LENGTH_LENGTH = 4;
    private static final int MERGE_FILE_SIZE_UPPER_LIMIT = 524288000;
    private static final long DATA_TIME_SEPARATE_UPPER_LIMIT = 31536000000L;
    private static final int BUFFER_LENGTH = 0x100000;
    private List<long[]> tlvInfos = null;

    private RandomAccessFile open(String fileName) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(fileName, "rw");
        return randomAccessFile;
    }

    private void close(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException e) {
                LOGGER.error("close performance history file error", (Throwable)e);
            }
        }
    }

    public PerfStatHisFileInfo queryPerfStatHisFileInfo(String fileName) {
        PerfStatHisFileInfo perfStatHisFileInfo = new PerfStatHisFileInfo();
        File file = new File(fileName);
        try {
            perfStatHisFileInfo.setFileName(file.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.error("get canonical path error :" + e.getMessage(), (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        perfStatHisFileInfo.setSize(file.length());
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = this.open(fileName);
            byte[] dataLengthBuf = this.setBytes(perfStatHisFileInfo, randomAccessFile);
            int dataLength = ByteUtil.bytes2int(dataLengthBuf, false);
            perfStatHisFileInfo.setDataLength(dataLength);
            this.dealQuery(perfStatHisFileInfo, randomAccessFile, dataLength);
            PerfStatHisFileInfo perfStatHisFileInfo2 = perfStatHisFileInfo;
            return perfStatHisFileInfo2;
        }
        catch (IOException e) {
            LOGGER.error("read data error", (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        catch (JSONException e) {
            LOGGER.error("performance history file json parse error :" + e.getMessage(), (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        finally {
            this.close(randomAccessFile);
        }
    }

    private void dealQuery(PerfStatHisFileInfo perfStatHisFileInfo, RandomAccessFile randomAccessFile, int dataLength) throws IOException {
        long minStartTime = Long.MAX_VALUE;
        long maxEndTime = Long.MIN_VALUE;
        while (randomAccessFile.getFilePointer() < randomAccessFile.length()) {
            int skipedLength = randomAccessFile.skipBytes(4);
            if (skipedLength != 4) {
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            byte[] tlvLengthBuf = new byte[4];
            randomAccessFile.readFully(tlvLengthBuf);
            int tlvLength = ByteUtil.bytes2int(tlvLengthBuf, false);
            byte[] jsonBuf = new byte[tlvLength - 4 - 4];
            randomAccessFile.readFully(jsonBuf);
            String json = new String(jsonBuf, "UTF-8").trim();
            JSONObject jsonObj = new JSONObject(json);
            long dataStartTime = jsonObj.getLong("StartTime") * 1000L;
            long dataEndTime = jsonObj.getLong("EndTime") * 1000L;
            int controllerId = jsonObj.getInt("CtrlID");
            int period = jsonObj.getInt("Archive") * 1000;
            long[] tlvInfo = new long[]{dataStartTime, dataEndTime, controllerId};
            perfStatHisFileInfo.getTlvInfos().add(tlvInfo);
            perfStatHisFileInfo.setPeriod(period);
            int dataBlockLength = 0;
            JSONObject objectMap = jsonObj.getJSONObject("Map");
            Iterator objectTypes = objectMap.keys();
            dataBlockLength = this.transferJsonDatas(dataLength, dataStartTime, dataEndTime, period, dataBlockLength, objectMap, objectTypes);
            minStartTime = minStartTime < dataStartTime ? minStartTime : dataStartTime;
            long l = maxEndTime = maxEndTime > dataEndTime ? maxEndTime : dataEndTime;
            skipedLength = randomAccessFile.skipBytes(dataBlockLength);
            if (skipedLength == dataBlockLength) continue;
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        perfStatHisFileInfo.setStartTime(minStartTime);
        perfStatHisFileInfo.setEndTime(maxEndTime);
    }

    private byte[] setBytes(PerfStatHisFileInfo perfStatHisFileInfo, RandomAccessFile randomAccessFile) throws IOException {
        byte[] headerBuf = new byte[337];
        randomAccessFile.readFully(headerBuf);
        byte[] checkCodeBuf = new byte[32];
        System.arraycopy(headerBuf, 0, checkCodeBuf, 0, checkCodeBuf.length);
        perfStatHisFileInfo.setCheckCode(new String(checkCodeBuf, Charset.defaultCharset()));
        byte[] versionBuf = new byte[4];
        System.arraycopy(headerBuf, 32, versionBuf, 0, versionBuf.length);
        perfStatHisFileInfo.setVersion(ByteUtil.bytes2int(versionBuf, false));
        byte[] deviceSnBuf = new byte[256];
        System.arraycopy(headerBuf, 36, deviceSnBuf, 0, deviceSnBuf.length);
        perfStatHisFileInfo.setDeviceSN(new String(deviceSnBuf, Charset.defaultCharset()).trim());
        byte[] deviceNameBuf = new byte[41];
        System.arraycopy(headerBuf, 292, deviceNameBuf, 0, deviceNameBuf.length);
        perfStatHisFileInfo.setDeviceName(new String(deviceNameBuf, "UTF-8").trim());
        byte[] dataLengthBuf = new byte[4];
        System.arraycopy(headerBuf, 333, dataLengthBuf, 0, dataLengthBuf.length);
        return dataLengthBuf;
    }

    private int transferJsonDatas(int dataLength, long dataStartTime, long dataEndTime, int period, int dataBlockLength, JSONObject objectMap, Iterator objectTypes) {
        int actualDataBlockLength = dataBlockLength;
        while (objectTypes.hasNext()) {
            String objectTypeString = (String)objectTypes.next();
            JSONObject objectTypeMap = objectMap.getJSONObject(objectTypeString);
            JSONArray namesJSONArray = objectTypeMap.getJSONArray("Names");
            JSONArray dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            int periodCount = period == 0 ? 0 : (int)((dataEndTime - dataStartTime) / (long)period);
            actualDataBlockLength += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength * periodCount;
        }
        return actualDataBlockLength;
    }

    public void populateObjectNamesAndDataTypes(PerfStatHisFileInfo perfStatHisFileInfo) {
        HashMap<PerfStatObjectType.ObjectTypeEnum, List<String>> objectTypeToNamesMapping = new HashMap<PerfStatObjectType.ObjectTypeEnum, List<String>>(0);
        HashMap<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> objectTypeToDataTypesMapping = new HashMap<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>>(0);
        LinkedList<PerfStatObjectType.ObjectTypeEnum> allObjectTypes = new LinkedList<PerfStatObjectType.ObjectTypeEnum>();
        RandomAccessFile randomFile = null;
        try {
            randomFile = this.open(perfStatHisFileInfo.getFileName());
            int skipedLength = randomFile.skipBytes(333);
            if (skipedLength != 333) {
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            byte[] dataLengthBuf = new byte[4];
            randomFile.readFully(dataLengthBuf);
            int dataLength = ByteUtil.bytes2int(dataLengthBuf, false);
            this.populateDatas(perfStatHisFileInfo, objectTypeToNamesMapping, objectTypeToDataTypesMapping, allObjectTypes, randomFile, dataLength);
        }
        catch (IOException e) {
            LOGGER.error("read data error", (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        catch (JSONException e) {
            LOGGER.error("performance history file json parse error :" + e.getMessage(), (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        finally {
            this.close(randomFile);
        }
    }

    private void populateDatas(PerfStatHisFileInfo perfStatHisFileInfo, Map<PerfStatObjectType.ObjectTypeEnum, List<String>> objectTypeToNamesMapping, Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> objectTypeToDataTypesMapping, List<PerfStatObjectType.ObjectTypeEnum> allObjectTypes, RandomAccessFile randomFile, int dataLength) throws IOException {
        while (randomFile.getFilePointer() < randomFile.length()) {
            int skipedLength = randomFile.skipBytes(4);
            if (skipedLength != 4) {
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            byte[] tlvLengthBuf = new byte[4];
            randomFile.readFully(tlvLengthBuf);
            int tlvLength = ByteUtil.bytes2int(tlvLengthBuf, false);
            byte[] jsonBuf = new byte[tlvLength - 4 - 4];
            randomFile.readFully(jsonBuf);
            String json = new String(jsonBuf, "UTF-8").trim();
            JSONObject jsonObj = new JSONObject(json);
            long dataStartTime = jsonObj.getLong("StartTime") * 1000L;
            long dataEndTime = jsonObj.getLong("EndTime") * 1000L;
            int period = jsonObj.getInt("Archive") * 1000;
            int dataBlockLength = 0;
            HashMap<PerfStatObjectType.ObjectTypeEnum, List<String>> objectTypeToNamesMappingTmp = new HashMap<PerfStatObjectType.ObjectTypeEnum, List<String>>(0);
            HashMap<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> objectTypeToDataTypesMappingTmp = new HashMap<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>>(0);
            LinkedList<PerfStatObjectType.ObjectTypeEnum> objectTypesTmp = new LinkedList<PerfStatObjectType.ObjectTypeEnum>();
            JSONObject objectMap = jsonObj.getJSONObject("Map");
            Iterator objectTypes = objectMap.keys();
            this.doPopulate(perfStatHisFileInfo, objectTypeToNamesMapping, objectTypeToDataTypesMapping, allObjectTypes, randomFile, dataLength, dataStartTime, dataEndTime, period, dataBlockLength, objectTypeToNamesMappingTmp, objectTypeToDataTypesMappingTmp, objectMap, objectTypesTmp, objectTypes);
        }
        perfStatHisFileInfo.setObjectTypes(allObjectTypes);
        perfStatHisFileInfo.setObjectTypeToNamesMapping(objectTypeToNamesMapping);
        perfStatHisFileInfo.setObjectTypeToDataTypeMapping(objectTypeToDataTypesMapping);
    }

    private void doPopulate(PerfStatHisFileInfo perfStatHisFileInfo, Map<PerfStatObjectType.ObjectTypeEnum, List<String>> objectTypeToNamesMapping, Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> objectTypeToDataTypesMapping, List<PerfStatObjectType.ObjectTypeEnum> allObjectTypes, RandomAccessFile randomFile, int dataLength, long dataStartTime, long dataEndTime, int period, int dataBlockLength, Map<PerfStatObjectType.ObjectTypeEnum, List<String>> objectTypeToNamesMappingTmp, Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> objectTypeToDataTypesMappingTmp, JSONObject objectMap, List<PerfStatObjectType.ObjectTypeEnum> objectTypesTmp, Iterator objectTypes) throws IOException {
        int actualDataBlockLength = dataBlockLength;
        while (objectTypes.hasNext()) {
            String objectTypeString = (String)objectTypes.next();
            PerfStatObjectType.ObjectTypeEnum objectType = PerfStatObjectType.ObjectTypeEnum.valueOf(Integer.parseInt(objectTypeString));
            JSONObject objectTypeMap = objectMap.getJSONObject(objectTypeString);
            JSONArray namesJSONArray = objectTypeMap.getJSONArray("Names");
            JSONArray dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            LinkedList<String> names = new LinkedList<String>();
            for (int i = 0; i < namesJSONArray.length(); ++i) {
                names.add(namesJSONArray.getString(i));
            }
            LinkedList<PerfStatObjectType.DataTypeEnum> dataTypes = new LinkedList<PerfStatObjectType.DataTypeEnum>();
            for (int j = 0; j < dataTypesJSONArray.length(); ++j) {
                dataTypes.add(PerfStatObjectType.DataTypeEnum.valueOf(dataTypesJSONArray.getInt(j)));
            }
            objectTypeToNamesMappingTmp.put(objectType, names);
            objectTypeToDataTypesMappingTmp.put(objectType, dataTypes);
            this.fillObjectTypeMapping(objectTypeToNamesMappingTmp, objectType, names);
            this.fillObjectDataMapping(objectTypeToDataTypesMappingTmp, objectType, dataTypes);
            objectTypesTmp.add(objectType);
            int periodCount = period == 0 ? 0 : (int)((dataEndTime - dataStartTime) / (long)period);
            actualDataBlockLength += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength * periodCount;
        }
        this.mergeObjectTypes(perfStatHisFileInfo, objectTypeToNamesMapping, objectTypeToDataTypesMapping, allObjectTypes, randomFile, dataStartTime, dataEndTime, actualDataBlockLength, objectTypeToNamesMappingTmp, objectTypeToDataTypesMappingTmp, objectTypesTmp);
    }

    private void mergeObjectTypes(PerfStatHisFileInfo perfStatHisFileInfo, Map<PerfStatObjectType.ObjectTypeEnum, List<String>> objectTypeToNamesMapping, Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> objectTypeToDataTypesMapping, List<PerfStatObjectType.ObjectTypeEnum> allObjectTypes, RandomAccessFile randomFile, long dataStartTime, long dataEndTime, int dataBlockLength, Map<PerfStatObjectType.ObjectTypeEnum, List<String>> objectTypeToNamesMappingTmp, Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> objectTypeToDataTypesMappingTmp, List<PerfStatObjectType.ObjectTypeEnum> objectTypesTmp) throws IOException {
        int skipedLength;
        if (dataEndTime >= perfStatHisFileInfo.getGraphicStartTime() && dataStartTime <= perfStatHisFileInfo.getGraphicEndTime()) {
            this.mergeObjectTypeToNamesMapping(objectTypeToNamesMapping, objectTypeToNamesMappingTmp);
            this.mergeObjectTypeToDataTypesMapping(objectTypeToDataTypesMapping, objectTypeToDataTypesMappingTmp);
            this.mergeObjectTypes(allObjectTypes, objectTypesTmp);
        }
        if ((skipedLength = randomFile.skipBytes(dataBlockLength)) != dataBlockLength) {
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
    }

    private void fillObjectDataMapping(Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> objectTypeToDataTypesMappingTmp, PerfStatObjectType.ObjectTypeEnum objectType, List<PerfStatObjectType.DataTypeEnum> dataTypes) {
        List<PerfStatObjectType.DataTypeEnum> dataList = objectTypeToDataTypesMappingTmp.get((Object)objectType);
        if (dataList != null) {
            dataList.addAll(dataTypes);
        } else {
            objectTypeToDataTypesMappingTmp.put(objectType, dataTypes);
        }
    }

    private void fillObjectTypeMapping(Map<PerfStatObjectType.ObjectTypeEnum, List<String>> objectTypeToNamesMappingTmp, PerfStatObjectType.ObjectTypeEnum objectType, List<String> names) {
        List<String> objList = objectTypeToNamesMappingTmp.get((Object)objectType);
        if (objList != null) {
            objList.addAll(names);
        } else {
            objectTypeToNamesMappingTmp.put(objectType, names);
        }
    }

    public List<PerfStatHisObject> queryPerfStatHisObject(PerfStatHisFileInfo perfStatHisFileInfo, PerfStatObjectType.ObjectTypeEnum objectType, List<String> names) {
        RandomAccessFile raf = null;
        try {
            raf = this.open(perfStatHisFileInfo.getFileName());
            int skipedLength = raf.skipBytes(333);
            if (skipedLength != 333) {
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            LinkedList<PerfStatHisObject> allPerfStatHisObjects = new LinkedList<PerfStatHisObject>();
            byte[] dataLengthBuf = new byte[4];
            raf.readFully(dataLengthBuf);
            int dataLength = ByteUtil.bytes2int(dataLengthBuf, false);
            this.queryPerfStatHisObject1(perfStatHisFileInfo, objectType, names, raf, skipedLength, allPerfStatHisObjects, dataLength);
            this.alignPerfStatHisObjects(allPerfStatHisObjects);
            LinkedList<PerfStatHisObject> linkedList = allPerfStatHisObjects;
            return linkedList;
        }
        catch (IOException e) {
            LOGGER.error("read data error", (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        catch (JSONException e) {
            LOGGER.error("performance history file json parse error :" + e.getMessage(), (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        finally {
            this.close(raf);
        }
    }

    private int queryPerfStatHisObject1(PerfStatHisFileInfo perfStatHisFileInfo, PerfStatObjectType.ObjectTypeEnum objectType, List<String> names, RandomAccessFile accessFile, int skipedLength, List<PerfStatHisObject> allPerfStatHisObjects, int dataLength) throws IOException, JSONException {
        byte[] tlvLengthBuf = null;
        int tlvLength = 0;
        byte[] jsonBuf = null;
        String json = null;
        JSONObject jsonObj = null;
        long dataStartTime = 0L;
        long dataEndTime = 0L;
        int period = 0;
        long currentPeriodDataTime = 0L;
        int periodDataLength = 0;
        int actualSkipedLength = skipedLength;
        while (accessFile.getFilePointer() < accessFile.length()) {
            actualSkipedLength = accessFile.skipBytes(4);
            if (actualSkipedLength != 4) {
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            tlvLengthBuf = new byte[4];
            accessFile.readFully(tlvLengthBuf);
            tlvLength = ByteUtil.bytes2int(tlvLengthBuf, false);
            jsonBuf = new byte[tlvLength - 4 - 4];
            accessFile.readFully(jsonBuf);
            json = new String(jsonBuf, "UTF-8").trim();
            jsonObj = new JSONObject(json);
            dataStartTime = jsonObj.getLong("StartTime") * 1000L;
            dataEndTime = jsonObj.getLong("EndTime") * 1000L;
            period = jsonObj.getInt("Archive") * 1000;
            currentPeriodDataTime = dataStartTime;
            periodDataLength = this.calculatePeriodDataLength(json, dataLength);
            actualSkipedLength = this.getSkipedLength(perfStatHisFileInfo, objectType, names, accessFile, actualSkipedLength, allPerfStatHisObjects, dataLength, json, dataEndTime, period, currentPeriodDataTime, periodDataLength);
        }
        return actualSkipedLength;
    }

    private int getSkipedLength(PerfStatHisFileInfo perfStatHisFileInfo, PerfStatObjectType.ObjectTypeEnum objectType, List<String> names, RandomAccessFile accessFile, int skipedLength, List<PerfStatHisObject> allPerfStatHisObjects, int dataLength, String json, long dataEndTime, int period, long currentPeriodDataTime, int periodDataLength) throws IOException {
        LinkedList<PerfStatHisObject> oneDataBlockPerfStatHisObjects = new LinkedList<PerfStatHisObject>();
        for (String name : names) {
            int offset = this.calculateOffset(json, dataLength, objectType, name);
            if (offset == -1) continue;
            PerfStatHisObject perfStatHisObject = new PerfStatHisObject();
            perfStatHisObject.setPeriod(period);
            perfStatHisObject.setObjectType(objectType);
            perfStatHisObject.setDataTypes(this.getDataTypes(json, objectType));
            perfStatHisObject.setName(name);
            oneDataBlockPerfStatHisObjects.add(perfStatHisObject);
        }
        boolean isFirstTime = true;
        int actualSkipedLength = skipedLength;
        for (long iterPeriodDataTime = currentPeriodDataTime; iterPeriodDataTime < dataEndTime; iterPeriodDataTime += (long)period) {
            if (iterPeriodDataTime >= perfStatHisFileInfo.getGraphicStartTime() && iterPeriodDataTime <= perfStatHisFileInfo.getGraphicEndTime()) {
                if (isFirstTime) {
                    this.initStartTime(oneDataBlockPerfStatHisObjects, iterPeriodDataTime);
                    isFirstTime = false;
                }
                this.getDataSource(objectType, names, accessFile, dataLength, json, periodDataLength, oneDataBlockPerfStatHisObjects);
                continue;
            }
            actualSkipedLength = accessFile.skipBytes(periodDataLength);
            if (actualSkipedLength == periodDataLength) continue;
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        allPerfStatHisObjects.addAll(oneDataBlockPerfStatHisObjects);
        return actualSkipedLength;
    }

    private void initStartTime(List<PerfStatHisObject> perfStatHisObjects, long startTime) {
        for (PerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            perfStatHisObject.setStartTime(startTime);
        }
    }

    public List<PerfStatHisObject> queryPerfStatHisObject(PerfStatHisFileInfo perfStatHisFileInfo, PerfStatObjectType.ObjectTypeEnum objectType, List<String> names, long maxDataLength) {
        List<PerfStatHisObject> perfStatHisObjects = this.queryPerfStatHisObject(perfStatHisFileInfo, objectType, names);
        this.cutDownData(perfStatHisObjects, names, maxDataLength);
        return perfStatHisObjects;
    }

    private void alignPerfStatHisObjects(List<PerfStatHisObject> perfStatHisObjects) {
        for (PerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            LinkedList<int[]> unionData = new LinkedList<int[]>();
            List<PerfStatObjectType.DataTypeEnum> unionDataTypes = this.getUnionDataTypes(perfStatHisObjects);
            List<int[]> srcData = perfStatHisObject.getData();
            List<PerfStatObjectType.DataTypeEnum> srcDataTypes = perfStatHisObject.getDataTypes();
            this.fillUnionData(unionData, unionDataTypes, srcData, srcDataTypes);
            perfStatHisObject.setDataTypes(unionDataTypes);
            perfStatHisObject.setData(unionData);
        }
    }

    private void fillUnionData(List<int[]> unionData, List<PerfStatObjectType.DataTypeEnum> unionDataTypes, List<int[]> srcData, List<PerfStatObjectType.DataTypeEnum> srcDataTypes) {
        for (int[] oneTimeSrcData : srcData) {
            int[] oneTimeUnionData = new int[unionDataTypes.size()];
            for (int i = 0; i < unionDataTypes.size(); ++i) {
                int pos = srcDataTypes.indexOf((Object)unionDataTypes.get(i));
                oneTimeUnionData[i] = pos != -1 ? oneTimeSrcData[pos] : 0xFFFFFF;
            }
            unionData.add(oneTimeUnionData);
        }
    }

    private List<PerfStatObjectType.DataTypeEnum> getUnionDataTypes(List<PerfStatHisObject> perfStatHisObjects) {
        ArrayList<PerfStatObjectType.DataTypeEnum> dataTypes = new ArrayList<PerfStatObjectType.DataTypeEnum>();
        for (PerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            dataTypes.removeAll(perfStatHisObject.getDataTypes());
            dataTypes.addAll(perfStatHisObject.getDataTypes());
        }
        return dataTypes;
    }

    private void cutDownData(List<PerfStatHisObject> perfStatHisObjects, List<String> names, long maxDataLength) {
        for (String name : names) {
            this.cutDownOneData(this.getPerfStatHisObjectByName(perfStatHisObjects, name), maxDataLength);
        }
    }

    private List<PerfStatHisObject> getPerfStatHisObjectByName(List<PerfStatHisObject> perfStatHisObjects, String name) {
        LinkedList<PerfStatHisObject> result = new LinkedList<PerfStatHisObject>();
        for (PerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            if (!name.equals(perfStatHisObject.getName())) continue;
            result.add(perfStatHisObject);
        }
        return result;
    }

    private void cutDownOneData(List<PerfStatHisObject> perfStatHisObjects, long maxDataLength) {
        long length = this.getOneDataLength(perfStatHisObjects);
        if (length < maxDataLength) {
            return;
        }
        double tamp = (double)length / (double)maxDataLength;
        int i = (int)Math.ceil(tamp);
        List<int[]> data = null;
        for (PerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            data = perfStatHisObject.getData();
            int index = 0;
            int count = 0;
            while (index < data.size()) {
                if (count % i != 0) {
                    data.remove(index);
                    --index;
                }
                ++index;
                ++count;
            }
            perfStatHisObject.setPeriod(perfStatHisObject.getPeriod() * i);
        }
    }

    private long getOneDataLength(List<PerfStatHisObject> perfStatHisObjects) {
        long length = 0L;
        for (PerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            length += (long)perfStatHisObject.getData().size();
        }
        return length;
    }

    private void getDataSource(PerfStatObjectType.ObjectTypeEnum objectType, List<String> names, RandomAccessFile raf, int dataLength, String json, int periodDataLength, List<PerfStatHisObject> oneDataBlockPerfStatHisObjects) throws IOException, JSONException {
        byte[] periodDataBuf = new byte[periodDataLength];
        raf.readFully(periodDataBuf);
        int offset = 0;
        PerfStatHisObject perfStatHisObject = null;
        List<PerfStatObjectType.DataTypeEnum> dataTypes = null;
        int[] values = null;
        byte[] valueBuf = null;
        for (String name : names) {
            offset = this.calculateOffset(json, dataLength, objectType, name);
            if (offset == -1) continue;
            perfStatHisObject = this.findPerfStatHisObject(oneDataBlockPerfStatHisObjects, name);
            if (perfStatHisObject == null) {
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            dataTypes = perfStatHisObject.getDataTypes();
            values = new int[dataTypes.size()];
            for (int i = 0; i < dataTypes.size(); ++i) {
                valueBuf = new byte[dataLength];
                System.arraycopy(periodDataBuf, offset + i * dataLength, valueBuf, 0, valueBuf.length);
                values[i] = ByteUtil.bytes2int(valueBuf, false);
            }
            perfStatHisObject.getData().add(values);
        }
    }

    public List<PerfStatHisObject> queryPerfStatHisObject(PerfStatHisFileInfo perfStatHisFileInfo, PerfStatObjectType.ObjectTypeEnum objectType, List<String> names, List<PerfStatObjectType.DataTypeEnum> dataTypes, long maxDataLength) {
        LinkedList<PerfStatHisObject> perfStatHisObjectsResult = new LinkedList<PerfStatHisObject>();
        List<PerfStatHisObject> perfStatHisObjects = this.queryPerfStatHisObject(perfStatHisFileInfo, objectType, names, maxDataLength);
        PerfStatHisObject perfStatHisObjectResult = null;
        List<int[]> data = null;
        List<PerfStatObjectType.DataTypeEnum> allDataTypes = null;
        LinkedList<int[]> dataResult = null;
        int[] valueResult = null;
        for (PerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            perfStatHisObjectResult = new PerfStatHisObject();
            perfStatHisObjectResult.setStartTime(perfStatHisObject.getStartTime());
            perfStatHisObjectResult.setPeriod(perfStatHisObject.getPeriod());
            perfStatHisObjectResult.setObjectType(perfStatHisObject.getObjectType());
            perfStatHisObjectResult.setName(perfStatHisObject.getName());
            perfStatHisObjectResult.setDataTypes(dataTypes);
            data = perfStatHisObject.getData();
            allDataTypes = perfStatHisObject.getDataTypes();
            dataResult = new LinkedList<int[]>();
            for (int[] value : data) {
                valueResult = new int[dataTypes.size()];
                for (PerfStatObjectType.DataTypeEnum dataType : dataTypes) {
                    valueResult[dataTypes.indexOf((Object)((Object)dataType))] = value[allDataTypes.indexOf((Object)dataType)];
                }
                dataResult.add(valueResult);
            }
            perfStatHisObjectResult.setData(dataResult);
            perfStatHisObjectsResult.add(perfStatHisObjectResult);
        }
        return perfStatHisObjectsResult;
    }

    public boolean mergePerfStatHisFile(String destFileName, List<PerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        this.validateFiles(srcPerfStatHisFileInfos);
        List<long[]> allTlvInfos = this.getSortedTlvInfos(srcPerfStatHisFileInfos);
        byte[] buffer = new byte[0x100000];
        RandomAccessFile destRaf = null;
        try {
            byte[] deviceSnBuf = new byte[256];
            byte[] deviceSnBytes = srcPerfStatHisFileInfos.get(0).getDeviceSN().getBytes(Charset.defaultCharset());
            System.arraycopy(deviceSnBytes, 0, deviceSnBuf, 0, deviceSnBytes.length);
            byte[] deviceNameBuf = new byte[41];
            PerfStatHisFileInfo perfStatHisFileInfo = this.getLatestPerfStatHisFileInfo(srcPerfStatHisFileInfos);
            if (perfStatHisFileInfo == null) {
                LOGGER.error("Get Latest PerfStatHisFileInfo failed. ");
                boolean bl = false;
                return bl;
            }
            byte[] deviceNameBytes = perfStatHisFileInfo.getDeviceName().getBytes("UTF-8");
            System.arraycopy(deviceNameBytes, 0, deviceNameBuf, 0, deviceNameBytes.length);
            destRaf = this.open(destFileName);
            destRaf.writeBytes(srcPerfStatHisFileInfos.get(0).getCheckCode());
            destRaf.writeInt(ByteUtil.reverseInt(srcPerfStatHisFileInfos.get(0).getVersion()));
            destRaf.write(deviceSnBuf);
            destRaf.write(deviceNameBuf);
            destRaf.writeInt(ByteUtil.reverseInt(srcPerfStatHisFileInfos.get(0).getDataLength()));
            this.mergePerfStatHisFile1(srcPerfStatHisFileInfos, allTlvInfos, buffer, destRaf);
            boolean bl = true;
            this.close(destRaf);
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("read data error", (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        catch (JSONException e) {
            LOGGER.error("performance history file json parse error :" + e.getMessage(), (Throwable)e);
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
        }
        finally {
            this.close(destRaf);
        }
    }

    private void mergePerfStatHisFile1(List<PerfStatHisFileInfo> srcPerfStatHisFileInfos, List<long[]> allTlvInfos, byte[] buffer, RandomAccessFile destRaf) throws IOException, JSONException {
        int[] offsetAndLength = null;
        int offset = 0;
        int length = 0;
        for (long[] tlvInfo : allTlvInfos) {
            for (PerfStatHisFileInfo perfStatHisFileInfo : srcPerfStatHisFileInfos) {
                offsetAndLength = this.findData(perfStatHisFileInfo, tlvInfo[0], tlvInfo[1], tlvInfo[2]);
                offset = offsetAndLength[0];
                length = offsetAndLength[1];
                this.mergePerfStatHisFile2(buffer, destRaf, perfStatHisFileInfo, offset, length);
            }
        }
    }

    private void mergePerfStatHisFile2(byte[] buffer, RandomAccessFile destRaf, PerfStatHisFileInfo perfStatHisFileInfo, int offset, int length) throws IOException {
        if (offset != -1) {
            RandomAccessFile srcRaf = null;
            try {
                srcRaf = this.open(perfStatHisFileInfo.getFileName());
                int skipedLength = srcRaf.skipBytes(offset);
                if (skipedLength != offset) {
                    throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                }
                int actualLength = length;
                while (actualLength > 0) {
                    int readLength;
                    if (actualLength >= 0x100000) {
                        readLength = srcRaf.read(buffer);
                        destRaf.write(buffer);
                        actualLength -= readLength;
                        continue;
                    }
                    readLength = srcRaf.read(buffer, 0, actualLength);
                    destRaf.write(buffer, 0, actualLength);
                    actualLength -= readLength;
                }
            }
            catch (RuntimeException e) {
                LOGGER.error("read sssdata error", (Throwable)e);
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("read data error", (Throwable)e);
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"), (Throwable)e);
            }
            finally {
                this.close(srcRaf);
            }
        }
    }

    private PerfStatHisFileInfo getLatestPerfStatHisFileInfo(List<PerfStatHisFileInfo> perfStatHisFileInfos) {
        PerfStatHisFileInfo perfStatHisFileInfoResult = null;
        for (PerfStatHisFileInfo perfStatHisFileInfo : perfStatHisFileInfos) {
            if (perfStatHisFileInfoResult == null) {
                perfStatHisFileInfoResult = perfStatHisFileInfo;
                continue;
            }
            if (perfStatHisFileInfo.getStartTime() <= perfStatHisFileInfoResult.getStartTime()) continue;
            perfStatHisFileInfoResult = perfStatHisFileInfo;
        }
        return perfStatHisFileInfoResult;
    }

    private void validateFiles(List<PerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        if (this.containSameFile(srcPerfStatHisFileInfos)) {
            throw new IsmException(ResourceManager.getString("HIS_FILE_SAME"));
        }
        if (this.containDifferentDeviceSn(srcPerfStatHisFileInfos)) {
            throw new IsmException(ResourceManager.getString("HIS_FILE_DEV_SN_INVALID"));
        }
        if (this.containDifferentPeriod(srcPerfStatHisFileInfos)) {
            throw new IsmException(ResourceManager.getString("HIS_FILE_PERIOD_INVALID"));
        }
        if (this.calculateTotalSize(srcPerfStatHisFileInfos) > 524288000L) {
            throw new IsmException(ResourceManager.getStringWithParams("perf.error.mergeFilesTotalSizeTooLarge", String.valueOf(500)));
        }
        List<long[]> allTlvInfos = this.getSortedTlvInfos(srcPerfStatHisFileInfos);
        LinkedList<long[]> allTlvInfos0 = new LinkedList<long[]>();
        LinkedList<long[]> allTlvInfos1 = new LinkedList<long[]>();
        for (long[] tlvInfo : allTlvInfos) {
            if (tlvInfo[2] == 0L) {
                allTlvInfos0.add(tlvInfo);
            }
            if (tlvInfo[2] != 1L) continue;
            allTlvInfos1.add(tlvInfo);
        }
        if (this.isDataTimeSeparateTooLong(allTlvInfos)) {
            throw new IsmException(ResourceManager.getString("perf.error.dataSeparateTooLong"));
        }
        if (this.isDataTimeSegmentOverlap(allTlvInfos0)) {
            throw new IsmException(ResourceManager.getString("HIS_FILE_MERGE_TIME_INVALID"));
        }
        if (this.isDataTimeSegmentOverlap(allTlvInfos1)) {
            throw new IsmException(ResourceManager.getString("HIS_FILE_MERGE_TIME_INVALID"));
        }
    }

    private List<long[]> getSortedTlvInfos(List<PerfStatHisFileInfo> perfStatHisFileInfos) {
        this.tlvInfos = new LinkedList<long[]>();
        for (PerfStatHisFileInfo perfStatHisFileInfo : perfStatHisFileInfos) {
            this.tlvInfos.addAll(this.clone(perfStatHisFileInfo.getTlvInfos()));
        }
        this.sortTlvInfoByStartTime(this.tlvInfos);
        return this.tlvInfos;
    }

    private List<long[]> clone(List<long[]> tlvInfors) {
        ArrayList<long[]> tlvInfosResult = new ArrayList<long[]>(0);
        for (long[] tlvInfo : tlvInfors) {
            long[] tlvInfoResult = new long[tlvInfo.length];
            tlvInfoResult[0] = tlvInfo[0];
            tlvInfoResult[1] = tlvInfo[1];
            tlvInfoResult[2] = tlvInfo[2];
            tlvInfosResult.add(tlvInfoResult);
        }
        return tlvInfosResult;
    }

    private void sortTlvInfoByStartTime(List<long[]> dataStartAndEndTime) {
        long startTime1 = 0L;
        long startTime2 = 0L;
        for (int i = 0; i < dataStartAndEndTime.size(); ++i) {
            for (int j = 0; j < dataStartAndEndTime.size() - 1 - i; ++j) {
                startTime1 = dataStartAndEndTime.get(j)[0];
                if (startTime1 <= (startTime2 = dataStartAndEndTime.get(j + 1)[0])) continue;
                this.swap(dataStartAndEndTime.get(j), dataStartAndEndTime.get(j + 1));
            }
        }
    }

    private void swap(long[] longs, long[] longs1) {
        long[] longs2 = new long[]{longs[0], longs[1], longs[2]};
        longs[0] = longs1[0];
        longs[1] = longs1[1];
        longs[2] = longs1[2];
        longs1[0] = longs2[0];
        longs1[1] = longs2[1];
        longs1[2] = longs2[2];
    }

    private boolean containSameFile(List<PerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        String fileName1 = null;
        String fileName2 = null;
        for (int i = 0; i < srcPerfStatHisFileInfos.size(); ++i) {
            for (int j = i + 1; j < srcPerfStatHisFileInfos.size(); ++j) {
                fileName1 = srcPerfStatHisFileInfos.get(i).getCompressedFileName();
                if (!fileName1.equals(fileName2 = srcPerfStatHisFileInfos.get(j).getCompressedFileName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containDifferentDeviceSn(List<PerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        String deviceSn2 = null;
        String deviceSn1 = null;
        for (int i = 0; i < srcPerfStatHisFileInfos.size() - 1; ++i) {
            deviceSn1 = srcPerfStatHisFileInfos.get(i).getDeviceSN();
            if (deviceSn1.equals(deviceSn2 = srcPerfStatHisFileInfos.get(i + 1).getDeviceSN())) continue;
            return true;
        }
        return false;
    }

    private boolean containDifferentPeriod(List<PerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        int period1 = 0;
        int period2 = 0;
        for (int i = 0; i < srcPerfStatHisFileInfos.size() - 1; ++i) {
            period1 = srcPerfStatHisFileInfos.get(i).getPeriod();
            if (period1 == (period2 = srcPerfStatHisFileInfos.get(i + 1).getPeriod())) continue;
            return true;
        }
        return false;
    }

    private boolean isDataTimeSegmentOverlap(List<long[]> tlvInfoes) {
        long[] tlvInfo1 = null;
        long[] tlvInfo2 = null;
        for (int i = 0; i < tlvInfoes.size() - 1; ++i) {
            tlvInfo1 = tlvInfoes.get(i);
            if (tlvInfo1[1] <= (tlvInfo2 = tlvInfoes.get(i + 1))[0]) continue;
            return true;
        }
        return false;
    }

    private boolean isDataTimeSeparateTooLong(List<long[]> tlvInfoes) {
        long[] tlvInfo2 = null;
        long[] tlvInfo1 = null;
        for (int i = 0; i < tlvInfoes.size() - 1; ++i) {
            tlvInfo1 = tlvInfoes.get(i);
            tlvInfo2 = tlvInfoes.get(i + 1);
            if (tlvInfo2[0] - tlvInfo1[1] <= 31536000000L) continue;
            return true;
        }
        return false;
    }

    private long calculateTotalSize(List<PerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        long totalSize = 0L;
        for (PerfStatHisFileInfo perfStatHisFileInfo : srcPerfStatHisFileInfos) {
            totalSize += perfStatHisFileInfo.getCompressedSize();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findData(PerfStatHisFileInfo perfStatHisFileInfo, long dataStartTime, long dataEndTime, long controllerId) throws IOException, JSONException {
        int[] offsetAndLength = new int[]{-1, -1};
        List<long[]> tlvInfoes = perfStatHisFileInfo.getTlvInfos();
        RandomAccessFile raf = null;
        byte[] headerBuf = null;
        byte[] dataLengthBuf = null;
        int dataLength = 0;
        for (long[] tlvInfo : tlvInfoes) {
            if (tlvInfo[0] != dataStartTime || tlvInfo[1] != dataEndTime || tlvInfo[2] != controllerId) continue;
            offsetAndLength = new int[]{-1, -1};
            raf = null;
            try {
                raf = this.open(perfStatHisFileInfo.getFileName());
                headerBuf = new byte[337];
                raf.readFully(headerBuf);
                dataLengthBuf = new byte[4];
                System.arraycopy(headerBuf, 333, dataLengthBuf, 0, dataLengthBuf.length);
                dataLength = ByteUtil.bytes2int(dataLengthBuf, false);
                if ((offsetAndLength = this.findData1(dataStartTime, dataEndTime, offsetAndLength, raf, dataLength)).length <= 0) continue;
                int[] nArray = offsetAndLength;
                return nArray;
            }
            finally {
                this.close(raf);
            }
        }
        if (offsetAndLength.length == 0) {
            offsetAndLength = new int[]{-1, -1};
        }
        return offsetAndLength;
    }

    private int[] findData1(long dataStartTime, long dataEndTime, int[] offsetAndLength, RandomAccessFile raf, int dataLength) throws IOException, JSONException {
        int skipedLength = 0;
        byte[] tlvLengthBuf = null;
        int tlvLength = 0;
        byte[] jsonBuf = null;
        String json = null;
        JSONObject jsonObj = null;
        int offset = 0;
        int dataBlockLength = 0;
        long dataEndTimeTmp = 0L;
        long dataStartTimeTmp = 0L;
        while (raf.getFilePointer() < raf.length()) {
            skipedLength = raf.skipBytes(4);
            if (skipedLength != 4) {
                throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            tlvLengthBuf = new byte[4];
            raf.readFully(tlvLengthBuf);
            tlvLength = ByteUtil.bytes2int(tlvLengthBuf, false);
            jsonBuf = new byte[tlvLength - 4 - 4];
            raf.readFully(jsonBuf);
            json = new String(jsonBuf, "UTF-8").trim();
            jsonObj = new JSONObject(json);
            dataStartTimeTmp = jsonObj.getLong("StartTime") * 1000L;
            dataEndTimeTmp = jsonObj.getLong("EndTime") * 1000L;
            dataBlockLength = this.calculateDataBlockLength(json, dataLength);
            if (dataStartTime == dataStartTimeTmp && dataEndTime == dataEndTimeTmp) {
                offsetAndLength[0] = offset = (int)raf.getFilePointer() - tlvLength;
                offsetAndLength[1] = tlvLength + dataBlockLength;
                return offsetAndLength;
            }
            skipedLength = raf.skipBytes(dataBlockLength);
            if (skipedLength == dataBlockLength) continue;
            throw new IsmException(ResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        return new int[0];
    }

    private int calculateDataBlockLength(String json, int dataLength) throws JSONException {
        JSONObject jsonObj = new JSONObject(json);
        long dataStartTime = jsonObj.getLong("StartTime") * 1000L;
        long dataEndTime = jsonObj.getLong("EndTime") * 1000L;
        int period = jsonObj.getInt("Archive") * 1000;
        int dataBlockLength = 0;
        JSONObject objectMap = jsonObj.getJSONObject("Map");
        Iterator objectTypes = objectMap.keys();
        Object objectTypeString = null;
        Object objectTypeMap = null;
        Object dataTypesJSONArray = null;
        boolean periodCount = false;
        Object namesJSONArray = null;
        dataBlockLength = this.transferJsonDatas(dataLength, dataStartTime, dataEndTime, period, dataBlockLength, objectMap, objectTypes);
        return dataBlockLength;
    }

    private Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> mergeObjectTypeToDataTypesMapping(Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> destMapping, Map<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> srcMapping) {
        Iterator<Map.Entry<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>>> it = srcMapping.entrySet().iterator();
        Map.Entry<PerfStatObjectType.ObjectTypeEnum, List<PerfStatObjectType.DataTypeEnum>> entry = null;
        PerfStatObjectType.ObjectTypeEnum objectType = null;
        List<PerfStatObjectType.DataTypeEnum> srcDataTypes = null;
        List<PerfStatObjectType.DataTypeEnum> destDataTypes = null;
        while (it.hasNext()) {
            entry = it.next();
            objectType = entry.getKey();
            if (destMapping.keySet().contains((Object)objectType)) {
                destDataTypes = destMapping.get((Object)objectType);
                srcDataTypes = srcMapping.get((Object)objectType);
                for (PerfStatObjectType.DataTypeEnum srcDataType : srcDataTypes) {
                    if (destDataTypes.contains((Object)srcDataType)) continue;
                    destMapping.get((Object)objectType).add(srcDataType);
                }
                continue;
            }
            destMapping.put(objectType, srcMapping.get((Object)objectType));
        }
        return destMapping;
    }

    private Map<PerfStatObjectType.ObjectTypeEnum, List<String>> mergeObjectTypeToNamesMapping(Map<PerfStatObjectType.ObjectTypeEnum, List<String>> destMapping, Map<PerfStatObjectType.ObjectTypeEnum, List<String>> srcMapping) {
        Iterator<Map.Entry<PerfStatObjectType.ObjectTypeEnum, List<String>>> it = srcMapping.entrySet().iterator();
        List<String> srcNames = null;
        List<String> destNames = null;
        Map.Entry<PerfStatObjectType.ObjectTypeEnum, List<String>> entry = null;
        while (it.hasNext()) {
            entry = it.next();
            PerfStatObjectType.ObjectTypeEnum objectType = entry.getKey();
            if (destMapping.keySet().contains((Object)objectType)) {
                destNames = destMapping.get((Object)objectType);
                srcNames = srcMapping.get((Object)objectType);
                for (String srcName : srcNames) {
                    if (destNames.contains(srcName)) continue;
                    destMapping.get((Object)objectType).add(srcName);
                }
                continue;
            }
            destMapping.put(objectType, srcMapping.get((Object)objectType));
        }
        return destMapping;
    }

    private List<PerfStatObjectType.ObjectTypeEnum> mergeObjectTypes(List<PerfStatObjectType.ObjectTypeEnum> destObjectTypes, List<PerfStatObjectType.ObjectTypeEnum> srcObjectTypes) {
        for (PerfStatObjectType.ObjectTypeEnum objectType : srcObjectTypes) {
            if (destObjectTypes.contains((Object)objectType)) continue;
            destObjectTypes.add(objectType);
        }
        return destObjectTypes;
    }

    private PerfStatHisObject findPerfStatHisObject(List<PerfStatHisObject> perfStatHisObjects, String name) {
        for (PerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            if (!perfStatHisObject.getName().equals(name)) continue;
            return perfStatHisObject;
        }
        return null;
    }

    private int calculateOffset(String json, int dataLength, PerfStatObjectType.ObjectTypeEnum objectType, String name) throws JSONException {
        JSONObject jsonObj = new JSONObject(json);
        JSONObject objectMap = jsonObj.getJSONObject("Map");
        int offset = 0;
        List<String> objectTypeStrings = ByteUtil.getTypeIntgers(json);
        JSONObject objectTypeMap = null;
        JSONArray namesJSONArray = null;
        JSONArray dataTypesJSONArray = null;
        PerfStatObjectType.ObjectTypeEnum objectTypeTmp = null;
        String nameTmp = null;
        for (String objectTypeString : objectTypeStrings) {
            objectTypeTmp = PerfStatObjectType.ObjectTypeEnum.valueOf(Integer.parseInt(objectTypeString));
            objectTypeMap = objectMap.getJSONObject(objectTypeString);
            namesJSONArray = objectTypeMap.getJSONArray("Names");
            dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            if (objectType != objectTypeTmp) {
                offset += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength;
                continue;
            }
            for (int i = 0; i < namesJSONArray.length(); ++i) {
                nameTmp = namesJSONArray.getString(i);
                if (!name.equals(nameTmp)) {
                    offset += dataTypesJSONArray.length() * dataLength;
                    continue;
                }
                return offset;
            }
        }
        return -1;
    }

    private int calculatePeriodDataLength(String json, int dataLength) throws JSONException {
        JSONObject jsonObj = new JSONObject(json);
        int onePeriodDataLength = 0;
        JSONObject objectMap = jsonObj.getJSONObject("Map");
        Iterator objectTypes = objectMap.keys();
        String objectTypeString = null;
        JSONObject objectTypeMap = null;
        JSONArray namesJSONArray = null;
        JSONArray dataTypesJSONArray = null;
        while (objectTypes.hasNext()) {
            objectTypeString = (String)objectTypes.next();
            objectTypeMap = objectMap.getJSONObject(objectTypeString);
            namesJSONArray = objectTypeMap.getJSONArray("Names");
            dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            onePeriodDataLength += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength;
        }
        return onePeriodDataLength;
    }

    private List<PerfStatObjectType.DataTypeEnum> getDataTypes(String json, PerfStatObjectType.ObjectTypeEnum objectType) throws JSONException {
        LinkedList<PerfStatObjectType.DataTypeEnum> dataTypes = new LinkedList<PerfStatObjectType.DataTypeEnum>();
        JSONObject jsonObj = new JSONObject(json);
        JSONObject objectMap = jsonObj.getJSONObject("Map");
        Iterator objectTypesIt = objectMap.keys();
        String objectTypeString = null;
        JSONObject objectTypeMap = null;
        JSONArray dataTypesJSONArray = null;
        PerfStatObjectType.DataTypeEnum dataType = null;
        PerfStatObjectType.ObjectTypeEnum objectTypeTmp = null;
        while (objectTypesIt.hasNext()) {
            objectTypeString = (String)objectTypesIt.next();
            objectTypeMap = objectMap.getJSONObject(objectTypeString);
            objectTypeTmp = PerfStatObjectType.ObjectTypeEnum.valueOf(Integer.parseInt(objectTypeString));
            if (objectTypeTmp != objectType) continue;
            dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            for (int i = 0; i < dataTypesJSONArray.length(); ++i) {
                dataType = PerfStatObjectType.DataTypeEnum.valueOf(dataTypesJSONArray.getInt(i));
                if (dataTypes.contains((Object)dataType)) continue;
                dataTypes.add(dataType);
            }
        }
        return dataTypes;
    }
}

