/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.task;

import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BackgroundTask
implements Cloneable {
    private boolean isManualsTask;
    private String devName = "";
    private String deviceIdentifer = "";
    private Date beginDate = null;
    private String result = null;
    private Object taskOject = null;
    private int taskProgress = 0;
    private String taskSeriNum = "";
    private State taskState = null;
    private String task = null;
    private boolean isRemovedOnCompleted = false;
    private DeviceContext deviceContext;

    public BackgroundTask(String taskSN) {
        this.taskSeriNum = taskSN;
    }

    public BackgroundTask(String taskSN, State state, String deviceName, Object taskObj, String taskName, String taskDescription, int progress, String deviceID) {
        this(taskSN, state, deviceName, taskObj, taskName, taskDescription, progress, deviceID, false);
    }

    public BackgroundTask(String taskSN, State state, String deviceName, Object taskObj, String taskName, String taskDescription, int progress, String deviceID, boolean isManualTask) {
        this.devName = deviceName;
        this.deviceIdentifer = deviceID;
        this.result = taskDescription;
        this.taskOject = taskObj;
        this.taskProgress = progress;
        this.taskSeriNum = taskSN;
        this.taskState = state;
        this.task = taskName;
        this.isManualsTask = isManualTask;
    }

    public BackgroundTask(String taskSN, State state, String deviceName, Object taskObj, String taskName, String taskDescription, int progress, String deviceID, boolean isManualTask, DeviceContext context) {
        this.devName = deviceName;
        this.deviceIdentifer = deviceID;
        this.result = taskDescription;
        this.taskOject = taskObj;
        this.taskProgress = progress;
        this.taskSeriNum = taskSN;
        this.taskState = state;
        this.task = taskName;
        this.isManualsTask = isManualTask;
        this.deviceContext = context;
    }

    public boolean isRemoveOnCompleted() {
        return this.isRemovedOnCompleted;
    }

    public void setRemoveOnCompleted(boolean isRemoveOnCompleted) {
        this.isRemovedOnCompleted = isRemoveOnCompleted;
    }

    public boolean canManualRemoved() {
        return State.FAILED == this.taskState || State.COMPLETED_WARNING == this.taskState || State.COMPLETED_NORMAL == this.taskState;
    }

    public boolean canRediscovery(BackgroundTask taskTemp) {
        if (null == taskTemp.getName()) {
            return false;
        }
        return taskTemp.getName().equals(ResourceManager.getString("TASK_TYPE_DISCOVER_ARRAY")) && State.FAILED == this.taskState;
    }

    public BackgroundTask clone() {
        BackgroundTask newObj = null;
        try {
            super.clone();
            newObj = (BackgroundTask)super.clone();
        }
        catch (CloneNotSupportedException e) {
            newObj = null;
        }
        return newObj;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BackgroundTask)) {
            return false;
        }
        BackgroundTask other = (BackgroundTask)obj;
        return this.getTaskSN().equals(other.getTaskSN());
    }

    public String getDeviceName() {
        return this.devName;
    }

    public Date getBeginDate() {
        return (Date)this.beginDate.clone();
    }

    public String getResult() {
        return this.result;
    }

    public String getDviceId() {
        return this.deviceIdentifer;
    }

    public void setDeviceID(String deviceID) {
        this.deviceIdentifer = deviceID;
    }

    public Object getTaskObject() {
        return this.taskOject;
    }

    public int getProgress() {
        return this.taskProgress;
    }

    public String getTaskSN() {
        return this.taskSeriNum;
    }

    public State getState() {
        return this.taskState;
    }

    public String getName() {
        return this.task;
    }

    public int hashCode() {
        return this.getTaskSN().hashCode();
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = (Date)beginDate.clone();
    }

    public void setResult(String description) {
        this.result = description;
    }

    public void setTaskObject(Object obj) {
        this.taskOject = obj;
    }

    public void setDeviceName(String deviceName) {
        this.devName = deviceName;
    }

    public void setProgress(int taskProgressTemp) {
        this.taskProgress = taskProgressTemp;
    }

    public void setState(State taskStateTemp) {
        this.taskState = taskStateTemp;
    }

    public void setName(String taskName) {
        this.task = taskName;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("ArrayName", (Object)this.getDeviceName()).append("OperationObject", this.getTaskObject()).append("Description", (Object)this.getResult()).append("SN", (Object)this.getTaskSN()).append("State", (Object)this.getState()).append("Type", (Object)this.getName()).append("Progress", this.getProgress()).toString();
    }

    public boolean isManualTask() {
        return this.isManualsTask;
    }

    public DeviceContext getDeviceContext() {
        return this.deviceContext;
    }

    public static enum State {
        RUNNING_NORMAL,
        RUNNING_WARNING,
        COMPLETED_NORMAL,
        COMPLETED_WARNING,
        FAILED;


        public String toString() {
            String key = "COMMON.ENUM.TASK_STATE_" + this.name();
            return ResourceManager.getString(key, this.name());
        }
    }
}

