/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.IsmFileTree;
import com.huawei.ism.ui.swing.dialog.CommonDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class IsmDirChooser
extends CommonDialog
implements TreeSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean enable = false;
    private boolean isPast = false;
    private IsmFileTree fileTree = new IsmFileTree();
    private JTextField textResult;
    private File pastFile = null;

    public IsmDirChooser(Frame parent, String title) {
        super(parent);
        this.initComponents();
        this.setModal(true);
        this.setPreferredSize(new Dimension(400, 400));
        this.pack();
        this.setResizable(false);
    }

    public IsmDirChooser(JDialog parent, String title) {
        super(parent);
        this.initComponents();
        this.setModal(true);
        this.setPreferredSize(new Dimension(300, 400));
        this.pack();
        this.setResizable(false);
    }

    public static File showDialog(Component parent, String title) {
        IsmFileChooser chooser = new IsmFileChooser(title);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }

            @Override
            public String getDescription() {
                return ResourceManager.getString("COMMON_DIR_CHOOSER_DESC");
            }
        });
        chooser.setFileSelectionMode(1);
        if (chooser.showSaveDialog(parent) == 0) {
            File aFile = chooser.getSelectedFile();
            return aFile;
        }
        return null;
    }

    private void initComponents() {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        JScrollPane ismScrollPane = new JScrollPane(this.fileTree);
        centerPanel.add(ismScrollPane);
        centerPanel.add(Box.createVerticalStrut(12));
        JPanel foldPanel = new JPanel();
        foldPanel.setLayout(new BoxLayout(foldPanel, 0));
        JLabel textLabel = new JLabel(ResourceManager.getString("FOLDER_NAME_TIP") + ":");
        this.textResult = new JTextField();
        this.textResult.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String path = IsmDirChooser.this.textResult.getText();
                IsmDirChooser.this.pastFile = new File(FilePathUtils.filterPath(Utils.fixFotifyPathManipulation(path)));
                IsmDirChooser.this.fileTree.removeSelectionPath(IsmDirChooser.this.fileTree.getSelectionPath());
                IsmDirChooser.this.enable = false;
                if (null == FilePathUtils.getCanonicalPath(IsmDirChooser.this.pastFile) || FilePathUtils.getCanonicalPath(IsmDirChooser.this.pastFile).endsWith(".")) {
                    IsmDirChooser.this.isPast = false;
                    return;
                }
                if (IsmDirChooser.this.pastFile.isDirectory()) {
                    IsmDirChooser.this.isPast = true;
                } else {
                    IsmDirChooser.this.isPast = false;
                }
            }
        });
        foldPanel.add(textLabel);
        foldPanel.add(Box.createHorizontalStrut(12));
        foldPanel.add(this.textResult);
        centerPanel.add(foldPanel);
        this.fileTree.addTreeSelectionListener(this);
        this.getApplyButton().setVisible(false);
        this.getHelpButton().setVisible(false);
        this.setDisplayPanel(centerPanel, ResourceManager.getString("FOLDER_TOP_TIP"));
        this.pack();
    }

    @Override
    protected void setDisplayPanel(JComponent displayPanel, String message) {
        JPanel upPanel = new JPanel();
        upPanel.setLayout(new BoxLayout(upPanel, 1));
        JPanel panel = this.getInfoPanel(message);
        Box box = Box.createHorizontalBox();
        box.add(panel);
        box.add(Box.createHorizontalStrut(4000));
        upPanel.add(box);
        upPanel.add(Box.createVerticalStrut(10));
        upPanel.add(displayPanel);
        this.setDisplayPanel(upPanel);
    }

    @Override
    protected void confirmButtonMouseClicked(ActionEvent evt) {
        if (!this.enable && !this.isPast) {
            DialogUtils.showErrorDialog(this, ResourceManager.getString("DIR_ERROR"));
        } else {
            this.dispose();
        }
    }

    @Override
    protected void cancelButtonMouseClicked(ActionEvent evt) {
        this.enable = false;
        this.dispose();
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        File selectFile = this.fileTree.getSelectFile();
        this.enable = selectFile != null;
        boolean bl = this.enable = this.enable && IsmFileTree.FILESYSTEM_VIEW.isFileSystem(selectFile);
        if (selectFile != null && IsmFileTree.FILESYSTEM_VIEW.isDrive(selectFile)) {
            boolean bl2 = this.enable = this.enable && selectFile.canWrite();
        }
        if (selectFile != null) {
            this.textResult.setText(IsmFileTree.FILESYSTEM_VIEW.getSystemDisplayName(selectFile));
            this.isPast = false;
        }
    }

    public IsmFileTree getFileTree() {
        return this.fileTree;
    }

    public File getSelectFile() {
        return this.fileTree.getSelectFile();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public File getPastFile() {
        return this.pastFile;
    }
}

