/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoundSpinner2
extends JSpinner {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundSpinner2.class);
    private static final long serialVersionUID = -2762958733893460237L;
    private final SpinnerNumberModel model;
    private Pattern pattern;
    private JSpinner.NumberEditor editor;

    public RoundSpinner2(SpinnerNumberModel model) {
        super(model);
        this.model = model;
    }

    public RoundSpinner2(SpinnerNumberModel model, String reg) {
        super(model);
        this.pattern = Pattern.compile(reg);
        this.model = model;
        this.init();
    }

    private void init() {
        this.setModel(this.model);
        this.editor = new JSpinner.NumberEditor((JSpinner)this, "0");
        final JFormattedTextField textField = this.editor.getTextField();
        textField.setDocument(new PlainDocument(){
            private static final long serialVersionUID = -594940272272401437L;

            @Override
            protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
                String proposedInsert;
                try {
                    proposedInsert = this.getText(0, this.getLength());
                }
                catch (BadLocationException e) {
                    LOGGER.error("bad location exception:", (Throwable)e);
                    return;
                }
                Matcher matcher = RoundSpinner2.this.pattern.matcher(proposedInsert);
                if (!matcher.matches()) {
                    try {
                        this.remove(chng.getOffset(), chng.getLength());
                        textField.setText(RoundSpinner2.this.model.getMaximum().toString());
                    }
                    catch (BadLocationException e) {
                        LOGGER.error("bad location exception:", (Throwable)e);
                    }
                    return;
                }
                super.insertUpdate(chng, attr);
            }
        });
        this.setEditor(this.editor);
    }

    @Override
    public Object getNextValue() {
        try {
            if (Integer.parseInt(this.getValue().toString()) >= Integer.parseInt(this.model.getMaximum().toString())) {
                return this.model.getMinimum();
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("getNextValue error", (Throwable)e);
        }
        return super.getNextValue();
    }

    @Override
    public Object getPreviousValue() {
        try {
            if (Integer.parseInt(this.getValue().toString()) <= Integer.parseInt(this.model.getMinimum().toString())) {
                return this.model.getMaximum();
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("getPreviousValue error", (Throwable)e);
        }
        return super.getPreviousValue();
    }
}

