/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.border;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class ImageBorder
extends AbstractBorder
implements UIResource {
    private static final long serialVersionUID = -7361578435254143149L;
    private ImageIcon topCenterImgIcon;
    private ImageIcon leftUpConnerImgIcon;
    private ImageIcon rightUpConnerImgIcon;
    private ImageIcon leftCenterImgIcon;
    private ImageIcon rightCenterImgIcon;
    private ImageIcon bottomCenterImgIcon;
    private ImageIcon leftBottomConnerImgIcon;
    private ImageIcon rightBottomConnerImgIcon;
    private boolean isAssignImg;

    public ImageBorder() {
        this.isAssignImg = false;
    }

    public ImageBorder(ImageIcon topLeft, ImageIcon topCenter, ImageIcon topRight, ImageIcon leftCenter, ImageIcon rightCenter, ImageIcon bottomLeft, ImageIcon bottomCenter, ImageIcon bottomRight) {
        this.leftUpConnerImgIcon = topLeft;
        this.topCenterImgIcon = topCenter;
        this.rightUpConnerImgIcon = topRight;
        this.leftCenterImgIcon = leftCenter;
        this.rightCenterImgIcon = rightCenter;
        this.leftBottomConnerImgIcon = bottomLeft;
        this.bottomCenterImgIcon = bottomCenter;
        this.rightBottomConnerImgIcon = bottomRight;
        this.isAssignImg = true;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (this.isAssignImg) {
            return new Insets(this.topCenterImgIcon.getIconHeight(), this.leftCenterImgIcon.getIconWidth(), this.bottomCenterImgIcon.getIconHeight(), this.rightCenterImgIcon.getIconWidth());
        }
        if (component instanceof JPopupMenu) {
            this.getPopupMenuIcon();
            return new Insets(this.topCenterImgIcon.getIconHeight(), this.leftCenterImgIcon.getIconWidth(), this.bottomCenterImgIcon.getIconHeight(), this.rightCenterImgIcon.getIconWidth());
        }
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        if (!this.isAssignImg) {
            if (!(component instanceof JPopupMenu)) {
                return;
            }
            this.getPopupMenuIcon();
        }
        int leftUpConnerW = this.leftUpConnerImgIcon.getIconWidth();
        int leftUpConnerH = this.leftUpConnerImgIcon.getIconHeight();
        int topCenterH = this.topCenterImgIcon.getIconHeight();
        int rightUpConnerW = this.rightUpConnerImgIcon.getIconWidth();
        int rightUpConnerH = this.rightUpConnerImgIcon.getIconHeight();
        int leftCenterW = this.leftCenterImgIcon.getIconWidth();
        int rightCenterW = this.rightCenterImgIcon.getIconWidth();
        int leftBottomConnerW = this.leftBottomConnerImgIcon.getIconWidth();
        int leftBottomConnerH = this.leftBottomConnerImgIcon.getIconHeight();
        int bottomCenterH = this.bottomCenterImgIcon.getIconHeight();
        int rightBottomConnerW = this.rightBottomConnerImgIcon.getIconWidth();
        int rightBottomConnerH = this.rightBottomConnerImgIcon.getIconHeight();
        Graphics2D g2 = (Graphics2D)graphics;
        IsmPlafUtils.fillTexture(component, g2, this.leftUpConnerImgIcon, new Rectangle(xx, yy, leftUpConnerW, leftUpConnerH));
        IsmPlafUtils.fillTexture(component, g2, this.topCenterImgIcon, new Rectangle(xx + leftUpConnerW, yy, width - leftUpConnerW - rightUpConnerW, topCenterH));
        IsmPlafUtils.fillTexture(component, g2, this.rightUpConnerImgIcon, new Rectangle(xx + width - rightUpConnerW, yy, rightUpConnerW, rightUpConnerH));
        IsmPlafUtils.fillTexture(component, g2, this.leftCenterImgIcon, new Rectangle(xx, yy + leftUpConnerH, leftCenterW, height - leftUpConnerH - leftBottomConnerH));
        IsmPlafUtils.fillTexture(component, g2, this.rightCenterImgIcon, new Rectangle(xx + width - rightCenterW, yy + rightUpConnerH, rightCenterW, height - rightUpConnerH - rightBottomConnerH));
        IsmPlafUtils.fillTexture(component, g2, this.leftBottomConnerImgIcon, new Rectangle(xx, yy + height - leftBottomConnerH, leftBottomConnerW, leftBottomConnerH));
        IsmPlafUtils.fillTexture(component, g2, this.bottomCenterImgIcon, new Rectangle(xx + leftBottomConnerW, yy + height - bottomCenterH, width - leftBottomConnerW - rightBottomConnerW, bottomCenterH));
        IsmPlafUtils.fillTexture(component, g2, this.rightBottomConnerImgIcon, new Rectangle(xx + width - rightBottomConnerW, yy + height - rightBottomConnerH, rightBottomConnerW, rightBottomConnerH));
    }

    private void getPopupMenuIcon() {
        this.leftUpConnerImgIcon = (ImageIcon)UIManager.getIcon("PopupMenu.LeftUpConnerIcon");
        this.topCenterImgIcon = (ImageIcon)UIManager.getIcon("PopupMenu.topCenterIcon");
        this.rightUpConnerImgIcon = (ImageIcon)UIManager.getIcon("PopupMenu.rightUpConnerIcon");
        this.leftCenterImgIcon = (ImageIcon)UIManager.getIcon("PopupMenu.leftCenterIcon");
        this.rightCenterImgIcon = (ImageIcon)UIManager.getIcon("PopupMenu.rightCenterIcon");
        this.leftBottomConnerImgIcon = (ImageIcon)UIManager.getIcon("PopupMenu.leftBottomConnerIcon");
        this.bottomCenterImgIcon = (ImageIcon)UIManager.getIcon("PopupMenu.bottomCenterIcon");
        this.rightBottomConnerImgIcon = (ImageIcon)UIManager.getIcon("PopupMenu.rightBottomConnerIcon");
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

