/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.border;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;

public class RoundCornerBorder
extends AbstractBorder {
    private static final long serialVersionUID = 391663690830376728L;
    private Insets insetsForThis = new Insets(2, 2, 2, 2);
    private Color borderColorFor = null;

    public RoundCornerBorder() {
    }

    public RoundCornerBorder(Color borderColor) {
        this.borderColorFor = borderColor;
    }

    public RoundCornerBorder(Color borderColor, Insets insets) {
        this.borderColorFor = borderColor;
        this.insetsForThis = insets;
    }

    public RoundCornerBorder(Color borderColor, int top, int left, int bottom, int right) {
        this.borderColorFor = borderColor;
        this.insetsForThis = new Insets(top, left, bottom, right);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
        if (null == this.borderColorFor) {
            this.borderColorFor = component.getBackground();
        }
        IsmPlafUtils.drawBorderStyle(graphics, this.borderColorFor, this.borderColorFor, new Rectangle(xx, yy, width, height), true);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insetsForThis;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this.insetsForThis.top;
        insets.left = this.insetsForThis.left;
        insets.bottom = this.insetsForThis.bottom;
        insets.right = this.insetsForThis.right;
        return insets;
    }
}

