/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendarpicker;

import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.UIManager;

class LabelButton
extends JLabel {
    private static final long serialVersionUID = 7307244044431594976L;
    private Color defaultBackgroundColor = Color.WHITE;
    private Color defaultForegroundColor = Color.BLACK;
    private boolean isPress = false;
    private Color overBackgroundColor = UIManager.getColor("IsmButton.defaultBorderColor");
    private Color overForegroundColor = Color.WHITE;

    public LabelButton(String text) {
        super(text);
    }

    public LabelButton(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addHandler();
    }

    public void setDefualtBackground(Color clor) {
        this.defaultBackgroundColor = clor;
    }

    public void setDefualtForeground(Color fg) {
        this.defaultForegroundColor = fg;
    }

    public void setOverBackground(Color overBackground) {
        this.overBackgroundColor = overBackground;
    }

    public void setOverForeground(Color overForeground) {
        this.overForegroundColor = overForeground;
    }

    public void reset() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setDefualtBackground(Color.WHITE);
        this.setDefualtForeground(Color.BLACK);
        this.setFont(IsmFontFactory.getDialogPlain());
        this.setEnabled(true);
    }

    private void addHandler() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LabelButton button = (LabelButton)mouseEvent.getSource();
                if (button.isEnabled()) {
                    LabelButton.this.setCursor(new Cursor(12));
                    LabelButton.this.setBackgroundByDefaultColor();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LabelButton button = (LabelButton)mouseEvent.getSource();
                if (button.isEnabled()) {
                    LabelButton.this.setCursor(new Cursor(0));
                    LabelButton.this.setBackgroundByWhite();
                }
            }
        });
    }

    public void setPressed() {
        this.isPress = true;
        this.setBackgroundByDefaultColor();
    }

    private void setBackgroundByDefaultColor() {
        this.setBackground(this.overBackgroundColor);
        this.setForeground(this.overForegroundColor);
        this.setFont(IsmFontFactory.getDialogBold());
    }

    public void setExited() {
        this.isPress = false;
        this.setBackgroundByWhite();
    }

    private void setBackgroundByWhite() {
        if (!this.isPress) {
            this.setBackground(this.defaultBackgroundColor);
            this.setForeground(this.defaultForegroundColor);
            this.setFont(IsmFontFactory.getDialogPlain());
        }
    }
}

