/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.chart;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.chart.CategoryCapacityTooltipGenerator;
import com.huawei.ism.ui.swing.chart.IsmDrawSupplier;
import com.huawei.ism.ui.swing.chart.IsmPieSectionLabelGenerator;
import com.huawei.ism.ui.swing.chart.IsmPieTooltipLabelGenerator;
import com.huawei.ism.ui.swing.chart.IsmStackBarTooltipLabelGenerator;
import com.huawei.ism.util.Unit;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.LineBorder;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.HorizontalAlignment;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.chart.ui.VerticalAlignment;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.chart.util.Rotation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class IsmChartFactory
extends ChartFactory {
    public static final Font DEFAULT_LABEL_FONT = IsmChartFactory.getLabelFont();
    public static final Font DEFAULT_TITLE_FONT = IsmChartFactory.getTitleFont();
    public static final Paint COLOR_LABLE_BACKGROUND = Color.decode("#CBE0F5");
    public static final Paint COLOR_GRAY = new Color(188, 186, 187);
    public static final Paint COLOR_GREEN = new Color(107, 177, 91);
    public static final Paint COLOR_RED = new Color(251, 52, 33);
    public static final Paint COLOR_ORANGE = new Color(255, 153, 52);
    public static final Paint COLOR_YELLOW = new Color(253, 238, 77);
    public static final Paint COLOR_BLUE = new Color(78, 138, 188);
    public static final Paint COLOR_BACKGROUND = new Color(240, 240, 240);
    public static final Paint COLOR_BACKGROUND_LINE = new Color(132, 132, 132);
    public static final Paint PIE_LEGENT_TITLE_BACKGROUND_COLOR = new Color(255, 255, 255);
    public static final Paint PIE_LEGENT_TITLE_BORDER_COLOR = new Color(187, 187, 187);
    public static final float DEFAULT_BAR_WIDTH = 0.075f;
    public static final float BAR_SPACE = 0.18f;
    private static List<Paint> customSeriesPaints = Collections.synchronizedList(new ArrayList());
    private static IsmDrawSupplier ismDrawSupplier = IsmDrawSupplier.getIsmDrawSupplier();
    private static Paint[] customPaints = null;
    private static final Dimension CHART_DIMENSION = new Dimension(350, 230);
    private static final double ITEM_MARGIN = 0.1;

    public static JPanel createPie3D(String title, Map<Comparable<?>, Double> map, int width, int height, String unit, float transparence, int dataPrecision, int percentPrecision) {
        DefaultPieDataset dataset = IsmChartFactory.map2DefaultPieDataset(map);
        return IsmChartFactory.createPie3D(title, dataset, width, height, unit, dataPrecision, percentPrecision);
    }

    public static JFreeChart create3DPieChart(String title, DefaultPieDataset dataset, String unit, int dataPrecision, int percentPrecision) {
        JFreeChart chart = IsmChartFactory.createPieChart3D((String)title, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        chart.setAntiAlias(true);
        PiePlot3D piePlot3D = (PiePlot3D)chart.getPlot();
        piePlot3D.setNoDataMessage(ResourceManager.getString("CHART_NO_DATA_MSG"));
        LegendTitle legend = chart.getLegend();
        legend.setItemFont(DEFAULT_LABEL_FONT);
        legend.setPosition(RectangleEdge.BOTTOM);
        legend.setHorizontalAlignment(HorizontalAlignment.CENTER);
        legend.setBorder(1.0, 1.0, 1.0, 1.0);
        BlockBorder frame = new BlockBorder(PIE_LEGENT_TITLE_BORDER_COLOR);
        legend.setFrame((BlockFrame)frame);
        legend.setBackgroundPaint(PIE_LEGENT_TITLE_BACKGROUND_COLOR);
        piePlot3D.setOutlineVisible(false);
        piePlot3D.setSectionOutlinesVisible(true);
        piePlot3D.setLabelBackgroundPaint(COLOR_LABLE_BACKGROUND);
        piePlot3D.setForegroundAlpha(1.0f);
        piePlot3D.setDrawingSupplier((DrawingSupplier)ismDrawSupplier);
        piePlot3D.setDepthFactor((double)0.08f);
        piePlot3D.setCircular(true);
        piePlot3D.setLabelGenerator((PieSectionLabelGenerator)new IsmPieSectionLabelGenerator(unit, dataPrecision, percentPrecision));
        piePlot3D.setBackgroundPaint((Paint)Color.WHITE);
        piePlot3D.setDefaultSectionOutlinePaint(COLOR_LABLE_BACKGROUND);
        piePlot3D.setDarkerSides(true);
        piePlot3D.setDirection(Rotation.ANTICLOCKWISE);
        piePlot3D.setInteriorGap((double)0.1f);
        piePlot3D.setLabelFont(DEFAULT_LABEL_FONT);
        piePlot3D.setLabelPadding(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        piePlot3D.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        piePlot3D.setLabelLinkMargin(0.01);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setTextAntiAlias(true);
        if (null != title && !"".equals(title)) {
            chart.setTitle(new TextTitle(title, DEFAULT_TITLE_FONT, TextTitle.DEFAULT_TEXT_PAINT, RectangleEdge.TOP, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING));
        }
        return chart;
    }

    public static JPanel createPie3D(String title, DefaultPieDataset dataset, int width, int height, String unit, int dataPrecision, int percentPrecision) {
        JFreeChart chart = IsmChartFactory.create3DPieChart(title, dataset, unit, dataPrecision, percentPrecision);
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        PiePlot piePlot = (PiePlot)chart.getPlot();
        piePlot.setToolTipGenerator((PieToolTipGenerator)new IsmPieTooltipLabelGenerator(unit, dataPrecision, percentPrecision));
        return IsmChartFactory.createPanel(chart, width, height);
    }

    public static JPanel createPie3DForV1R10(String title, DefaultPieDataset dataset, int width, int height, String unit, int dataPrecision, int percentPrecision, boolean simpleTooltip) {
        return IsmChartFactory.createPie3DForV1R10(title, dataset, width, height, unit, dataPrecision, percentPrecision, simpleTooltip, true);
    }

    public static JPanel createPie3DForV1R10(String title, DefaultPieDataset dataset, int width, int height, String unit, int dataPrecision, int percentPrecision, boolean simpleTooltip, boolean isCreateLagend) {
        JFreeChart chart = IsmChartFactory.create3DPieChartForV1R10(title, dataset, unit, dataPrecision, percentPrecision, isCreateLagend);
        PiePlot piePlot = (PiePlot)chart.getPlot();
        if (simpleTooltip) {
            piePlot.setToolTipGenerator((PieToolTipGenerator)new IsmPieTooltipLabelGenerator());
        } else {
            piePlot.setToolTipGenerator((PieToolTipGenerator)new IsmPieTooltipLabelGenerator(unit, dataPrecision, percentPrecision));
        }
        return IsmChartFactory.createPanel(chart, width, height);
    }

    public static JFreeChart create3DPieChartForV1R10(String title, DefaultPieDataset dataset, String unit, int dataPrecision, int percentPrecision) {
        return IsmChartFactory.create3DPieChartForV1R10(title, dataset, unit, dataPrecision, percentPrecision, true);
    }

    public static JFreeChart create3DPieChartForV1R10(String title, DefaultPieDataset dataset, String unit, int dataPrecision, int percentPrecision, boolean isCreateLegend) {
        JFreeChart chart = IsmChartFactory.createPieChart3D((String)title, (PieDataset)dataset, (boolean)isCreateLegend, (boolean)false, (boolean)false);
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        chart.setAntiAlias(true);
        chart.setBorderVisible(false);
        chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setTextAntiAlias(true);
        if (null != title && !"".equals(title)) {
            chart.setTitle(new TextTitle(title, DEFAULT_TITLE_FONT, TextTitle.DEFAULT_TEXT_PAINT, RectangleEdge.TOP, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING));
        }
        PiePlot3D piePlot3D = (PiePlot3D)chart.getPlot();
        piePlot3D.setDrawingSupplier((DrawingSupplier)ismDrawSupplier);
        piePlot3D.setNoDataMessage(ResourceManager.getString("CHART_NO_DATA_MSG"));
        piePlot3D.setOutlineVisible(false);
        piePlot3D.setOutlinePaint((Paint)Color.BLACK);
        piePlot3D.setDarkerSides(true);
        piePlot3D.setDirection(Rotation.CLOCKWISE);
        piePlot3D.setBackgroundPaint((Paint)Color.WHITE);
        piePlot3D.setLabelFont(IsmChartFactory.getItemLabelFont());
        piePlot3D.setLabelBackgroundPaint((Paint)Color.WHITE);
        piePlot3D.setLabelOutlinePaint((Paint)Color.WHITE);
        piePlot3D.setLabelShadowPaint((Paint)Color.WHITE);
        piePlot3D.setLabelPaint((Paint)Color.WHITE);
        piePlot3D.setLabelLinksVisible(false);
        if (isCreateLegend) {
            LegendTitle legend = chart.getLegend();
            legend.setItemFont(IsmChartFactory.getLabelFont());
            legend.setPosition(RectangleEdge.BOTTOM);
            legend.setHorizontalAlignment(HorizontalAlignment.CENTER);
            legend.setBorder(1.0, 1.0, 1.0, 1.0);
            BlockBorder frame = new BlockBorder(0.0, 0.0, 0.0, 0.0, PIE_LEGENT_TITLE_BORDER_COLOR);
            legend.setFrame((BlockFrame)frame);
            legend.setBackgroundPaint(PIE_LEGENT_TITLE_BACKGROUND_COLOR);
        }
        return chart;
    }

    private static Font getItemLabelFont() {
        Locale aDefault = Locale.getDefault();
        String lan = aDefault.getLanguage();
        Font chinese = new Font("\u5b8b\u4f53", 0, 1);
        Font english = new Font("Arial", 0, 1);
        if (lan.equals("en")) {
            return english;
        }
        return chinese;
    }

    public static JPanel createPie2D(String title, Map<Comparable<?>, Double> map, int width, int height, String unit, int dataPrecision, int percentPrecision) {
        DefaultPieDataset dataset = IsmChartFactory.map2DefaultPieDataset(map);
        return IsmChartFactory.createPie2D(title, dataset, width, height, unit, dataPrecision, percentPrecision);
    }

    public static JPanel createPie2D(String title, DefaultPieDataset dataset, int width, int height, String unit, int dataPrecision, int percentPrecision) {
        JFreeChart chart = IsmChartFactory.createPieChart(title, (PieDataset)dataset, true, true, false);
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        PiePlot piePlot = (PiePlot)chart.getPlot();
        IsmChartFactory.setPiePlot(unit, dataPrecision, percentPrecision, chart, piePlot);
        JPanel inPanel = IsmChartFactory.createPanel(chart, width, height);
        inPanel.setPreferredSize(CHART_DIMENSION);
        inPanel.setMinimumSize(CHART_DIMENSION);
        inPanel.setMaximumSize(CHART_DIMENSION);
        Box chartBox = Box.createVerticalBox();
        chartBox.add(Box.createVerticalGlue());
        chartBox.add(inPanel);
        chartBox.add(Box.createVerticalGlue());
        JPanel outPanel = new JPanel();
        outPanel.setLayout(new BorderLayout());
        outPanel.setOpaque(false);
        outPanel.add((Component)chartBox, "Center");
        return outPanel;
    }

    private static void setPiePlot(String unit, int dataPrecision, int percentPrecision, JFreeChart chart, PiePlot piePlot) {
        piePlot.setDrawingSupplier((DrawingSupplier)ismDrawSupplier);
        piePlot.setLabelGenerator((PieSectionLabelGenerator)new IsmPieSectionLabelGenerator(unit, dataPrecision, percentPrecision));
        piePlot.setToolTipGenerator((PieToolTipGenerator)new IsmPieTooltipLabelGenerator(unit, dataPrecision, percentPrecision));
        Iterator iterator = chart.getSubtitles().iterator();
        Title subtitle = null;
        LegendTitle leg = null;
        while (iterator.hasNext()) {
            subtitle = (Title)iterator.next();
            if (!(subtitle instanceof LegendTitle)) continue;
            leg = (LegendTitle)subtitle;
            leg.setFrame((BlockFrame)new LineBorder((Paint)LayoutConstants.TABBED_PANE_BACKGROUND_COLOR, (Stroke)new BasicStroke(1.0f), new RectangleInsets(1.0, 1.0, 1.0, 1.0)));
            leg.setBackgroundPaint((Paint)LayoutConstants.TABBED_PANE_BACKGROUND_COLOR);
            leg.setPosition(RectangleEdge.BOTTOM);
            leg.setItemFont(DEFAULT_LABEL_FONT);
            leg.setVerticalAlignment(VerticalAlignment.BOTTOM);
            leg.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        }
        piePlot.setBackgroundPaint((Paint)LayoutConstants.TABBED_PANE_BACKGROUND_COLOR);
        chart.setBackgroundPaint((Paint)LayoutConstants.TABBED_PANE_BACKGROUND_COLOR);
        chart.setBorderVisible(false);
        piePlot.setOutlineVisible(false);
        piePlot.setSectionOutlinesVisible(false);
        piePlot.setLabelLinksVisible(false);
        piePlot.setLabelOutlinePaint((Paint)LayoutConstants.TABBED_PANE_BACKGROUND_COLOR);
        piePlot.setLabelShadowPaint((Paint)LayoutConstants.TABBED_PANE_BACKGROUND_COLOR);
        piePlot.setLabelPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        piePlot.setLabelGap(0.0);
        piePlot.setLabelLinkMargin(0.05);
        piePlot.setInteriorGap(0.0);
        piePlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        piePlot.setMaximumLabelWidth(0.27);
        piePlot.setLegendItemShape((Shape)new Rectangle(10, 10));
    }

    public static JFreeChart createPieChart(String title, PieDataset dataset, boolean legend, boolean tooltips, boolean urls) {
        PiePlot plot = new PiePlot(dataset);
        plot.setLabelFont(DEFAULT_LABEL_FONT);
        plot.setLabelBackgroundPaint((Paint)LayoutConstants.TABBED_PANE_BACKGROUND_COLOR);
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        if (tooltips) {
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        }
        if (urls) {
            plot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator());
        }
        JFreeChart chart = new JFreeChart(title, DEFAULT_TITLE_FONT, (Plot)plot, legend);
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        return chart;
    }

    public static JFreeChart createStackedBarChart(CategoryDataset dataset, String unit, int dataPrecision, String titleText, String xText, String yText, PlotOrientation plotOrientation) {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"", (String)xText, (String)yText, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (null != titleText && !"".equals(titleText)) {
            Font font = IsmChartFactory.getTitleFont();
            chart.setTitle(new TextTitle(titleText, font, TextTitle.DEFAULT_TEXT_PAINT, RectangleEdge.TOP, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING));
        }
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot localCategoryPlot = (CategoryPlot)chart.getPlot();
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setNoDataMessage(ResourceManager.getString("CHART_NO_DATA_MSG"));
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLabelFont(DEFAULT_LABEL_FONT);
        domainAxis.setVisible(true);
        domainAxis.setTickLabelFont(DEFAULT_LABEL_FONT);
        domainAxis.setUpperMargin((double)0.18f);
        plot.setBackgroundPaint(COLOR_BACKGROUND);
        plot.setForegroundAlpha(1.0f);
        plot.setRenderer((CategoryItemRenderer)IsmChartFactory.getStackedBarRenderer(unit, dataPrecision));
        plot.setOutlinePaint(PIE_LEGENT_TITLE_BORDER_COLOR);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)new Color(192, 192, 192));
        plot.setRangeGridlinePaint(COLOR_BACKGROUND_LINE);
        plot.setRangeGridlinePaint((Paint)new Color(192, 192, 192));
        localCategoryPlot.setDrawingSupplier((DrawingSupplier)ismDrawSupplier);
        LegendTitle legendTitle = chart.getLegend();
        legendTitle.setItemFont(DEFAULT_LABEL_FONT);
        legendTitle.setPosition(RectangleEdge.BOTTOM);
        legendTitle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        legendTitle.setBorder(1.0, 1.0, 1.0, 1.0);
        BlockBorder frame = new BlockBorder(PIE_LEGENT_TITLE_BORDER_COLOR);
        legendTitle.setFrame((BlockFrame)frame);
        legendTitle.setBackgroundPaint(PIE_LEGENT_TITLE_BACKGROUND_COLOR);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setNumberFormatOverride(NumberFormat.getIntegerInstance());
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperMargin(0.1);
        rangeAxis.setLowerBound(0.0);
        rangeAxis.setLabelFont(DEFAULT_LABEL_FONT);
        return chart;
    }

    public static JPanel createPanel(JFreeChart chart, int width, int height) {
        ChartPanel charPanel = new ChartPanel(chart, width, height, 300, 200, 2048, 1536, true, true, true, true, true, true);
        charPanel.setName("ISMV1R2_platform_IsmChartFactory_charPanel");
        charPanel.setPopupMenu(null);
        charPanel.setBackground(Color.WHITE);
        return charPanel;
    }

    public static ChartPanel createPanel(JFreeChart chart) {
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setMouseZoomable(false);
        chartPanel.setPopupMenu(null);
        chartPanel.setOpaque(false);
        return chartPanel;
    }

    private static DefaultPieDataset map2DefaultPieDataset(Map<Comparable<?>, Double> map) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        Iterator<Map.Entry<Comparable<?>, Double>> it = map.entrySet().iterator();
        Map.Entry<Comparable<?>, Double> e = null;
        while (it.hasNext()) {
            e = it.next();
            defaultPieDataset.setValue(e.getKey(), (Number)e.getValue());
        }
        return defaultPieDataset;
    }

    public static JFreeChart createBarChart(CategoryDataset dataset, String titleText, String xText, String yText, PlotOrientation plotOrientation) {
        JFreeChart chart = ChartFactory.createBarChart((String)"", (String)xText, (String)yText, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        if (null != titleText && !"".equals(titleText)) {
            TextTitle title = new TextTitle(titleText, DEFAULT_TITLE_FONT);
            title.setHorizontalAlignment(HorizontalAlignment.CENTER);
            title.setTextAlignment(HorizontalAlignment.CENTER);
            chart.setTitle(title);
        }
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setNoDataMessage(ResourceManager.getString("CHART_NO_DATA_MSG"));
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLabelFont(DEFAULT_LABEL_FONT);
        domainAxis.setTickLabelFont(DEFAULT_TITLE_FONT);
        domainAxis.setVisible(false);
        domainAxis.setUpperMargin((double)0.18f);
        plot.setRenderer((CategoryItemRenderer)IsmChartFactory.getRenderer());
        plot.setBackgroundPaint(COLOR_BACKGROUND);
        plot.setForegroundAlpha(1.0f);
        plot.setOutlinePaint(PIE_LEGENT_TITLE_BORDER_COLOR);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)new Color(192, 192, 192));
        plot.setRangeGridlinePaint(COLOR_BACKGROUND_LINE);
        plot.setRangeGridlinePaint((Paint)new Color(192, 192, 192));
        LegendTitle legendTitle = chart.getLegend();
        legendTitle.setItemFont(DEFAULT_LABEL_FONT);
        legendTitle.setPosition(RectangleEdge.BOTTOM);
        legendTitle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        legendTitle.setBorder(1.0, 1.0, 1.0, 1.0);
        BlockBorder frame = new BlockBorder(0.0, 0.0, 0.0, 0.0, PIE_LEGENT_TITLE_BORDER_COLOR);
        legendTitle.setFrame((BlockFrame)frame);
        legendTitle.setBackgroundPaint(PIE_LEGENT_TITLE_BACKGROUND_COLOR);
        NumberAxis numberAxis = (NumberAxis)plot.getRangeAxis();
        numberAxis.setAutoRange(true);
        numberAxis.setNumberFormatOverride(NumberFormat.getIntegerInstance());
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setUpperMargin(0.1);
        numberAxis.setLowerBound(0.0);
        numberAxis.setLabelFont(DEFAULT_LABEL_FONT);
        return chart;
    }

    public static BarRenderer getRenderer() {
        BarRenderer renderer = new BarRenderer();
        renderer.setMaximumBarWidth((double)0.075f);
        renderer.setDefaultOutlinePaint((Paint)Color.BLACK);
        renderer.setItemLabelAnchorOffset(5.0);
        renderer.setIncludeBaseInRange(true);
        renderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setDefaultItemLabelsVisible(true);
        renderer.setItemMargin(0.1);
        renderer.setDefaultItemLabelFont(DEFAULT_LABEL_FONT, false);
        ItemLabelPosition itemLabelPositionFallback = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER, TextAnchor.BASELINE_CENTER, 0.0);
        renderer.setPositiveItemLabelPositionFallback(itemLabelPositionFallback);
        renderer.setNegativeItemLabelPositionFallback(itemLabelPositionFallback);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.BASELINE_CENTER, TextAnchor.BASELINE_CENTER, 0.0);
        renderer.setDefaultPositiveItemLabelPosition(itemLabelPosition);
        renderer.setDefaultNegativeItemLabelPosition(itemLabelPosition);
        renderer.setDefaultPaint((Paint)new Color(215, 215, 215));
        int index = 0;
        if (customSeriesPaints.size() < 1) {
            renderer.setSeriesPaint(index++, COLOR_BLUE);
            renderer.setSeriesPaint(index++, COLOR_GREEN);
            renderer.setSeriesPaint(index++, COLOR_ORANGE);
            renderer.setSeriesPaint(index++, COLOR_YELLOW);
            renderer.setSeriesPaint(index++, COLOR_RED);
            renderer.setSeriesPaint(index++, COLOR_GRAY);
        } else {
            for (Paint paint : customSeriesPaints) {
                renderer.setSeriesPaint(index++, paint);
            }
            customSeriesPaints.clear();
        }
        return renderer;
    }

    public static StackedBarRenderer getStackedBarRenderer(String unit, int dataPrecision) {
        StackedBarRenderer randerer = new StackedBarRenderer();
        randerer.setMaximumBarWidth((double)0.15f);
        randerer.setDefaultOutlinePaint((Paint)Color.BLACK);
        randerer.setItemLabelAnchorOffset(5.0);
        randerer.setIncludeBaseInRange(true);
        randerer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        randerer.setDefaultItemLabelsVisible(false);
        randerer.setItemMargin(0.1);
        randerer.setDefaultItemLabelFont(DEFAULT_LABEL_FONT, false);
        IsmStackBarTooltipLabelGenerator toolTipGenerator = new IsmStackBarTooltipLabelGenerator(unit, dataPrecision);
        randerer.setDefaultToolTipGenerator((CategoryToolTipGenerator)toolTipGenerator);
        ItemLabelPosition itemLabelPositionFallback = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER, TextAnchor.BASELINE_CENTER, 0.0);
        randerer.setPositiveItemLabelPositionFallback(itemLabelPositionFallback);
        randerer.setNegativeItemLabelPositionFallback(itemLabelPositionFallback);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.BASELINE_CENTER, TextAnchor.BASELINE_CENTER, 0.0);
        randerer.setDefaultPositiveItemLabelPosition(itemLabelPosition);
        randerer.setDefaultNegativeItemLabelPosition(itemLabelPosition);
        int index = 0;
        if (customSeriesPaints.size() < 1) {
            IsmChartFactory.setSeriesPaint((BarRenderer)randerer);
        } else {
            for (Paint paint : customSeriesPaints) {
                randerer.setSeriesPaint(index++, paint);
            }
        }
        return randerer;
    }

    public static JFreeChart createHStackedBarChart(String title, String domainAxisTitle, String rangeAxisTitle, CategoryDataset dataset, Unit.DataUnit unit, int percentPrecision) {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)title, (String)domainAxisTitle, (String)rangeAxisTitle, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (null != title && !"".equals(title)) {
            Font font = IsmChartFactory.getTitleFont();
            chart.setTitle(new TextTitle(title, font, TextTitle.DEFAULT_TEXT_PAINT, RectangleEdge.TOP, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING));
        }
        LegendTitle legendTitle = chart.getLegend();
        legendTitle.setItemFont(DEFAULT_LABEL_FONT);
        legendTitle.setPosition(RectangleEdge.RIGHT);
        legendTitle.setBackgroundPaint(PIE_LEGENT_TITLE_BACKGROUND_COLOR);
        legendTitle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        legendTitle.setBorder(1.0, 1.0, 1.0, 1.0);
        BlockBorder frame = new BlockBorder(0.0, 0.0, 0.0, 0.0, (Paint)Color.WHITE);
        legendTitle.setFrame((BlockFrame)frame);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        categoryPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        categoryPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        categoryPlot.setBackgroundPaint(COLOR_BACKGROUND);
        categoryPlot.setNoDataMessage(ResourceManager.getString("CHART_NO_DATA_MSG"));
        categoryPlot.setForegroundAlpha(0.85f);
        categoryPlot.setOutlinePaint(PIE_LEGENT_TITLE_BORDER_COLOR);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePaint((Paint)new Color(192, 192, 192));
        categoryPlot.setRangeGridlinePaint(COLOR_BACKGROUND_LINE);
        categoryPlot.setRangeGridlinePaint((Paint)new Color(192, 192, 192));
        categoryPlot.setDrawingSupplier((DrawingSupplier)ismDrawSupplier);
        CategoryAxis domainAxis = categoryPlot.getDomainAxis();
        domainAxis.setLabelFont(DEFAULT_LABEL_FONT);
        domainAxis.setTickLabelFont(DEFAULT_LABEL_FONT);
        domainAxis.setVisible(true);
        BarRenderer render = (BarRenderer)categoryPlot.getRenderer();
        render.setDrawBarOutline(true);
        render.setAutoPopulateSeriesPaint(false);
        render.setAutoPopulateSeriesFillPaint(false);
        render.setMaximumBarWidth(0.5);
        CategoryCapacityTooltipGenerator toolTipGenerator = new CategoryCapacityTooltipGenerator(unit, percentPrecision);
        render.setDefaultToolTipGenerator((CategoryToolTipGenerator)toolTipGenerator);
        IsmChartFactory.setSeriesPaint(render);
        NumberAxis rangeAxis = (NumberAxis)categoryPlot.getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setNumberFormatOverride(NumberFormat.getIntegerInstance());
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperMargin(0.1);
        rangeAxis.setLabelFont(DEFAULT_LABEL_FONT);
        return chart;
    }

    private static void setSeriesPaint(BarRenderer render) {
        Paint[] colors = customPaints;
        if (null == customPaints || 0 == customPaints.length) {
            colors = IsmDrawSupplier.ISM_DEFAULT_PAINT_SEQUENCE;
        }
        int index = 0;
        for (Paint paint : colors) {
            render.setSeriesPaint(index++, paint);
        }
    }

    @Deprecated
    public static void setColor(List<int[]> color) {
        ismDrawSupplier = IsmDrawSupplier.getIsmDrawSupplier(color);
    }

    public static void setColor(Paint ... colors) {
        customPaints = colors;
        ismDrawSupplier = IsmDrawSupplier.getIsmDrawSupplier(colors);
    }

    @Deprecated
    public static void setBarColor(List<int[]> color) {
        Color paint = null;
        for (int i = 0; i < color.size(); ++i) {
            paint = new Color(color.get(i)[0], color.get(i)[1], color.get(i)[2]);
            customSeriesPaints.add(paint);
        }
    }

    public static void setBarColor(Paint ... colors) {
        customSeriesPaints.clear();
        customSeriesPaints.addAll(Arrays.asList(colors));
    }

    private static Font getTitleFont() {
        Locale aDefault = Locale.getDefault();
        String lan = aDefault.getLanguage();
        Font chinese = new Font("\u9ed1\u4f53", 0, 16);
        Font english = new Font("Arial", 1, 15);
        if (lan.equals("en")) {
            return english;
        }
        return chinese;
    }

    private static Font getLabelFont() {
        Locale aDefault = Locale.getDefault();
        String lan = aDefault.getLanguage();
        Font chinese = new Font("\u9ed1\u4f53", 0, 13);
        Font english = new Font("Arial", 0, 12);
        if (lan.equals("en")) {
            return english;
        }
        return chinese;
    }
}

