/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.chart;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.data.general.PieDataset;

public class IsmPieTooltipLabelGenerator
extends StandardPieToolTipGenerator {
    private static final long serialVersionUID = 2942019921391375357L;

    public IsmPieTooltipLabelGenerator(String unit, int dataPrecision, int percentPrecision) {
        super("{1} " + unit + ",  {2}", (NumberFormat)new DecimalFormat(IsmPieTooltipLabelGenerator.getDoubleFormatString(dataPrecision)), (NumberFormat)new DecimalFormat(IsmPieTooltipLabelGenerator.getPercentFormatString(percentPrecision)));
    }

    public IsmPieTooltipLabelGenerator() {
        super("{2}");
    }

    public String generateToolTip(PieDataset dataset, Comparable key) {
        StringBuffer tip = new StringBuffer(key.toString());
        tip.append(":  (").append(super.generateToolTip(dataset, key)).append(')');
        return tip.toString();
    }

    private static String getPercentFormatString(int percentPrecision) {
        if (1 > percentPrecision) {
            return "0%";
        }
        StringBuffer sb = new StringBuffer("0.");
        for (int i = 0; i < percentPrecision; ++i) {
            sb.append('0');
        }
        sb.append('%');
        return sb.toString();
    }

    private static String getDoubleFormatString(int percentPrecision) {
        if (1 > percentPrecision) {
            return "###,###,###,###,##0";
        }
        StringBuffer sb = new StringBuffer("###,###,###,###,##0.");
        for (int i = 0; i < percentPrecision; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }
}

