/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.control;

import com.huawei.ism.ui.swing.border.RoundCornerBorder;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FlexPane
extends JPanel {
    private static final long serialVersionUID = -3368334320350596949L;
    private JLabel titleBar;
    private JPanel contentPane = new JPanel();
    private boolean expanded;

    public FlexPane(String name, Component contentPane, boolean enableBorder) {
        this.doLayoutUI(name);
        if (enableBorder) {
            this.setBorder(new RoundCornerBorder(new Color(13817045), 7, 10, 7, 10));
        }
        if (null != contentPane) {
            this.addContentPane(contentPane);
        }
        this.collapse();
    }

    private void doLayoutUI(String name) {
        this.contentPane.setLayout(new BorderLayout());
        this.createTitleBar(name);
        Box titleBox = Box.createHorizontalBox();
        titleBox.add(this.titleBar);
        titleBox.add(Box.createHorizontalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)titleBox, "North");
        this.add((Component)this.contentPane, "Center");
    }

    private void createTitleBar(String name) {
        this.titleBar = new JLabel();
        this.titleBar.setFocusable(false);
        this.titleBar.setText(name);
        this.titleBar.setFont(IsmFontFactory.getDialogBold13());
        this.titleBar.addMouseListener(new Handler());
    }

    protected void doAfterClickTask() {
    }

    protected boolean doFrontClickTask() {
        return true;
    }

    public void setBarTitle(String title) {
        this.titleBar.setText(title);
    }

    public void addContentPane(Component contentPanel) {
        this.contentPane.add(contentPanel, "Center");
        this.revalidate();
    }

    public boolean hasExpanded() {
        return this.expanded;
    }

    public void collapse() {
        Border border = this.getBorder();
        if (null != border) {
            this.titleBar.setIcon(UIManager.getIcon("FlexPane.UpNormal"));
        } else {
            this.titleBar.setIcon(UIManager.getIcon("FlexPane.RightNormal"));
        }
        this.defaultCollapse();
    }

    public void expand() {
        this.titleBar.setIcon(UIManager.getIcon("FlexPane.DownNormal"));
        this.defaultExpand();
    }

    private void defaultExpand() {
        this.expanded = true;
        this.contentPane.setVisible(true);
        this.revalidate();
    }

    private void defaultCollapse() {
        this.expanded = false;
        this.contentPane.setVisible(false);
        this.revalidate();
    }

    public JLabel getTitleBar() {
        return this.titleBar;
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    @Override
    public String getName() {
        return this.titleBar.getText();
    }

    private static final class Handler
    extends MouseAdapter {
        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JLabel label = (JLabel)mouseEvent.getSource();
            FlexPane group = (FlexPane)SwingUtilities.getAncestorOfClass(FlexPane.class, label);
            boolean goOn = group.doFrontClickTask();
            if (!goOn) {
                return;
            }
            if (group.hasExpanded()) {
                group.defaultCollapse();
                this.setOrientIcon(label, group);
            } else {
                group.defaultExpand();
                label.setIcon(UIManager.getIcon("FlexPane.DownRollover"));
            }
            group.doAfterClickTask();
        }

        private void setOrientIcon(JLabel label, FlexPane group) {
            Border border = group.getBorder();
            if (null != border) {
                label.setIcon(UIManager.getIcon("FlexPane.UpRollover"));
            } else {
                label.setIcon(UIManager.getIcon("FlexPane.RightRollover"));
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JLabel label = (JLabel)mouseEvent.getSource();
            FlexPane group = (FlexPane)SwingUtilities.getAncestorOfClass(FlexPane.class, label);
            label.setForeground(UIManager.getColor("IsmOEMTheme.renderColor"));
            if (group.hasExpanded()) {
                label.setIcon(UIManager.getIcon("FlexPane.DownRollover"));
            } else {
                this.setOrientIcon(label, group);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JLabel label = (JLabel)mouseEvent.getSource();
            FlexPane group = (FlexPane)SwingUtilities.getAncestorOfClass(FlexPane.class, label);
            label.setForeground(UIManager.getColor("Label.foreground"));
            if (group.hasExpanded()) {
                label.setIcon(UIManager.getIcon("FlexPane.DownNormal"));
            } else {
                Border border = group.getBorder();
                if (null != border) {
                    label.setIcon(UIManager.getIcon("FlexPane.UpNormal"));
                } else {
                    label.setIcon(UIManager.getIcon("FlexPane.RightNormal"));
                }
            }
        }
    }
}

