/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.dialog.RegisterDialog;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

@Deprecated
public abstract class CommonDialog
extends RegisterDialog
implements DialogsConstants {
    public static final Insets INSETS = new Insets(12, 12, 12, 12);
    private static final long serialVersionUID = 1L;
    private static final int GRIDX_0 = 0;
    private static final int GRIDY_0 = 0;
    private static final int BUTTON_HIGHT = 21;
    private static final int BUTTON_WIDTH = 80;
    private static final char HELP_MNEMONIC = 'H';
    private static final double WEIGHTX_1 = 0.1;
    private static final double WEIGHTY_1 = 0.1;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton confirmButton;
    private JButton helpButton;
    private JPanel wholePanel;
    private Insets emptyInsets = INSETS;
    private Box buttonPanelHorizontalBox;
    private Component componentSameMargin1;
    private Component componentSameMargin2;
    private Component componentDifferentMargin;
    private List<IsmTextField> needValidateTextField = new ArrayList<IsmTextField>(0);

    public CommonDialog(JDialog parentDialog) {
        this(parentDialog, true);
    }

    public CommonDialog(Window parentDialog) {
        this(parentDialog, true);
    }

    public CommonDialog(Window parentDialog, boolean closeWithESC) {
        super(parentDialog);
        this.doInit(closeWithESC);
    }

    public CommonDialog(JDialog parentDialog, boolean closeWithESC) {
        super(parentDialog);
        this.doInit(closeWithESC);
    }

    public CommonDialog(Frame parentFrame) {
        super(parentFrame);
        this.setName("ISMV1R2_framework_uiComponent_CommonDialog");
        this.toFront();
        this.initComponents();
        this.defaultButtonText();
        this.setDefaultButton();
        SwingUtil.putScreenCenter(this);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.setFocusCycleRoot(true);
    }

    private void doInit(boolean closeWithESC) {
        this.setName("ISMV1R2_framework_uiComponent_CommonDialog");
        this.toFront();
        this.initComponents();
        this.defaultButtonText();
        this.setDefaultButton();
        this.setFocusCycleRoot(true);
        SwingUtil.putScreenCenter(this);
        SwingUtil.setName(this);
        if (closeWithESC) {
            SwingUtil.setCloseWhenEscKeyPressed(this);
        }
    }

    protected void blockConfirmAndAppBtn() {
        this.setConfirmButtonVisible(false);
        this.setApplyButtonVisible(false);
        this.cancelButton.setText(ResourceManager.getString("READONLY_PROPERTY_DIALOG_CLOSE"));
        this.cancelButton.setMnemonic(76);
        UCD.formatMnemonicDisplay(this.cancelButton);
    }

    @Override
    public void setVisible(boolean visible) {
        if (Utils.isJunitTest()) {
            super.setVisible(false);
            return;
        }
        super.setVisible(visible);
    }

    protected void setDefaultButton() {
        boolean confirmButtonVisible = this.confirmButton.isVisible();
        boolean cancelButtonVisible = this.cancelButton.isVisible();
        if (!confirmButtonVisible && cancelButtonVisible) {
            this.getRootPane().setDefaultButton(this.cancelButton);
            this.cancelButton.requestFocus();
        } else {
            this.getRootPane().setDefaultButton(this.confirmButton);
            this.confirmButton.requestFocus();
        }
    }

    public void defaultButtonText() {
        this.confirmButton.setText(ResourceManager.getString("COMMON_CONFIRM"));
        this.applyButton.setText(ResourceManager.getString("COMMON_APPLY"));
        this.cancelButton.setText(ResourceManager.getString("COMMON_CANNEL"));
        this.helpButton.setText(ResourceManager.getString("COMMON_HELP"));
        this.helpButton.setMnemonic('H');
        this.confirmButton.setMnemonic('O');
        this.applyButton.setMnemonic('A');
        this.cancelButton.setMnemonic('C');
        Dimension dimension = new Dimension(80, 21);
        this.confirmButton.setPreferredSize(dimension);
        this.applyButton.setPreferredSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.helpButton.setPreferredSize(dimension);
        this.confirmButton.setFocusTraversalKeysEnabled(true);
        this.applyButton.setFocusTraversalKeysEnabled(true);
        this.cancelButton.setFocusTraversalKeysEnabled(true);
        this.helpButton.setFocusTraversalKeysEnabled(true);
    }

    public void setApplyButtonText(String text) {
        this.applyButton.setText(text);
    }

    public void setApplyButtonVisible(boolean isApplyButtonVisible) {
        this.applyButton.setVisible(isApplyButtonVisible);
        boolean isExist = false;
        for (Component button : this.buttonPanelHorizontalBox.getComponents()) {
            if (!button.equals(this.applyButton)) continue;
            isExist = true;
        }
        if (!isApplyButtonVisible && isExist) {
            this.buttonPanelHorizontalBox.remove(this.componentSameMargin1);
            this.buttonPanelHorizontalBox.remove(this.applyButton);
            for (ActionListener li : this.applyButton.getActionListeners()) {
                this.applyButton.removeActionListener(li);
            }
        }
    }

    public void setCancelButtonName(String text) {
        this.cancelButton.setName(text);
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public void setCancelButtonMnemonic(int mnemonic) {
        this.cancelButton.setMnemonic(mnemonic);
    }

    public void setCancelButtonVisible(boolean isCancelButtonVisible) {
        this.cancelButton.setVisible(isCancelButtonVisible);
        boolean isExist = false;
        for (Component button : this.buttonPanelHorizontalBox.getComponents()) {
            if (!button.equals(this.cancelButton)) continue;
            isExist = true;
        }
        if (!isCancelButtonVisible && isExist) {
            this.buttonPanelHorizontalBox.remove(this.componentSameMargin2);
            this.buttonPanelHorizontalBox.remove(this.cancelButton);
            for (ActionListener li : this.cancelButton.getActionListeners()) {
                this.cancelButton.removeActionListener(li);
            }
        }
    }

    public void setConfirmButtonText(String text) {
        this.confirmButton.setText(text);
    }

    public void setConfirmButtonVisible(boolean isConfirmButtonVisible) {
        this.confirmButton.setVisible(isConfirmButtonVisible);
        boolean isExist = false;
        for (Component button : this.buttonPanelHorizontalBox.getComponents()) {
            if (!button.equals(this.confirmButton)) continue;
            isExist = true;
        }
        if (!isConfirmButtonVisible && isExist) {
            this.buttonPanelHorizontalBox.remove(this.confirmButton);
            for (ActionListener li : this.confirmButton.getActionListeners()) {
                this.confirmButton.removeActionListener(li);
            }
        }
    }

    public void setHelpButtonName(String text) {
        this.helpButton.setName(text);
    }

    public void setHelpButtonText(String text) {
        this.helpButton.setText(text);
    }

    public void setHelpButtonVisible(boolean isHelpButtonVisible) {
        this.helpButton.setVisible(isHelpButtonVisible);
        boolean isExist = false;
        for (Component button : this.buttonPanelHorizontalBox.getComponents()) {
            if (!button.equals(this.helpButton)) continue;
            isExist = true;
        }
        if (!isHelpButtonVisible && isExist) {
            this.buttonPanelHorizontalBox.remove(this.componentDifferentMargin);
            this.buttonPanelHorizontalBox.remove(this.helpButton);
            for (ActionListener li : this.helpButton.getActionListeners()) {
                this.helpButton.removeActionListener(li);
            }
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        SwingUtil.putScreenCenter(this);
    }

    protected void applyButtonMouseClicked(ActionEvent evt) {
    }

    protected void cancelButtonMouseClicked(ActionEvent evt) {
        this.dispose();
    }

    protected void confirmButtonMouseClicked(ActionEvent evt) {
    }

    protected void helpButtonMouseClicked(ActionEvent evt) {
    }

    protected JPanel getInfoPanel(String message) {
        JPanel inforPanel = new JPanel();
        JLabel imageInforLabel = new JLabel();
        Box imageAndTipBox = Box.createHorizontalBox();
        ImageIcon imageIcon = null;
        try {
            imageIcon = ResourceManager.getImage("Information.png");
        }
        catch (MissingResourceException e) {
            imageIcon = null;
        }
        imageInforLabel.setIcon(imageIcon);
        imageAndTipBox.add(imageInforLabel);
        imageAndTipBox.add(Box.createHorizontalStrut(12));
        IsmTextArea tips = new IsmTextArea(false, true);
        tips.setText(message);
        imageAndTipBox.add(tips);
        imageAndTipBox.add(Box.createHorizontalGlue());
        inforPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        inforPanel.add((Component)imageAndTipBox, gridBagConstraints);
        return inforPanel;
    }

    protected JPanel getInfoPanel(String message, ImageIcon imageIcon) {
        JPanel inforPanel = new JPanel();
        JLabel inforImageLabel = new JLabel();
        Box imageAndTipBox = Box.createHorizontalBox();
        inforImageLabel.setIcon(imageIcon);
        imageAndTipBox.add(inforImageLabel);
        imageAndTipBox.add(Box.createHorizontalStrut(12));
        IsmTextArea tip = new IsmTextArea(false, true);
        tip.setText(message);
        imageAndTipBox.add(tip);
        imageAndTipBox.add(Box.createHorizontalGlue());
        inforPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        inforPanel.add((Component)imageAndTipBox, gridBagConstraints);
        return inforPanel;
    }

    protected void setDisplayPanel(JComponent displayPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.wholePanel.add((Component)displayPanel, gridBagConstraints);
    }

    protected void setDisplayPanel(JComponent displayPanel, String message, ImageIcon imageIcon) {
        JPanel upPanel = new JPanel();
        upPanel.setLayout(new BoxLayout(upPanel, 1));
        upPanel.add(this.getInfoPanel(message, imageIcon));
        upPanel.add(Box.createVerticalStrut(10));
        upPanel.add(displayPanel);
        this.setDisplayPanel(upPanel);
    }

    protected void setDisplayPanel(JComponent displayPanel, String message) {
        JPanel upPanel = new JPanel();
        upPanel.setLayout(new BoxLayout(upPanel, 1));
        upPanel.add(this.getInfoPanel(message));
        upPanel.add(Box.createVerticalStrut(10));
        upPanel.add(displayPanel);
        this.setDisplayPanel(upPanel);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.wholePanel = new JPanel(new GridBagLayout());
        this.wholePanel.setName("ISMV1R2_framework_CommonDialog_wholePanel");
        this.emptyInsets = new Insets(12, 12, 12, 12);
        EmptyBorder emptyBorder = new EmptyBorder(this.emptyInsets);
        this.wholePanel.setBorder(emptyBorder);
        this.setLayout(new BorderLayout());
        this.add((Component)this.wholePanel, "Center");
        this.confirmButton = new JButton();
        this.getRootPane().setDefaultButton(this.confirmButton);
        this.applyButton = new JButton();
        this.applyButton.setName("ISMV1R2_framework_CommonDialog_applyButton");
        this.cancelButton = new JButton();
        this.applyButton.setName("ISMV1R2_framework_CommonDialog_applyButton");
        this.helpButton = new JButton();
        this.cancelButton.setName("ISMV1R2_framework_CommonDialog_cancelButton");
        this.buttonPanelHorizontalBox = Box.createHorizontalBox();
        this.add((Component)this.createButtonPane(), "South");
        this.componentSameMargin1 = Box.createHorizontalStrut(4);
        this.componentSameMargin2 = Box.createHorizontalStrut(4);
        this.componentDifferentMargin = Box.createHorizontalStrut(10);
        this.buttonPanelHorizontalBox.add(Box.createHorizontalGlue());
        this.buttonPanelHorizontalBox.add(this.confirmButton);
        this.buttonPanelHorizontalBox.add(this.componentSameMargin1);
        this.buttonPanelHorizontalBox.add(this.applyButton);
        this.buttonPanelHorizontalBox.add(this.componentSameMargin2);
        this.buttonPanelHorizontalBox.add(this.cancelButton);
        this.buttonPanelHorizontalBox.add(this.componentDifferentMargin);
        this.buttonPanelHorizontalBox.add(this.helpButton);
        this.initButtonActionListener();
        super.setMinimumSize(new Dimension(370, 0));
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
    }

    private void initButtonActionListener() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CommonDialog.this.isValidateInput()) {
                    CommonDialog.this.confirmButtonMouseClicked(actionEvent);
                }
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CommonDialog.this.isValidateInput()) {
                    CommonDialog.this.applyButtonMouseClicked(actionEvent);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonDialog.this.cancelButtonMouseClicked(actionEvent);
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonDialog.this.helpButtonMouseClicked(actionEvent);
            }
        });
    }

    private Box createButtonPane() {
        Box navigationBar = Box.createHorizontalBox();
        navigationBar.add(Box.createRigidArea(new Dimension(12, 20)));
        navigationBar.add(Box.createGlue());
        navigationBar.add(this.buttonPanelHorizontalBox);
        navigationBar.add(Box.createHorizontalStrut(12));
        Box southBox = Box.createVerticalBox();
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new MyArmorJSeparator();
        }
        southBox.add(separator);
        southBox.add(Box.createVerticalStrut(8));
        southBox.add(navigationBar);
        southBox.add(Box.createVerticalStrut(8));
        southBox.setOpaque(true);
        southBox.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(southBox);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            JPanel panel = new JPanel();
            panel.add(Box.createVerticalStrut(4));
            panel.setPreferredSize(new Dimension(panel.getPreferredSize().width, 4));
            panel.setBackground(new Color(0xD9D9D9));
            buttonBox.add(panel);
        }
        return buttonBox;
    }

    public void refresh() {
    }

    @Override
    public void dispose() {
        this.getRootPane().setDefaultButton(null);
        this.helpButton.removeNotify();
        this.confirmButton.removeNotify();
        this.applyButton.removeNotify();
        this.cancelButton.removeNotify();
        this.setVisible(false);
        this.getRootPane().getActionMap().clear();
        this.getRootPane().getInputMap(2).clear();
        super.dispose();
    }

    public Component getComponentSameMargin1() {
        return this.componentSameMargin1;
    }

    public void setComponentSameMargin1(Component sameMargin1) {
        this.componentSameMargin1 = sameMargin1;
    }

    public Component getComponentSameMargin2() {
        return this.componentSameMargin2;
    }

    public void setComponentSameMargin2(Component sameMargin2) {
        this.componentSameMargin2 = sameMargin2;
    }

    public Component getComponentDifferentMargin() {
        return this.componentDifferentMargin;
    }

    public void setComponentDifferentMargin(Component differentMargin) {
        this.componentDifferentMargin = differentMargin;
    }

    public void addNeedValidateTextField(IsmTextField textFiled) {
        this.needValidateTextField.add(textFiled);
    }

    protected boolean isValidateInput() {
        if (this.isNeedValidateInput()) {
            return SwingUtil.validateInput(this.needValidateTextField, this);
        }
        return true;
    }

    protected boolean isNeedValidateInput() {
        return true;
    }

    public List<IsmTextField> getNeedValidateTextField() {
        return this.needValidateTextField;
    }

    public Box getButtonPanelHorizontalBox() {
        return this.buttonPanelHorizontalBox;
    }

    public void setApplyButton(JButton applyButton) {
        this.applyButton = applyButton;
    }

    public JButton getApplyButton() {
        return this.applyButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setConfirmButton(JButton confirmButton) {
        this.confirmButton = confirmButton;
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    public void setHelpButton(JButton helpButton) {
        this.helpButton = helpButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public void setEmptyInsets(Insets emptyInsets) {
        this.emptyInsets = emptyInsets;
    }

    public Insets getEmptyInsets() {
        return this.emptyInsets;
    }

    private static final class MyArmorJSeparator
    extends JSeparator {
        private static final long serialVersionUID = -6149201948604054011L;

        private MyArmorJSeparator() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(0xCECECE));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }
    }
}

