/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldConfirmDialog
extends JDialog
implements DialogsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldConfirmDialog.class);
    private static final int FIELD_LENGTH = 4;
    private static final int GRIDX_0 = 0;
    private static final int GRIDY_0 = 0;
    private static final int GRIDY_1 = 1;
    private static String inputConfirmValue = "yes";
    private static final int INSETS_EMPTY = 0;
    private static final int MAX_CONTENT_LENGTH = 3;
    private static final long serialVersionUID = 3007169049914687651L;
    private static final double WEIGHTX_1 = 0.1;
    private static final double WEIGHTY_1 = 0.1;
    private static int displayPromptDefaultColumn = 25;
    private JPanel buttonPanel;
    private JButton cannelButton;
    private JButton confirmButton;
    private JPanel displayPanel;
    private IsmTextArea displayPrompt;
    private JLabel imageLabel;
    private IsmTextField inputTextField;
    private JPanel promptDisplayPanel;
    private JLabel promptLabel;
    private int value = -1;
    private JPanel wholePanel;

    public OldConfirmDialog(JDialog parent, String title, String newMessage) {
        this(parent, title, newMessage, "warn");
    }

    public OldConfirmDialog(JDialog parent, String title, String newMessage, String newImageIcon) {
        super((Dialog)parent, true);
        this.setName("ISMV1R2_platform_dialogs_RequireInputConfirmationDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        this.confirmButton.setMnemonic('O');
    }

    public OldConfirmDialog(Frame parent, String title, String newMessage) {
        this(parent, title, newMessage, "warn");
    }

    public OldConfirmDialog(Frame parent, String title, String newMessage, String newImageIcon) {
        super(parent, true);
        this.setName("ISMV1R2_platform_dialogs_RequireInputConfirmationDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        this.confirmButton.setMnemonic('O');
    }

    public OldConfirmDialog(JDialog parent, String newMessage) {
        this(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), newMessage, "warning.png");
    }

    public OldConfirmDialog(Frame parent, String newMessage) {
        this(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), newMessage, "warning.png");
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (Utils.isJunitTest()) {
            this.value = value;
        }
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.inputTextField.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }

    private void cannelButtonAction(ActionEvent e) {
        this.value = 1;
        this.dispose();
    }

    private void confimButtonAction() {
        if (this.inputTextField.getText().toLowerCase(Locale.ENGLISH).equals(inputConfirmValue)) {
            this.value = 0;
            this.dispose();
        } else {
            this.inputTextField.setBorder(BorderFactory.createEtchedBorder(Color.RED, Color.RED));
        }
    }

    private void init(String title, String newMessage, String newImageIcon) {
        this.cannelButton = new JButton(ResourceManager.getString("REQUIRE_INPUT_CONFIRMATIONCANNEL"));
        this.cannelButton.setName("ISMV1R2_platform_RequireInputConfirmationDialog_cannelButton");
        this.confirmButton = new JButton(ResourceManager.getString("REQUIRE_INPUT_CONFIRMATIONCONFIRM"));
        this.confirmButton.setName("ISMV1R2_platform_RequireInputConfirmationDialog_confirmButton");
        this.displayPanel = new JPanel();
        this.displayPrompt = new IsmTextArea();
        this.displayPrompt.setName("ISMV1R2_platform_RequireInputConfirmationDialog_displayPrompt");
        this.imageLabel = new JLabel();
        this.imageLabel.setName("ISMV1R2_platform_RequireInputConfirmationDialog_imageLabel");
        this.buttonPanel = new JPanel();
        this.inputTextField = IsmTextField.getNameTextField("[a-zA-Z]*", "", 3, 4);
        this.inputTextField.setName("ISMV1R2_platform_RequireInputConfirmationDialog_inputTextField");
        this.promptLabel = new JLabel();
        this.promptLabel.setName("ISMV1R2_platform_RequireInputConfirmationDialog_promptLabel");
        this.wholePanel = new JPanel();
        this.promptDisplayPanel = new JPanel();
        this.initComponent();
        this.initProperty();
        this.initEvent();
        this.initButton();
        super.setTitle(title);
        this.pack();
        this.displayPrompt.setColumns(displayPromptDefaultColumn);
        this.displayPrompt.setWrapStyleWord(true);
        this.displayPrompt.setText(newMessage);
        this.pack();
        if (null != newImageIcon) {
            ImageIcon imageIcon = ResourceManager.getImage(newImageIcon);
            this.imageLabel.setIcon(imageIcon);
        } else {
            LOGGER.info("DangerDialog's newImageIcon is null!");
        }
        this.pack();
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.pack();
        SwingUtil.putScreenCenter(this);
        this.setResizable(false);
    }

    private void initComponent() {
        this.initLayoutPane();
        this.initDisplayPane();
    }

    private void initDisplayPane() {
        this.displayPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.displayPanel.add((Component)this.imageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.displayPanel.add((Component)this.promptDisplayPanel, gridBagConstraints);
        this.promptDisplayPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.promptDisplayPanel.add((Component)this.displayPrompt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.promptDisplayPanel.add((Component)this.promptLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 17;
        this.promptDisplayPanel.add((Component)this.inputTextField, gridBagConstraints);
    }

    private void initLayoutPane() {
        this.setDefaultCloseOperation(2);
        this.wholePanel.setLayout(new GridBagLayout());
        this.add((Component)this.wholePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.wholePanel.add((Component)this.displayPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 12, 0);
        gridBagConstraints.weightx = 0.1;
        this.wholePanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.confirmButton);
        this.buttonPanel.add(Box.createHorizontalStrut(12));
        this.buttonPanel.add(this.cannelButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
    }

    private void initButton() {
        Dimension buttonDefaultSize = new Dimension(80, BUTTON_HTGHT);
        this.cannelButton.setPreferredSize(buttonDefaultSize);
        this.confirmButton.setPreferredSize(buttonDefaultSize);
        this.getRootPane().setDefaultButton(this.confirmButton);
        this.cannelButton.setMnemonic('C');
    }

    private void initEvent() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OldConfirmDialog.this.confimButtonAction();
            }
        });
        this.cannelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OldConfirmDialog.this.cannelButtonAction(actionEvent);
            }
        });
    }

    private void initProperty() {
        this.promptLabel.setText(ResourceManager.getString("REQUIRE_INPUT_CONFIRMATIONPROMPT"));
    }
}

