/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmIconFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalScrollButton;

public class IsmScrollButton
extends MetalScrollButton {
    private static final long serialVersionUID = -5596621024400026060L;

    public IsmScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width + 2, freeStanding);
        this.setBorder(IsmBorders.getButtonBorder(true));
        this.setBorderPainted(true);
    }

    @Override
    public void paint(Graphics graphics) {
        boolean isHorizontal;
        int width = this.getWidth();
        int height = this.getHeight();
        IsmButtonStyle style = (IsmButtonStyle)UIManager.get("ScrollButton.style");
        IsmButtonStyle.ButtonState buttonState = IsmButtonStyle.ButtonState.NORMAL;
        boolean bl = isHorizontal = this.direction == 3 || this.direction == 7;
        if (!this.model.isEnabled()) {
            buttonState = IsmButtonStyle.ButtonState.DISABLED;
        }
        if (!this.model.isPressed() && this.model.isRollover()) {
            buttonState = IsmButtonStyle.ButtonState.ROLLOVER;
        } else if (this.model.isPressed()) {
            buttonState = IsmButtonStyle.ButtonState.PRESSED;
        }
        IsmPlafUtils.drawDualGradient((Component)this, graphics, style.getGradientUL(buttonState), style.getGradientDR(buttonState), new Rectangle(0, 0, width, height), isHorizontal);
        IsmPlafUtils.drawButtonBorder(style, buttonState, graphics, new Rectangle(0, 0, width, height), false);
        Icon icon = null;
        switch (this.getDirection()) {
            case 3: {
                icon = IsmIconFactory.getScrollBarRightArrowIcon();
                break;
            }
            case 7: {
                icon = IsmIconFactory.getScrollBarLeftArrowIcon();
                break;
            }
            case 1: {
                icon = IsmIconFactory.getScrollBarUpArrowIcon();
                break;
            }
            default: {
                icon = IsmIconFactory.getScrollBarDownArrowIcon();
            }
        }
        icon.paintIcon(this, graphics, (width - icon.getIconWidth()) / 2, (height - icon.getIconHeight()) / 2);
    }
}

