/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.table.TableRow;
import java.util.List;

public final class DefaultTableRow<U, K>
implements TableRow<U, K> {
    private U usrObject;
    private K kIdentifier;
    private Object[] rowdatas;

    public DefaultTableRow(int columnCount, U userObject, K identifier) {
        this.rowdatas = columnCount < 0 ? new Object[0] : new Object[columnCount];
        this.usrObject = userObject;
        this.kIdentifier = identifier;
    }

    public DefaultTableRow(int columnCount, K identifier) {
        this(columnCount, null, identifier);
    }

    @Override
    public U getUserObject() {
        return this.usrObject;
    }

    @Override
    public Object getValueAt(int columnIndex) {
        if (columnIndex < this.rowdatas.length) {
            return this.rowdatas[columnIndex];
        }
        return null;
    }

    @Override
    public void setValueAt(int columnIndex, Object aValue) {
        if (columnIndex < this.rowdatas.length) {
            this.rowdatas[columnIndex] = aValue;
        }
    }

    public void setValues(List<?> datas) {
        if (null == datas) {
            return;
        }
        for (int i = 0; i < datas.size(); ++i) {
            this.setValueAt(i, datas.get(i));
        }
    }

    @Override
    public K getIdentifier() {
        return this.kIdentifier;
    }

    @Override
    public int getColumnCount() {
        return this.rowdatas.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TableRow)) {
            return false;
        }
        TableRow that = (TableRow)object;
        K thisID = this.getIdentifier();
        Object thatID = that.getIdentifier();
        if (null == thisID || null == thatID) {
            return super.equals(object);
        }
        return thisID.equals(thatID);
    }

    public int hashCode() {
        if (null == this.kIdentifier) {
            return super.hashCode();
        }
        return this.kIdentifier.hashCode();
    }
}

