/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.tree;

import com.huawei.ism.ui.swing.tree.IsmTreeModel;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.util.SwingUtil;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsmTree
extends JTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmTree.class);
    private static final long serialVersionUID = 5011687623141450214L;

    public IsmTree(IsmTreeModel treeModel) {
        super(treeModel);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.getSelectionModel().setSelectionMode(1);
    }

    public IsmTree(boolean supportMultiTopNode) {
        this(new IsmTreeModel(supportMultiTopNode));
    }

    public void expendsTopNodes() {
        IsmTreeModel model = this.getTreeModel();
        TreePath path = model.getTreePath(model.getRootNode());
        this.expandPath(path);
    }

    public IsmTreeModel getTreeModel() {
        return (IsmTreeModel)this.getModel();
    }

    public IsmTreeNode getSelectionNode() {
        TreePath treePath = this.getSelectionPath();
        if (null == treePath) {
            return null;
        }
        return (IsmTreeNode)treePath.getLastPathComponent();
    }

    public void expandNode(Enumeration<TreePath> expandedNode) {
        if (null == expandedNode) {
            return;
        }
        try {
            TreePath treePath = null;
            while (expandedNode.hasMoreElements()) {
                treePath = expandedNode.nextElement();
                this.expandPath(treePath);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteTreeNode(final IsmTreeNode deletedNode, boolean asyncExecute) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                IsmTreeModel treeModel = IsmTree.this.getTreeModel();
                IsmTreeNode parentNode = deletedNode.getParentNode();
                treeModel.deleteTreeNode(deletedNode);
                if (deletedNode.equals(IsmTree.this.getSelectionNode())) {
                    IsmTree.this.getSelectionModel().setSelectionPath(treeModel.getTreePath(parentNode));
                }
            }
        };
        SwingUtil.runInEventDispatchThread(run, asyncExecute);
    }

    public void addTreeNode(final IsmTreeNode parentNode, final IsmTreeNode childNode, boolean asyncExecute) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                IsmTreeModel treeModel = IsmTree.this.getTreeModel();
                treeModel.addTreeNode(parentNode, childNode);
            }
        };
        SwingUtil.runInEventDispatchThread(run, asyncExecute);
    }

    public void addTreeNode(final IsmTreeNode parentNode, final IsmTreeNode childNode, final int index, boolean asyncExecute) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                IsmTreeModel treeModel = IsmTree.this.getTreeModel();
                treeModel.addTreeNode(parentNode, childNode, index);
            }
        };
        SwingUtil.runInEventDispatchThread(run, asyncExecute);
    }

    public void addTopNode(final IsmTreeNode topNode, boolean asyncExecute) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                IsmTreeModel treeModel = IsmTree.this.getTreeModel();
                treeModel.addTopNode(topNode);
            }
        };
        SwingUtil.runInEventDispatchThread(run, asyncExecute);
    }

    public void modifyTreeNode(IsmTreeNode treeNode) {
        IsmTreeModel treeModel = this.getTreeModel();
        treeModel.reload(treeNode);
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return "";
    }

    @Override
    public JToolTip createToolTip() {
        return new JToolTip();
    }

    public TreePath getTreePath(IsmTreeNode treeNode) {
        Object[] nodes = this.getTreeModel().getPathToRoot(treeNode);
        if (null != nodes && nodes.length > 0) {
            return new TreePath(nodes);
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TreePath path = this.getPathForLocation(event.getX(), event.getY());
        if (null == path) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        String toolTipText = null;
        if (obj instanceof IsmTreeNode) {
            IsmTreeNode treeNode = (IsmTreeNode)obj;
            toolTipText = treeNode.getTooltipText();
            if (null == toolTipText || "".equals(toolTipText)) {
                toolTipText = treeNode.getText();
            }
            if ("".equals(toolTipText)) {
                toolTipText = null;
            }
        }
        return toolTipText;
    }
}

