/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.templets.AbstractTablePropertyPane;
import com.huawei.ism.ui.templets.ArrayListGeter;
import com.huawei.ism.ui.templets.TabPane;
import com.huawei.ism.util.SwingUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;

public abstract class DefaultPropertyPane
extends AbstractTablePropertyPane {
    private static final long serialVersionUID = 1L;
    private JComboBox<?> subDeviceComboBox;
    private boolean hasSubDevice;
    private List<String> deviceIDList = new LinkedList<String>();

    public DefaultPropertyPane(String deviceID, String[] columnNames, int ... visibleColumnIds) {
        this(deviceID, true, columnNames, visibleColumnIds);
    }

    public DefaultPropertyPane(boolean hasSubDevice, List<String> deviceIDList, boolean isSubPaneFixed, String[] columnNames, JComboBox<?> subDeviceComboBox, int ... visibleColumnIds) {
        super(hasSubDevice, deviceIDList, isSubPaneFixed, columnNames, visibleColumnIds);
        this.subDeviceComboBox = subDeviceComboBox;
    }

    public DefaultPropertyPane(boolean hasSubDevice, int ... visibleColumnIds) {
        super(hasSubDevice, new ArrayList<String>(), false, null, visibleColumnIds);
        this.hasSubDevice = hasSubDevice;
    }

    public DefaultPropertyPane(List<String> deviceIDList, String[] columnNames, int ... visibleColumnIds) {
        this(deviceIDList, true, columnNames, visibleColumnIds);
    }

    public DefaultPropertyPane(String deviceID, boolean isSubPaneFixed, String[] columnNames, int ... visibleColumnIds) {
        this(false, Arrays.asList(deviceID), isSubPaneFixed, columnNames, visibleColumnIds);
    }

    public DefaultPropertyPane(List<String> deviceIDList, boolean isSubPaneFixed, String[] columnNames, int ... visibleColumnIds) {
        this(true, deviceIDList, isSubPaneFixed, columnNames, visibleColumnIds);
    }

    public DefaultPropertyPane(boolean hasSubDevice, List<String> deviceIDList, boolean isSubPaneFixed, String[] columnNames, int ... visibleColumnIds) {
        this(hasSubDevice, deviceIDList, isSubPaneFixed, columnNames, new int[0], visibleColumnIds);
    }

    public DefaultPropertyPane(boolean hasSubDevice, List<String> deviceIDList, boolean isSubPaneFixed, String[] columnNames, int[] visibleColumnIdsForever, int ... visibleColumnIds) {
        super(hasSubDevice, deviceIDList, isSubPaneFixed, columnNames, visibleColumnIds);
    }

    public DefaultPropertyPane(ArrayListGeter arrayGetter, boolean isSubPaneFixed, String[] columnNames, int ... visibleColumnIds) {
        this(true, arrayGetter, isSubPaneFixed, columnNames, visibleColumnIds);
    }

    public DefaultPropertyPane(boolean hasSubDevice, ArrayListGeter arrayGetter, boolean isSubPaneFixed, String[] columnNames, int ... visibleColumnIds) {
        this(hasSubDevice, arrayGetter, isSubPaneFixed, columnNames, new int[0], visibleColumnIds);
    }

    public DefaultPropertyPane(boolean hasSubDevice, ArrayListGeter arrayGetter, boolean isSubPaneFixed, String[] columnNames, int[] visibleColumnIdsForever, int ... visibleColumnIds) {
        super(hasSubDevice, arrayGetter, isSubPaneFixed, columnNames, visibleColumnIds);
    }

    public DefaultPropertyPane(ArrayListGeter arrayListGetter, String[] columnNames, int ... visibleColumnIds) {
        this(arrayListGetter, true, columnNames, visibleColumnIds);
    }

    @Override
    public void updateProperty(int updateMode) {
        if (this.hasSubDevice && this.subDeviceComboBox != null) {
            this.subDeviceComboBox.repaint();
        }
        List<TableRow> topRows = this.getTopTableRows();
        this.paintDatas(topRows, updateMode);
    }

    private void paintDatas(final List<TableRow> rows, final int updateMode) {
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                DefaultPropertyPane.this.updateProperty(rows, updateMode, false);
                DefaultPropertyPane.this.updateSubDeviceCombBox();
            }
        });
    }

    public int getArraySize() {
        return this.deviceIDList.size();
    }

    @Override
    protected abstract int getTabCount(TableRow var1);

    @Override
    protected abstract String getTabNameAt(int var1, TableRow var2);

    @Override
    protected abstract TabPane.TabType getTabTypeAt(int var1, TableRow var2);

    protected List<TableRow> getTableRowsAt(int tabIndex, TableRow source) {
        return null;
    }

    @Override
    protected String[] getTableHeaderNamesAt(int tabIndex, TableRow source) {
        return new String[0];
    }

    @Override
    protected int[] getVisbleTableColumnIDsAt(int tabIndex, TableRow source) {
        return new int[0];
    }

    @Override
    public TabPane getTableTabPane(int tabIndex) {
        return new TableTabPane(tabIndex);
    }

    protected List<String> getNewDeviceIDList() {
        return null;
    }

    protected JComponent createCustomPane() {
        return null;
    }

    public class TableTabPane
    extends TabPane {
        private static final long serialVersionUID = 1L;
        private IsmTable table;
        private DefaultTableModel tableModel;

        public TableTabPane(int tabIndex) {
            super(tabIndex);
            this.setBorder(new EmptyBorder(2, 4, 2, 2));
        }

        @Override
        public void setDatas(TableRow source) {
            if (null == this.tableModel) {
                String[] headerNames = DefaultPropertyPane.this.getTableHeaderNamesAt(this.getTabIndex(), source);
                int[] visibleIDs = DefaultPropertyPane.this.getVisbleTableColumnIDsAt(this.getTabIndex(), source);
                this.tableModel = new DefaultTableModel(headerNames, visibleIDs);
                this.table = new IsmTable(this.tableModel);
                TableScrollPane tablePane = new TableScrollPane(this.table, true, true, false);
                this.add((Component)tablePane, "Center");
            }
            this.tableModel.removeAll();
        }
    }
}

