/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.CommonUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertyPaneAction
extends BaseAction<List<Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyPaneAction.class);
    private static final long serialVersionUID = 1L;
    private static final MenuInfo DEFAULT_MENU_INFO = new MenuInfo(false);
    private static int count;
    private boolean integration = false;
    private Map<String, Object> associatedDatas = new HashMap<String, Object>(0);
    private int identifier;
    private String deviceID = null;
    private Window parent = null;
    private Object allPaneData = null;

    public PropertyPaneAction() {
        PropertyPaneAction.countIncrement();
        this.identifier = count;
    }

    private static void countIncrement() {
        ++count;
    }

    public PropertyPaneAction(String deviceID) {
        this.deviceID = deviceID;
        PropertyPaneAction.countIncrement();
        this.identifier = count;
    }

    @Override
    public String getDeviceID() {
        return this.deviceID;
    }

    @Override
    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public abstract void actionPerformed(List<Object> var1);

    public String getReason(List<Object> rowUserObject) {
        String id = this.getDeviceID();
        if (null == id) {
            return null;
        }
        Launcher launcher = LauncherManager.getInstance().getLauncher(id);
        String reason = launcher.checkSystemStatus(id);
        if (null != reason) {
            return reason;
        }
        User.Level currentUserLevel = this.getUserType();
        if (null == currentUserLevel) {
            currentUserLevel = User.Level.Admin;
        }
        if (null != (reason = CommonUtil.checkUserLevel(id, currentUserLevel))) {
            return reason;
        }
        return reason;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PropertyPaneAction)) {
            return false;
        }
        PropertyPaneAction that = (PropertyPaneAction)object;
        return this.identifier == that.identifier;
    }

    @Override
    public int hashCode() {
        return this.identifier;
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        List rowUserObject;
        String reason;
        Object source;
        if (null != actionEvent && null != (source = actionEvent.getSource()) && source instanceof Component) {
            this.parent = SwingUtilities.getWindowAncestor((Component)source);
        }
        if (null != (reason = this.getReason(rowUserObject = (List)this.getUserObject()))) {
            DialogUtils.showErrorDialog(this.getParentWindow(), reason);
            return;
        }
        try {
            this.actionPerformed(rowUserObject);
        }
        catch (Exception ex) {
            LOGGER.error(this.getClass().getSimpleName(), (Throwable)ex);
            DialogUtils.showErrorDialog(this.getParentWindow(), (Throwable)ex);
        }
    }

    public boolean isIntegration() {
        return this.integration;
    }

    public final Window getParentWindow() {
        if (null == this.parent) {
            return Framework.getInstance().getMainFrame();
        }
        return this.parent;
    }

    public void setIntegration(boolean integratio) {
        this.integration = integratio;
    }

    protected MenuInfo getMenuInfo() {
        return DEFAULT_MENU_INFO;
    }

    public final void setAssocitedData(String key, Object associatedData) {
        this.associatedDatas.clear();
        Assert.notNull(key);
        this.associatedDatas.put(key, associatedData);
    }

    protected final TableRow<?, ?> getAssociatedRow() {
        return (TableRow)this.associatedDatas.get("AssotiatedRow");
    }

    public final MenuInfo menuInfoWithDefault() {
        MenuInfo info = this.getMenuInfo();
        if (null == info) {
            return DEFAULT_MENU_INFO;
        }
        return info;
    }

    protected Object getAllPaneData() {
        return this.allPaneData;
    }

    protected void setAllPaneData(Object allPaneData) {
        this.allPaneData = allPaneData;
    }

    public static final class MenuInfo {
        private boolean isValidBool;
        private String subMenuNameStr;
        private String menuGroupNameStr;
        private String menuNameStr;

        public MenuInfo(boolean isValid) {
            this.isValidBool = isValid;
        }

        public MenuInfo(String subMenuName) {
            this(true);
            this.subMenuNameStr = subMenuName;
        }

        public MenuInfo(String subMenuName, String menuGroupName) {
            this(subMenuName);
            this.menuGroupNameStr = menuGroupName;
        }

        public MenuInfo(String subMenuName, String menuGroupName, String menuName) {
            this(subMenuName, menuGroupName);
            this.menuNameStr = menuName;
        }

        public boolean isValid() {
            return this.isValidBool;
        }

        public String getSubMenuName() {
            return this.subMenuNameStr;
        }

        public String getMenuGroupName() {
            return this.menuGroupNameStr;
        }

        public String getMenuName() {
            return this.menuNameStr;
        }
    }
}

