/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.swing.choose.PushPullPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.PushPullCommand;
import com.huawei.ism.ui.templets.TabbedDialog;
import java.util.ArrayList;
import java.util.List;

public abstract class PushPullTabPagePane
extends TabbedDialog.TabPagePane {
    private static final long serialVersionUID = 1492800322033471059L;
    private PushPullPane pushPullPane;
    private List<Command> commands;

    public PushPullTabPagePane() {
    }

    public PushPullTabPagePane(PushPullPane pushPullPane) {
        this.pushPullPane = pushPullPane;
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    protected boolean passPreCheck() {
        this.initCommands();
        return super.passPreCheck();
    }

    private void initCommands() {
        if (this.pushPullPane == null) {
            return;
        }
        this.commands = new ArrayList<Command>(0);
        List<TableRow<?, ?>> srcToDesRows = this.pushPullPane.getSrcToDesTableRows();
        List<TableRow<?, ?>> desToSrcRows = this.pushPullPane.getDesToSrcTableRows();
        for (TableRow<?, ?> srcToDesRow : srcToDesRows) {
            Command srcToDesCommand = this.getSrcToDesCommand(srcToDesRow);
            this.commands.add(srcToDesCommand);
        }
        for (TableRow<?, ?> srcToDesRow : desToSrcRows) {
            Command desToSrcCommand = this.getDesToSrcCommand(srcToDesRow);
            this.commands.add(desToSrcCommand);
        }
    }

    private Command getSrcToDesCommand(TableRow<?, ?> srcToDesRow) {
        PushPullCommand srcToDesCommand = this.createSrcToDesCommandByRow(srcToDesRow);
        srcToDesCommand.setTableRow(srcToDesRow);
        srcToDesCommand.setAnInt(0);
        srcToDesCommand.setPushPullPane(this.pushPullPane);
        return srcToDesCommand;
    }

    private Command getDesToSrcCommand(TableRow<?, ?> srcToDesRow) {
        PushPullCommand desToSrcCommand = this.createDesToSrcCommandByRow(srcToDesRow);
        desToSrcCommand.setTableRow(srcToDesRow);
        desToSrcCommand.setAnInt(1);
        desToSrcCommand.setPushPullPane(this.pushPullPane);
        return desToSrcCommand;
    }

    public void setPushPullPane(PushPullPane value) {
        this.pushPullPane = value;
    }

    public PushPullPane getPushPullPane() {
        return this.pushPullPane;
    }

    protected abstract PushPullCommand createSrcToDesCommandByRow(TableRow<?, ?> var1);

    protected abstract PushPullCommand createDesToSrcCommandByRow(TableRow<?, ?> var1);
}

