/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.control.TitlePane;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;

public abstract class SummaryPropertyPane
extends PropertyPane {
    private static final long serialVersionUID = -8374128533631609173L;
    private String deviceIdentifer;
    private String subDeviceIdentifer;
    private List<AbstractSubSummaryPane> subOverviewPanes = new ArrayList<AbstractSubSummaryPane>(0);

    public SummaryPropertyPane(String deviceID) {
        this.deviceIdentifer = deviceID;
        this.layoutUI();
    }

    public SummaryPropertyPane(String deviceID, String subDeviceID) {
        this.deviceIdentifer = deviceID;
        this.subDeviceIdentifer = subDeviceID;
        this.layoutUI();
    }

    private void layoutUI() {
        this.setLayout(new BorderLayout());
        MyCustJpane contentPane = new MyCustJpane((LayoutManager)new GridBagLayout());
        MyCustScrollPane scrollPane = new MyCustScrollPane(contentPane);
        this.add((Component)scrollPane, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 5, 0);
        int count = this.getRows();
        LayoutType layoutType = null;
        JComponent rowPane = null;
        for (int row = 0; row < count; ++row) {
            layoutType = this.getLayoutTypeBy(row);
            rowPane = null;
            switch (layoutType) {
                case Average: {
                    rowPane = this.layoutAveragePane(row);
                    break;
                }
                case Three_Seven: {
                    rowPane = this.layoutThreeSevenPane(row);
                    break;
                }
                case Full: {
                    rowPane = this.layoutFullPane(row);
                    break;
                }
            }
            if (null == rowPane) continue;
            if (row == count - 1) {
                constraints.gridheight = 0;
                constraints.insets = new Insets(0, 0, 0, 0);
                constraints.weighty = 1.0;
            }
            contentPane.add((Component)rowPane, constraints);
        }
    }

    private JPanel layoutAveragePane(int row) {
        List<AbstractSubSummaryPane> subPanes = this.getSubSummaryPane(row);
        if (subPanes.isEmpty()) {
            throw new IllegalArgumentException("SubSummaryPane's column is not right.");
        }
        JPanel averagePane = new JPanel(new GridLayout(0, subPanes.size() < 2 ? 2 : subPanes.size(), 5, 5));
        averagePane.setOpaque(false);
        HashMap<Integer, AbstractSubSummaryPane> paneMaps = new HashMap<Integer, AbstractSubSummaryPane>(0);
        for (AbstractSubSummaryPane pane : subPanes) {
            paneMaps.put(pane.getOwningColumn(), pane);
        }
        for (int index = 0; index < subPanes.size(); ++index) {
            averagePane.add((Component)paneMaps.get(index));
        }
        this.subOverviewPanes.addAll(subPanes);
        return averagePane;
    }

    private JComponent layoutFullPane(int row) {
        Box fullPane = Box.createHorizontalBox();
        List<AbstractSubSummaryPane> subPanes = this.getSubSummaryPane(row);
        if (subPanes.size() != LayoutType.Full.getPaneCount()) {
            throw new IllegalArgumentException("The sub summary pane amount is not equal 1.");
        }
        AbstractSubSummaryPane subPane = subPanes.iterator().next();
        fullPane.add(subPane);
        this.subOverviewPanes.addAll(subPanes);
        return fullPane;
    }

    private JComponent layoutThreeSevenPane(int row) {
        JPanel threeSevenPane = new JPanel(new GridBagLayout());
        threeSevenPane.setOpaque(false);
        List<AbstractSubSummaryPane> subPanes = this.getSubSummaryPane(row);
        if (subPanes.size() != LayoutType.Three_Seven.getPaneCount()) {
            throw new IllegalArgumentException("The sub summary pane amount is not equal to 2.");
        }
        HashMap<Integer, AbstractSubSummaryPane> paneMaps = new HashMap<Integer, AbstractSubSummaryPane>(0);
        for (AbstractSubSummaryPane pane : subPanes) {
            paneMaps.put(pane.getOwningColumn(), pane);
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.weightx = 0.5;
        constraints.weighty = 0.5;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.anchor = 17;
        constraints.fill = 1;
        threeSevenPane.add((Component)paneMaps.get(0), constraints);
        constraints = new GridBagConstraints();
        constraints.weighty = 0.5;
        constraints.weightx = 0.5;
        constraints.gridwidth = 7;
        constraints.anchor = 17;
        constraints.fill = 1;
        threeSevenPane.add((Component)paneMaps.get(1), constraints);
        this.subOverviewPanes.addAll(subPanes);
        return threeSevenPane;
    }

    @Override
    public String getDeviceID() {
        return this.deviceIdentifer;
    }

    public String getSubArrayID() {
        return this.subDeviceIdentifer;
    }

    @Override
    public void updateProperty(int updateMode) {
        for (AbstractSubSummaryPane subPane : this.subOverviewPanes) {
            subPane.updateProperty();
        }
    }

    protected abstract List<AbstractSubSummaryPane> getSubSummaryPane(int var1);

    protected abstract int getRows();

    protected abstract LayoutType getLayoutTypeBy(int var1);

    public static enum LayoutType {
        Average(2),
        Three_Seven(2),
        Full(1),
        Scale(2);

        private int paneCount;

        private LayoutType(int paneCount) {
            this.paneCount = paneCount;
        }

        public int getPaneCount() {
            return this.paneCount;
        }
    }

    public static abstract class AbstractSubSummaryPane
    extends TitlePane {
        private static final long serialVersionUID = -1L;
        private String devceID;
        private String subArrayIdentifer;

        public AbstractSubSummaryPane(String deviceID, TitlePane.Type type) {
            super(type, "");
            this.devceID = deviceID;
            this.doInint();
        }

        public AbstractSubSummaryPane(String deviceID, String subArrayID, TitlePane.Type type) {
            super(type, "");
            this.devceID = deviceID;
            this.subArrayIdentifer = subArrayID;
            this.doInint();
        }

        private void doInint() {
            JComponent component = this.getContentPane();
            component.setOpaque(false);
            this.addContentPane(component);
            this.setTitle(this.getTitleBarName());
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.blue) {
                this.setBorder(new EtchedBorder());
            }
        }

        protected abstract JComponent getContentPane();

        protected abstract int getOwningColumn();

        protected abstract String getTitleBarName();

        public abstract void updateProperty();

        public String getDeviceID() {
            return this.devceID;
        }

        public String getSubArrayID() {
            return this.subArrayIdentifer;
        }
    }

    private static final class MyCustJpane
    extends JPanel {
        private static final long serialVersionUID = 0L;

        private MyCustJpane(LayoutManager layout) {
            super(layout);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.blue) {
                this.setOpaque(false);
            } else {
                this.setBackground(UIManager.getColor("IsmArmorStyle.BaseColor"));
            }
        }
    }

    private static final class MyCustScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 2750085415443738102L;

        private MyCustScrollPane(Component view) {
            super(view);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.blue) {
                this.setOpaque(false);
                this.setBorder(UCD.createEmptyBorder(8));
            } else {
                this.setBorder(null);
            }
        }
    }
}

