/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.wizard;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.command.AbstractCommand;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandExcutor;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class DefaultFinishedCardView
extends JPanel {
    private static final long serialVersionUID = -2243451799271083446L;
    private Box commandTraceBox = Box.createVerticalBox();
    private JLabel resultDetailsLabel;
    private Map<Integer, CommandResultPane> resultPanes = new HashMap<Integer, CommandResultPane>(0);

    public DefaultFinishedCardView() {
        this.doLayoutUI();
    }

    void addCommands(Command ... commands) {
        Assert.notNullArray(commands);
        final LinkedList<CommandResultPane> resultPaneList = new LinkedList<CommandResultPane>();
        AbstractCommand abstractCommand = null;
        CommandResultPane resultPane = null;
        for (Command command : commands) {
            if (!(command instanceof AbstractCommand)) continue;
            abstractCommand = (AbstractCommand)command;
            resultPane = new CommandResultPane(abstractCommand);
            this.addCommands2(resultPaneList, abstractCommand, resultPane);
        }
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (CommandResultPane resultPane : resultPaneList) {
                    DefaultFinishedCardView.this.commandTraceBox.add(resultPane);
                    DefaultFinishedCardView.this.commandTraceBox.add(Box.createVerticalStrut(8));
                }
                DefaultFinishedCardView.this.commandTraceBox.revalidate();
                DefaultFinishedCardView.this.commandTraceBox.repaint();
            }
        });
    }

    private void addCommands2(List<CommandResultPane> resultPaneList, AbstractCommand abstractCommand, CommandResultPane resultPane) {
        this.resultPanes.put(abstractCommand.getIndex(), resultPane);
        resultPaneList.add(resultPane);
    }

    void update(Command command) {
        if (!(command instanceof AbstractCommand)) {
            return;
        }
        AbstractCommand abstractCommand = (AbstractCommand)command;
        CommandResultPane resultPane = this.resultPanes.get(abstractCommand.getIndex());
        SwingUtil.runInEventDispatchThread(new MyUpdatePaneTask(resultPane));
    }

    private void doLayoutUI() {
        JPanel scrollView = UCD.createTransparentPane(new BorderLayout());
        scrollView.add((Component)this.commandTraceBox, "North");
        scrollView.setBorder(UCD.createEmptyBorder());
        JScrollPane scrollPane = new JScrollPane(scrollView);
        scrollPane.setBorder(null);
        this.resultDetailsLabel = new JLabel(ResourceManager.getString("AbstractCommand.CommandState.EXECUTING"), ResourceManager.getImage("loading_dot.gif"), 0);
        this.resultDetailsLabel.setHorizontalTextPosition(2);
        this.resultDetailsLabel.setFont(IsmFontFactory.getDialogBold13());
        Box resultDetailsBox = UCD.buildHBoxLeft(this.resultDetailsLabel);
        this.setOpaque(false);
        this.setLayout(new BorderLayout(8, 8));
        this.add((Component)resultDetailsBox, "North");
        this.add((Component)scrollPane, "Center");
        this.setBorder(new EmptyBorder(8, 8, 0, 5));
    }

    public void addCustomInfoPane(JPanel customeInfoPane) {
        Assert.notNull(customeInfoPane);
        this.add((Component)customeInfoPane, "South");
        this.revalidate();
    }

    protected void setResultDetailsLabelInfo(String context) {
        this.resultDetailsLabel.setText(context);
        this.resultDetailsLabel.setIcon(null);
    }

    static class CommandResultPane
    extends JPanel {
        private static final long serialVersionUID = -5388262164789403233L;
        private transient Command command;
        private JLabel stateLabel;
        private JLabel commandNameLabel;
        private Box rightDescBox;
        private boolean isFailedValidate;

        public CommandResultPane(Command command) {
            this.command = command;
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.stateLabel = new JLabel();
            Box stateBox = UCD.buildVBoxTop(this.stateLabel);
            this.commandNameLabel = new JLabel(this.command.getDescription());
            this.rightDescBox = Box.createVerticalBox();
            this.rightDescBox.add(UCD.buildHBoxLeft(this.commandNameLabel));
            Box contentBox = UCD.buildHBoxLeft(stateBox, this.rightDescBox);
            this.add((Component)contentBox, "Center");
        }

        void update() {
            CommandExcutor.CommandState commandState = this.command.getCommandState();
            this.stateLabel.setIcon(commandState.getIcon());
            if (null == commandState.getIcon()) {
                this.stateLabel.setText("");
                UCD.setJComponentSize(this.stateLabel, new Dimension(16, 16));
            }
            this.commandNameLabel.setText(this.command.getDescription());
            if (commandState == CommandExcutor.CommandState.FAILED && !this.isFailedValidate) {
                this.isFailedValidate = true;
                JLabel errMsgLabel = new JLabel(ResourceManager.getStringWithColon("FALLS_REASON"));
                IsmTextArea errMsgTextArea = new IsmTextArea(true, true);
                errMsgTextArea.setText(this.command.getResult());
                errMsgTextArea.setBorder(null);
                this.rightDescBox.add(UCD.buildHBoxLeft(5, UCD.buildVBoxTop(errMsgLabel), errMsgTextArea));
            }
            this.revalidate();
            this.repaint();
        }
    }

    private static final class MyUpdatePaneTask
    implements Runnable {
        private final CommandResultPane resultPane;

        private MyUpdatePaneTask(CommandResultPane resultPane) {
            this.resultPane = resultPane;
        }

        @Override
        public void run() {
            this.resultPane.update();
        }
    }
}

