/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.templets.settingpane.SettingsRightPane;
import com.huawei.ism.ui2.perfstat.PerfStatStrategySettingLayout;
import com.huawei.ism.ui2.perfstat.util.DataSourceManager;
import com.huawei.ism.ui2.perfstat.util.PerfStatDataSource;
import com.huawei.ism.ui2.perfstat.util.PerfStatUtil;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.ValueMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PerfStatStrategySettingsPane
extends SettingsRightPane<PerfStatStrategySettingLayout, Object> {
    private static final long serialVersionUID = 1L;
    private String deviceID;
    private String arrayID;
    private ValueMonitor valueMonitor = new ValueMonitor();
    private transient PerfStatDataSource dataSource;

    public PerfStatStrategySettingsPane(String deviceID) {
        super(deviceID);
        this.deviceID = deviceID;
        this.dataSource = DataSourceManager.getDataSource(deviceID);
        if (CommonUtil.isXVEDevice(deviceID)) {
            this.arrayID = deviceID;
        }
    }

    @Override
    protected void addHandler() {
        ((PerfStatStrategySettingLayout)this.getView()).addStatusBtnActionListener(this.createStatusButtonListener());
        ((PerfStatStrategySettingLayout)this.getView()).getDeviceComboBox().addItemListener(this.createDeviceComboBoxListener());
    }

    private ActionListener createStatusButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String reason = CommonUtil.checkUserLevel(PerfStatStrategySettingsPane.this.getDeviceID(), User.Level.Admin);
                if (null != reason) {
                    DialogUtils.showErrorDialog(PerfStatStrategySettingsPane.this.getParentWindow(), reason);
                    return;
                }
                PerfStatStrategySettingsPane.this.statusBtnActionPerformed();
            }
        };
        return listener;
    }

    protected ItemListener createDeviceComboBoxListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PerfStatStrategySettingsPane.this.deviceID = (String)((Pair)((PerfStatStrategySettingLayout)PerfStatStrategySettingsPane.this.getView()).getDeviceComboBox().getSelectedItem()).getKey();
                    PerfStatStrategySettingsPane.this.setDeviceID(PerfStatStrategySettingsPane.this.deviceID);
                    PerfStatStrategySettingsPane.this.initDatas();
                }
            }
        };
        return listener;
    }

    protected void initDatas() throws IsmException {
        Map<Object, Object> strategy = this.getPerfStatStrategyAndSwitchStatus();
        ((PerfStatStrategySettingLayout)this.getView()).setData(strategy, this.getDeviceID());
        PerfStatUtil.disabledComponentByUser(this.getDeviceID(), ((PerfStatStrategySettingLayout)this.getView()).getAllComponent());
    }

    protected Map<Object, Object> getPerfStatStrategyAndSwitchStatus() {
        Map<Object, Object> strategy = null;
        strategy = this.dataSource.syncGetStrategyAndSwitchStatus();
        return strategy;
    }

    @Override
    protected PerfStatStrategySettingLayout createView() {
        return new PerfStatStrategySettingLayout(this.getDeviceID());
    }

    @Override
    protected boolean doInitTask() throws IsmException {
        this.initDeviceNames();
        this.valueMonitor.removeAllCheckpoints();
        this.clearErrors();
        Map<Object, Object> strategy = this.queryStrategySetting();
        ((PerfStatStrategySettingLayout)this.getView()).setData(strategy, this.deviceID);
        PerfStatStrategySettingLayout layout = (PerfStatStrategySettingLayout)this.getView();
        this.valueMonitor.addCheckpoint(layout.getAutoStopDaysTextField());
        this.valueMonitor.addCheckpoint(layout.getArchiveDataCheckBox());
        PerfStatUtil.disabledComponentByUser(this.getDeviceID(), ((PerfStatStrategySettingLayout)this.getView()).getAllComponent());
        return true;
    }

    private void initDeviceNames() {
        boolean isOnlyOneDevice = CommonUtil.getLauncher(this.deviceID).getSubDeviceIDs().isEmpty();
        PerfStatStrategySettingLayout layout = (PerfStatStrategySettingLayout)this.getView();
        if (isOnlyOneDevice) {
            layout.getDeviceValueLabel().setText(CommonUtil.getDeviceName(this.deviceID));
        } else {
            layout.getDeviceComboBox().removeAllItems();
            Pair<String, String> arrayPair = new Pair<String, String>(this.arrayID, CommonUtil.getDeviceName(this.arrayID));
            layout.getDeviceComboBox().addItem(arrayPair);
            Launcher launcher = CommonUtil.getLauncher(this.arrayID);
            Pair<String, String> subDevicePair = null;
            for (String dID : launcher.getSubDeviceIDs()) {
                subDevicePair = new Pair<String, String>(dID, CommonUtil.getDeviceName(dID));
                layout.getDeviceComboBox().addItem(subDevicePair);
            }
        }
    }

    @Override
    protected Object createMemo() {
        return null;
    }

    @Override
    protected void doResumeTask(Object memo) {
    }

    @Override
    protected boolean isChanged() {
        return this.valueMonitor.isValueChanged();
    }

    @Override
    protected String getDescription() {
        return ResourceManager.getString("perfstat.strategySettings.desc");
    }

    @Override
    protected String getItemTitle() {
        return ResourceManager.getString("PLATFORM_PARAMS_SETTINGS");
    }

    protected Map<Object, Object> queryStrategySetting() {
        Map<Object, Object> strategy = this.dataSource.getStrategyAndSwitchStatus();
        return strategy;
    }

    protected void statusBtnActionPerformed() {
        if (((PerfStatStrategySettingLayout)this.getView()).isStartBtn()) {
            if (!this.isValidInput()) {
                return;
            }
            try {
                Map<Object, Object> strategyAndSwitchStatus = ((PerfStatStrategySettingLayout)this.getView()).getUISetting();
                strategyAndSwitchStatus.put("isPerformanceSwitchOn", 1L);
                Map<Object, Object> strategy = this.setStatisticStrategyAndSwitchStatus(strategyAndSwitchStatus);
                if (strategy != null) {
                    ((PerfStatStrategySettingLayout)this.getView()).setData(strategy, this.deviceID);
                    this.valueMonitor.flushValue();
                    DialogUtils.showInfoDialog(this.getParentWindow());
                }
            }
            catch (Exception e) {
                DialogUtils.showErrorDialog(this.getParentWindow(), (Throwable)e);
            }
        } else {
            try {
                HashMap<Object, Object> switchStatus = new HashMap<Object, Object>(0);
                switchStatus.put("isPerformanceSwitchOn", 0L);
                Map<Object, Object> strategy = this.dataSource.setSwitchStatus(switchStatus);
                if (strategy != null) {
                    ((PerfStatStrategySettingLayout)this.getView()).setData(strategy, this.getDeviceID());
                    this.valueMonitor.flushValue();
                    DialogUtils.showInfoDialog(this.getParentWindow());
                }
            }
            catch (Exception e) {
                DialogUtils.showErrorDialog(this.getParentWindow(), (Throwable)e);
            }
        }
    }

    protected Map<Object, Object> setStatisticStrategyAndSwitchStatus(Map<Object, Object> strategyAndSwitchStatus) {
        Map<Object, Object> strategy = this.dataSource.setStatisticStrategyAndSwitchStatus(strategyAndSwitchStatus);
        return strategy;
    }

    protected boolean isValidInput() {
        this.clearErrors();
        ArrayList<IsmTextField> needValidateFields = new ArrayList<IsmTextField>(0);
        needValidateFields.add(((PerfStatStrategySettingLayout)this.getView()).getSamplingIntervalTextField());
        needValidateFields.add(((PerfStatStrategySettingLayout)this.getView()).getStatDaysTextField());
        boolean isValid = SwingUtil.validateInput(needValidateFields);
        if (!isValid) {
            return false;
        }
        int days = ((PerfStatStrategySettingLayout)this.getView()).getStopDays();
        if (days <= 0) {
            String errorInfo = ResourceManager.getString("INPUT_DAYS_NULL");
            if (((PerfStatStrategySettingLayout)this.getView()).isSplitInterval(this.getDeviceID())) {
                ((PerfStatStrategySettingLayout)this.getView()).getAutoStopDaysTextField().setErrorToolTip(errorInfo);
            } else {
                ((PerfStatStrategySettingLayout)this.getView()).getStatDaysTextField().setErrorToolTip(errorInfo);
            }
            return false;
        }
        return true;
    }

    private void clearErrors() {
        if (((PerfStatStrategySettingLayout)this.getView()).isSplitInterval(this.getDeviceID())) {
            ((PerfStatStrategySettingLayout)this.getView()).getAutoStopDaysTextField().setError(false);
        } else {
            ((PerfStatStrategySettingLayout)this.getView()).getSamplingIntervalTextField().setError(false);
            ((PerfStatStrategySettingLayout)this.getView()).getStatDaysTextField().setError(false);
        }
    }

    @Override
    protected String getHelpKey() {
        return "performance_config";
    }

    public String getDeviceIDFor() {
        return this.deviceID;
    }

    public void setDeviceIDFor(String deviceId) {
        this.deviceID = deviceId;
    }
}

