/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PerfStatFile {
    private final String file;
    private final long lastModifyTime;
    private final long size;

    public PerfStatFile(String fileValue, long lastModifyTimeValue, long sizeValue) {
        this.file = fileValue;
        this.lastModifyTime = lastModifyTimeValue;
        this.size = sizeValue;
    }

    public String getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.file.substring(this.file.lastIndexOf("/") + 1);
    }

    public Date getLastModifyTime() {
        return new Date(this.lastModifyTime * 1000L);
    }

    public long getSize() {
        return this.size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.lastModifyTime ^ this.lastModifyTime >>> 32);
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PerfStatFile other = (PerfStatFile)obj;
        return this.getFile().equals(other.getFile());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("file", (Object)this.file).append("lastModifyTime", this.lastModifyTime).append("size", this.size).toString();
    }
}

