/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.util.Utils;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public final class Lexer {
    private Lexer() {
    }

    public static List<String> parse(String content, int width, FontMetrics fm) {
        String[] lines;
        ArrayList<String> words = new ArrayList<String>(0);
        if (null == content || content.length() <= 0) {
            return words;
        }
        String wrapSymbol = "\\b";
        for (String line : lines = content.split(wrapSymbol)) {
            words.addAll(Lexer.parseNonASCIIWords(line, width, fm));
        }
        return words;
    }

    private static List<String> parseNonASCIIWords(String line, int width, FontMetrics fm) {
        ArrayList<String> words = new ArrayList<String>(0);
        int j = 0;
        for (int i = 0; i < line.length(); ++i) {
            if (i - j > 0 && Lexer.isNonASCIILetter(line.charAt(i))) {
                words.addAll(Lexer.parseWord(line.substring(j, i), width, fm));
                j = i;
            }
            if (i != line.length() - 1 || i < j) continue;
            words.addAll(Lexer.parseWord(line.substring(j, i + 1), width, fm));
        }
        return words;
    }

    private static List<String> parseWord(String text, int width, FontMetrics fm) {
        ArrayList<String> words = new ArrayList<String>(0);
        if (Utils.isNullStr(text)) {
            return words;
        }
        String endText = text;
        String iterText = text;
        while (true) {
            if (fm.stringWidth(iterText) > width) {
                iterText = iterText.substring(0, iterText.length() - 1);
                continue;
            }
            words.add(iterText);
            if (fm.stringWidth(iterText = (endText = endText.substring(iterText.length()))) <= width) break;
        }
        words.add(iterText);
        return words;
    }

    private static boolean isNonASCIILetter(char ch) {
        return Character.isLetterOrDigit(ch) && ch > '\u00ff';
    }
}

