/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.bean.DeviceType;
import java.util.HashMap;
import java.util.Map;

public class ProductToolContainer<T, O> {
    private Map<String, Map<T, O>> cache = new HashMap<String, Map<T, O>>(0);

    public void registerTool(String product, T toolName, O toolObj) {
        Map<T, O> toolCache = this.cache.get(product);
        if (toolCache == null) {
            toolCache = new HashMap<T, O>(0);
            this.cache.put(product, toolCache);
        }
        toolCache.put(toolName, toolObj);
    }

    public O getTool(String product, T toolName) {
        O tool = null;
        Map<T, O> toolCache = this.cache.get(product);
        if (toolCache != null) {
            tool = toolCache.get(toolName);
        }
        if (tool == null && (toolCache = this.cache.get(DeviceType.OCEAN_STOR.name())) != null) {
            tool = toolCache.get(toolName);
        }
        return tool;
    }

    public void clear() {
        for (Map<T, O> toolCache : this.cache.values()) {
            toolCache.clear();
        }
        this.cache.clear();
    }
}

