/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.service;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.exttool.entity.Datum;
import com.huawei.ism.tool.exttool.entity.ProductPackage;
import com.huawei.ism.tool.exttool.entity.Tool;
import com.huawei.ism.tool.exttool.entity.Version;
import com.huawei.ism.tool.exttool.util.DatumIniReader;
import com.huawei.ism.tool.exttool.util.ToolEntry;
import com.huawei.ism.tool.framework.platform.common.tool.AbstractTool;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractToolBox;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.register.RegisterUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IRightControlService;
import com.huawei.ism.tool.framework.pubservice.common.ISceneClassifyService;
import com.huawei.ism.tool.framework.pubservice.entity.SupportUserRight;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public final class ToolManager {
    private static final String BG_PROGRESS_NAME = "updatechecker.exe";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ToolManager.class);
    private static final String EN = "en";
    private static final String ZH = "zh";
    private static final String BAK_APPENDIX = ".bak";
    private static final ToolManager INSTANCE = new ToolManager();
    private SupportUserRight supportUserRight;
    private List<Tool> lastTimeTool;
    private List<Tool> allToolsList;

    private ToolManager() {
        this.initSupportUser();
    }

    public static ToolManager getInstance() {
        return INSTANCE;
    }

    private void initSupportUser() {
        IRightControlService rightService = (IRightControlService)PublicServiceManage.getInstance().getService(IRightControlService.class);
        SupportUserRight tempSupportUserRight = SupportUserRight.GUEST;
        try {
            if (null != rightService && null != rightService.getSupportUser() && null != rightService.getSupportUser().getRight()) {
                tempSupportUserRight = rightService.getSupportUser().getRight();
            }
        }
        catch (ToolException e) {
            LOGGER.error("get support user right error .ToolException ");
        }
        this.supportUserRight = tempSupportUserRight;
    }

    public List<Tool> getToolList() {
        File file = this.getToolsFile();
        return this.getAllTools(file);
    }

    public void refreshInToolbox() {
        List<Tool> allTools = this.getToolList();
        for (Tool tool : allTools) {
            if (tool.isBuiltIn()) continue;
            this.removeFromToolbox(tool.getId());
            RegisterUtil.addTool((AbstractTool)this.getEntry(tool));
        }
        this.lastTimeTool = allTools;
    }

    public void refreshInToolbox(Tool tool) {
        if (tool.isBuiltIn()) {
            return;
        }
        List<Tool> allTools = this.getToolList();
        for (Tool t : allTools) {
            if (!t.getId().equals(tool.getId())) continue;
            tool = t;
        }
        this.removeFromToolbox(tool.getId());
        RegisterUtil.addTool((AbstractTool)this.getEntry(tool));
        this.lastTimeTool = allTools;
    }

    public void refreshToolBox() {
        List<Tool> allTools = this.getToolList();
        ArrayList<Tool> addList = new ArrayList<Tool>(allTools);
        ArrayList<Tool> removeList = new ArrayList<Tool>(this.lastTimeTool);
        this.removeAll(removeList, allTools);
        this.removeAll(addList, this.lastTimeTool);
        for (Tool tool : removeList) {
            this.removeOneFromToolbox(tool.getId());
        }
        for (Tool tool : addList) {
            RegisterUtil.addTool((AbstractTool)this.getEntry(tool));
        }
        this.lastTimeTool = allTools;
    }

    private void removeAll(List<Tool> originalList, List<Tool> needDeteleList) {
        ArrayList<Tool> list = new ArrayList<Tool>();
        for (Tool t : needDeteleList) {
            for (Tool tool : originalList) {
                if (!t.getId().equals(tool.getId())) continue;
                list.add(tool);
            }
        }
        originalList.removeAll(list);
    }

    public void removeFromToolbox(String id) {
        AbstractToolBox box = ApplicationContext.getInstance().getToolContainer();
        if (null != box && box.containsTool(id)) {
            box.removeTool(id);
        }
    }

    public void removeOneFromToolbox(String id) {
        AbstractToolBox box = ApplicationContext.getInstance().getToolContainer();
        if (null != box && box.containsTool(id)) {
            box.removeOneTool(id);
        }
    }

    private List<Tool> getAllTools(File file) {
        ISceneClassifyService sceneClassifyService;
        ArrayList<Tool> toolList = new ArrayList<Tool>();
        IRightControlService rightService = (IRightControlService)PublicServiceManage.getInstance().getService(IRightControlService.class);
        boolean isTrial = false;
        boolean isUnactivating = false;
        boolean isFileExist = false;
        try {
            if (null != rightService && null != rightService.getSupportUser()) {
                isTrial = rightService.getSupportUser().isInTrialModel();
                isUnactivating = rightService.getSupportUser().isUnactivated();
                isFileExist = new File(rightService.getTimeRecordFilePath()).exists();
            }
        }
        catch (ToolException e) {
            LOGGER.error("get flag fail.ToolException");
        }
        ArrayList<Boolean> conditionList = new ArrayList<Boolean>();
        conditionList.add(isTrial);
        conditionList.add(isUnactivating);
        conditionList.add(isFileExist);
        if (file.exists()) {
            Object[] files = file.listFiles();
            if (VerifyUtil.isEmpty((Object[])files)) {
                LOGGER.warn("No tool detected.");
                return toolList;
            }
            this.checkEachFile(toolList, rightService, conditionList, (File[])files);
        }
        if (null != (sceneClassifyService = (ISceneClassifyService)PublicServiceManage.getInstance().getService(ISceneClassifyService.class))) {
            sceneClassifyService.batchAddToolField(toolList);
        }
        this.setAllTools(toolList);
        return toolList;
    }

    private void checkEachFile(List<Tool> toolList, IRightControlService rightService, List<Boolean> conditionList, File[] files) {
        for (File ff : files) {
            IniReader cfgReader;
            Tool tool;
            if (ff.getName().endsWith(BAK_APPENDIX)) {
                LOGGER.info("Skip tmp directory: {}", (Object)ff.getName());
                continue;
            }
            String iniPath = ff.getPath() + File.separator + "tool.ini";
            String datumPath = ff.getPath() + File.separator + "default.ini";
            File toolCfg = new File(iniPath);
            File datumCfg = new File(datumPath);
            if (!toolCfg.exists() || null == (tool = this.getToolInfo(cfgReader = new IniReader(toolCfg), true))) continue;
            if (tool.isMultiPro()) {
                tool.setInstalledVersion(this.setToolInstalledVersion(ff, tool));
            }
            if (datumCfg.exists()) {
                this.setDatumInfo(tool, datumPath);
            }
            if (null != rightService) {
                this.addToolToList(toolList, conditionList, tool);
                continue;
            }
            toolList.add(tool);
        }
    }

    private void addToolToList(List<Tool> toolList, List<Boolean> conditionList, Tool tool) {
        if (tool.isAuthority() && tool.getAuthorityMap().get(this.supportUserRight).booleanValue()) {
            toolList.add(tool);
        } else if (!tool.isAuthority()) {
            toolList.add(tool);
        } else if (SupportUserRight.GUEST.getName().equals(this.supportUserRight.getName()) && conditionList.get(0).booleanValue()) {
            toolList.add(tool);
        } else if (conditionList.get(1).booleanValue() && conditionList.get(2).booleanValue()) {
            toolList.add(tool);
        }
    }

    private void setDatumInfo(Tool tool, String datumPath) {
        DatumIniReader cfgReader = new DatumIniReader(new File(datumPath));
        int i = 0;
        String temp = "datum.nameZh_" + i;
        KeyOrderedHashMap datumMapZh = new KeyOrderedHashMap();
        KeyOrderedHashMap datumMapEn = new KeyOrderedHashMap();
        while (!StringUtils.isNULLStr((String)cfgReader.getString(temp))) {
            Datum datum = new Datum();
            datum.setName(cfgReader.getString("datum.nameZh_" + i));
            datum.setNameEn(cfgReader.getString("datum.nameEn_" + i));
            datum.setDesc(cfgReader.getString("datum.descZh_" + i));
            datum.setDescEn(cfgReader.getString("datum.descEn_" + i));
            datum.setLink(cfgReader.getString("datum.link_" + i));
            datum.setLinkEn(cfgReader.getString("datum.linkEn_" + i));
            datumMapZh.put((Object)cfgReader.getString("datum.nameZh_" + i), (Object)datum);
            datumMapEn.put((Object)cfgReader.getString("datum.nameEn_" + i), (Object)datum);
            temp = "datum.nameZh_" + ++i;
        }
        tool.setDatumMapEn((KeyOrderedHashMap<String, Datum>)datumMapEn);
        tool.setDatumMapZh((KeyOrderedHashMap<String, Datum>)datumMapZh);
    }

    private List<String> setToolInstalledVersion(File file, Tool tool) {
        if (null == file || null == tool) {
            return new ArrayList<String>(0);
        }
        File[] files = file.listFiles();
        ArrayList<String> installedVersionList = new ArrayList<String>();
        if (null != files) {
            for (File ff : files) {
                File[] vers;
                if (!ff.isDirectory() || !ff.getName().equals(LanguageManager.getInstance().getCurrentLanguage().getLanguage())) continue;
                for (File f : vers = ff.listFiles()) {
                    installedVersionList.add(f.getName());
                }
            }
        }
        return installedVersionList;
    }

    public File getToolsFile() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        if (this.checkIsBgProgress()) {
            return new File(new File(workPath).getParent() + File.separator + "tools");
        }
        return new File(workPath + File.separator + "tools");
    }

    private boolean checkIsBgProgress() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        return new File(workPath, BG_PROGRESS_NAME).exists();
    }

    private String getToolDescZh(IniReader iniReader) {
        String descSvpZh = iniReader.getString("tool.desc.svp.zh");
        String descLinuxZh = iniReader.getString("tool.desc.linux.zh");
        String descZh = iniReader.getString("tool.desc.zh");
        if (LocalHostUtil.isRunInSvp() && !StringUtils.isNULLStr((String)descSvpZh)) {
            return descSvpZh;
        }
        if (!ApplicationContext.getInstance().isWindowsOS() && !StringUtils.isNULLStr((String)descLinuxZh)) {
            return descLinuxZh;
        }
        return descZh;
    }

    private String getToolDescEn(IniReader iniReader) {
        String descSvpEn = iniReader.getString("tool.desc.svp.en");
        String descLinuxEn = iniReader.getString("tool.desc.linux.en");
        String descEn = iniReader.getString("tool.desc.en");
        if (LocalHostUtil.isRunInSvp() && !StringUtils.isNULLStr((String)descSvpEn)) {
            return descSvpEn;
        }
        if (!ApplicationContext.getInstance().isWindowsOS() && !StringUtils.isNULLStr((String)descLinuxEn)) {
            return descLinuxEn;
        }
        return descEn;
    }

    public Tool getToolInfo(IniReader ir, boolean checkLoc, File file) {
        Tool tool = ToolManager.getInstance().getToolInfo(ir, checkLoc);
        if (!VerifyUtil.isEmpty((Object)tool)) {
            tool.setToolFilePath(FilePathUtils.getCanonicalPath((File)file));
        }
        return tool;
    }

    public Tool getToolInfo(IniReader ir, boolean checkLoc) {
        String toolName = ir.getString("tool.name");
        if (StringUtils.isNULLStr((String)toolName)) {
            return null;
        }
        Tool tool = new Tool();
        this.generateBaseToolInfo(ir, toolName, tool);
        String toolOs = ir.getString("tool.os");
        tool.setToolOs(StringUtils.isNULLStr((String)toolOs) ? "Windows" : toolOs);
        tool.setRunningByBackend(this.getIsRunningByBackend(ir.getString("tool.run.isRunningByBackend")));
        tool.setSceneId(ir.getString("smartkit.tool.sceneId"));
        tool.setFieldId(ir.getString("smartkit.tool.fieldId"));
        tool.setFunctionNameZh(ir.getString("smartkit.tool.functionNameZh"));
        tool.setFunctionNameEn(ir.getString("smartkit.tool.functionNameEn"));
        tool.setRemarkZh(ir.getString("smartkit.tool.remarkZh"));
        tool.setRemarkEn(ir.getString("smartkit.tool.remarkEn"));
        tool.setProductId(ir.getString("smartkit.tool.productId"));
        tool.setCooperateToolName(ir.getString("tool.cooperate.name"));
        tool.setUnzipInnerTar(StringUtils.isNULLStr((String)ir.getString("tool.inner.tar.unzip")) || ir.getBoolean("tool.inner.tar.unzip"));
        if (!StringUtils.isNULLStr((String)ir.getString("toolkit.app.show.scene.tip.zh"))) {
            tool.setShowSceneTipZh(ir.getString("toolkit.app.show.scene.tip.zh"));
        }
        if (!StringUtils.isNULLStr((String)ir.getString("toolkit.app.show.scene.tip.en"))) {
            tool.setShowSceneTipEn(ir.getString("toolkit.app.show.scene.tip.en"));
        }
        if (!StringUtils.isNULLStr((String)ir.getString("tool.support.roles"))) {
            tool.setAuthority(true);
        }
        this.setIP(ir.getString("tool.use.ip.port"), tool);
        tool.setAuthorityMap(this.getAuthorityMap(tool.isAuthority(), ir.getString("tool.support.roles")));
        tool.setPackagePath(this.getParentPath(ir, tool));
        Version ver = new Version();
        ver.setVerNumber(ir.getString("tool.version"));
        ver.setVersionForView(ir.getString("version.for.view"));
        ver.setReleaseDate(this.normalizedTime(ir.getString("date")));
        this.setToolboxVer(ir.getString("toolbox.version"), ir.getString("toolbox.version.date"), ver);
        ver.addVerDesc(Locale.CHINESE, this.getToolDescZh(ir));
        ver.addVerDesc(Locale.ENGLISH, this.getToolDescEn(ir));
        if (checkLoc) {
            tool.setCurVersion(ver);
            tool.setPackageList(this.getPackagesInfo(this.getParentPath(ir, tool), true));
        } else {
            tool.setNewVersion(ver);
        }
        this.setNewVersionForMulti(tool, ver);
        return tool;
    }

    private void generateBaseToolInfo(IniReader ir, String toolName, Tool tool) {
        tool.setId(toolName);
        tool.addName(Locale.CHINESE, ir.getString("tool.title.zh"));
        tool.addName(Locale.ENGLISH, ir.getString("tool.title.en"));
        tool.addDesc(Locale.CHINESE, this.getToolDescZh(ir));
        tool.addDesc(Locale.ENGLISH, this.getToolDescEn(ir));
        tool.addCmd(Locale.CHINESE, ir.getString("tool.run.command.zh"));
        tool.addCmd(Locale.ENGLISH, ir.getString("tool.run.command.en"));
        tool.setImage(ir.getString("tool.icon"));
        tool.setType(Tool.setToolType(ir.getString("tool.type")));
        tool.setBuiltIn("true".equalsIgnoreCase(ir.getString("tool.is.built.in")));
        tool.setTmpDirs(ir.getString("tool.tmp.dirs"));
        tool.setSupportPkgDate(ir.getString("supported.package.date"));
        tool.setPkgBuiltIn(this.setSupportRP(ir.getString("package.is.built.in")));
        tool.setRunFlagIgnore(this.getRunflagIgnore(ir.getString("tool.runflag.ignore")));
        tool.setMultiPro(this.getMultiPro(ir.getString("tool.multi_product")));
        tool.setTrial(this.setTrialBoolean(ir.getString("tool.trial.not.support")));
        tool.addStopCmd(Locale.CHINESE, ir.getString("tool.close.command.zh"));
        tool.addStopCmd(Locale.ENGLISH, ir.getString("tool.close.command.zh"));
        tool.setIntegration(this.setSupportRP(ir.getString("tool.bstool.issupport")));
        tool.setSupportRemote(this.setSupportRP(ir.getString("tool.support.remote.open")));
        tool.setBsOpenUrl(ir.getString("tool.run.url.path"));
        tool.setSupImport(ir.getString("tool.flag"));
        tool.setSupportZhImport(ir.getString("toolkit.app.zh.version"));
        tool.setShowScene(ir.getString("toolkit.app.show.scene"));
        tool.setShowSceneTip(this.setShowTip(ir));
        tool.setShowSceneTipConfirm(this.setShowTipConfirm(ir));
    }

    private boolean setShowTip(IniReader ir) {
        String showSceneTip = ir.getString("toolkit.app.show.scene.tip");
        boolean isShowTip = true;
        if (!StringUtils.isNULLStr((String)showSceneTip)) {
            isShowTip = Boolean.parseBoolean(showSceneTip);
        }
        return isShowTip;
    }

    private boolean setShowTipConfirm(IniReader ir) {
        String showSceneTipConfirmStr = ir.getString("toolkit.app.show.scene.confirm");
        boolean isShowTipConfirm = false;
        if (!StringUtils.isNULLStr((String)showSceneTipConfirmStr)) {
            isShowTipConfirm = Boolean.parseBoolean(showSceneTipConfirmStr);
        }
        return isShowTipConfirm;
    }

    private String getParentPath(IniReader ir, Tool tool) {
        String path = ir.getString("tool.package.path");
        String workPath = ApplicationContext.getInstance().getWorkPath();
        String packagesPath = "packages" + File.separator + tool.getId() + File.separator + "products" + File.separator + path;
        if (this.checkIsBgProgress()) {
            workPath = new File(workPath).getParent();
        }
        if (tool.isPkgBuiltIn()) {
            workPath = workPath + File.separator + "tools" + File.separator + tool.getId();
        }
        return workPath + File.separator + packagesPath;
    }

    private boolean setTrialBoolean(String isTrialStr) {
        boolean isTrialBoolean = true;
        if (!StringUtils.isNULLStr((String)isTrialStr)) {
            isTrialBoolean = !Boolean.parseBoolean(isTrialStr);
        }
        return isTrialBoolean;
    }

    public void getMulVersionToolInfo(IniReader ir, ToolEntry entry) {
        String cmdZh = ir.getString("tool.run.command.zh");
        String cmdEn = ir.getString("tool.run.command.en");
        String stopCmdZh = ir.getString("tool.close.command.zh");
        String stopCmdEn = ir.getString("tool.close.command.zh");
        entry.setCmdLineEn(cmdEn);
        entry.setCmdLineZh(cmdZh);
        entry.setCmdStopEn(stopCmdEn);
        entry.setCmdStopZh(stopCmdZh);
    }

    private String normalizedTime(String date) {
        if (Pattern.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}", date)) {
            return date;
        }
        String[] str = date.split("-");
        if (str.length < 3) {
            return date;
        }
        if (2 != str[1].length()) {
            str[1] = "0" + str[1];
        }
        if (2 != str[2].length()) {
            str[2] = "0" + str[2];
        }
        return str[0] + '-' + str[1] + '-' + str[2];
    }

    private void setToolboxVer(String toolboxVer, String toolboxVerDate, Version ver) {
        if (!StringUtils.isNULLStr((String)toolboxVer) && !StringUtils.isNULLStr((String)toolboxVerDate)) {
            ver.setParentVersion(toolboxVer);
            ver.setParentVersionDate(toolboxVerDate.replaceAll("-", ""));
        }
    }

    private boolean setSupportRP(String supportRPStr) {
        boolean supportRemote = false;
        if (!StringUtils.isNULLStr((String)supportRPStr)) {
            supportRemote = Boolean.parseBoolean(supportRPStr);
        }
        return supportRemote;
    }

    private void setIP(String ipPorts, Tool tool) {
        if (!StringUtils.isNULLStr((String)ipPorts)) {
            for (String ipPort : ipPorts.split(",")) {
                if (StringUtils.isNULLStr((String)ipPort)) continue;
                tool.addIpPorts(ipPort);
            }
        }
    }

    private Map<SupportUserRight, Boolean> getAuthorityMap(boolean isAuthorityBoolean, String authorityList) {
        Map<SupportUserRight, Boolean> map = isAuthorityBoolean ? this.initAuthority(authorityList) : this.initAuthorityMap(true);
        return map;
    }

    private Map<SupportUserRight, Boolean> initAuthority(String authorityList) {
        Map<SupportUserRight, Boolean> map = this.initAuthorityMap(false);
        if (authorityList.equalsIgnoreCase("ALL")) {
            map = this.initAuthorityMap(true);
        } else {
            String[] authorityStr = authorityList.split(",");
            this.setAuthorityValue(map, authorityStr);
        }
        return map;
    }

    private void setAuthorityValue(Map<SupportUserRight, Boolean> map, String[] authorityStr) {
        block0: for (String s : authorityStr) {
            for (SupportUserRight right : SupportUserRight.values()) {
                if (!right.getName().equals(s)) continue;
                SupportUserRight aut = right;
                map.put(aut, true);
                continue block0;
            }
        }
    }

    private Map<SupportUserRight, Boolean> initAuthorityMap(boolean flag) {
        HashMap<SupportUserRight, Boolean> map = new HashMap<SupportUserRight, Boolean>();
        map.put(SupportUserRight.HWENGINEER, flag);
        map.put(SupportUserRight.CHANNEL, flag);
        map.put(SupportUserRight.CUSTOMER, flag);
        map.put(SupportUserRight.GUEST, flag);
        return map;
    }

    private void setNewVersionForMulti(Tool tool, Version ver) {
        if (tool.isMultiPro()) {
            tool.setNewVersion(ver);
        }
    }

    private boolean getRunflagIgnore(String runflagIgnoreStr) {
        if (null == runflagIgnoreStr) {
            return false;
        }
        return Boolean.parseBoolean(runflagIgnoreStr);
    }

    private boolean getIsRunningByBackend(String isRunningByBackend) {
        if (isRunningByBackend == null) {
            return false;
        }
        return Boolean.parseBoolean(isRunningByBackend);
    }

    private boolean getMultiPro(String multiProductStr) {
        if (null == multiProductStr) {
            return false;
        }
        return Boolean.parseBoolean(multiProductStr);
    }

    public List<ProductPackage> getPackagesInfo(String packagePath, boolean checkLoc) {
        List<String> pathList = this.getAllPaths(packagePath);
        ArrayList<ProductPackage> proList = new ArrayList<ProductPackage>();
        for (String path : pathList) {
            ProductPackage pro = this.getPackageInfo(this.getSoftIni(path), checkLoc);
            if (null == pro) continue;
            pro.setRelativePath(packagePath);
            proList.add(pro);
        }
        for (int i = 0; i < proList.size(); ++i) {
            for (int j = i + 1; j < proList.size(); ++j) {
                if (!((ProductPackage)proList.get(i)).getId().equals(((ProductPackage)proList.get(j)).getId())) continue;
                proList.remove(j);
            }
        }
        pathList.clear();
        return proList;
    }

    public ProductPackage getPackageInfo(IniReader ir, boolean checkLoc) {
        if (null == ir) {
            return null;
        }
        String packageName = ir.getString("package.name");
        if (StringUtils.isNULLStr((String)packageName)) {
            return null;
        }
        String descZh = ir.getString("package.desc.zh");
        String descEn = ir.getString("package.desc.en");
        String date = ir.getString("date");
        String verName = ir.getString("package.version");
        String toolVer = ir.getString("tool.version");
        String toolNmae = ir.getString("package.type");
        Version ver = new Version();
        ver.setVerNumber(verName);
        ver.setReleaseDate(date);
        if (!StringUtils.isNULLStr((String)toolVer)) {
            ver.setParentVersion(toolVer);
        }
        ProductPackage pro = new ProductPackage();
        if (checkLoc) {
            pro.setCurVersion(ver);
        } else {
            pro.setNewVersion(ver);
        }
        pro.setParentToolId(toolNmae);
        pro.setId(packageName);
        pro.addName(Locale.CHINESE, packageName);
        pro.addName(Locale.ENGLISH, packageName);
        pro.addDesc(Locale.CHINESE, descZh);
        pro.addDesc(Locale.ENGLISH, descEn);
        return pro;
    }

    private List<String> getAllPaths(String packagePath) {
        ArrayList<String> pathList = new ArrayList<String>();
        File file = new File(packagePath);
        File[] files = file.listFiles();
        if (null == files) {
            return pathList;
        }
        File[] subFiles = null;
        block0: for (File f : files) {
            subFiles = f.listFiles();
            if (null == subFiles) continue;
            for (File sf : subFiles) {
                if (!"package.ini".equals(sf.getName())) continue;
                pathList.add(sf.getPath());
                continue block0;
            }
        }
        return pathList;
    }

    public ToolEntry getMulVersionEntry(Tool tool, String currentSceneVerison) {
        String iniToolPath;
        File toolIni;
        String toolPath = ApplicationContext.getInstance().getExtToolsPath() + File.separator + tool.getId();
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        String localLan = null;
        localLan = Locale.CHINESE.getLanguage().equals(loc.getLanguage()) || Locale.CHINA.getLanguage().equals(loc.getLanguage()) ? ZH : EN;
        String sbFather = ApplicationContext.getInstance().getCurrWorkPath() + toolPath + File.separator + localLan + File.separator + currentSceneVerison;
        File installParentDir = new File(sbFather);
        String detailToolPath = this.getToolPathByParent(installParentDir);
        ToolEntry entry = new ToolEntry(detailToolPath);
        if (null != detailToolPath && (toolIni = new File(iniToolPath = detailToolPath + File.separator + "tool.ini")).exists()) {
            IniReader cfgReader = new IniReader(toolIni);
            this.getMulVersionToolInfo(cfgReader, entry);
        }
        entry.setId(tool.getId());
        entry.setVersion(currentSceneVerison);
        entry.setNameZh(tool.getName(Locale.CHINESE));
        entry.setNameEn(tool.getName(Locale.ENGLISH));
        entry.setDescZh(tool.getDesc(Locale.CHINESE));
        entry.setDescEn(tool.getDesc(Locale.ENGLISH));
        entry.setType(tool.getType());
        entry.setField(tool.getField());
        entry.setMapDatumEn(tool.getDatumMap(Locale.ENGLISH));
        entry.setMapDatumZh(tool.getDatumMap(Locale.CHINESE));
        entry.setIcon(tool.getImage());
        entry.setRunFlagIgnore(tool.isRunFlagIgnore());
        entry.setMultiPro(tool.isMultiPro());
        entry.setIpPorts(tool.getIpPorts());
        entry.setShowScene(tool.getShowScene());
        entry.setShowSceneTipZh(tool.getShowSceneTipZh());
        entry.setShowSceneTipEn(tool.getShowSceneTipEn());
        entry.setShowSceneTip(tool.isShowSceneTip());
        entry.setShowSceneTipConfirm(tool.isShowSceneTipConfirm());
        entry.setLocallan(localLan);
        return entry;
    }

    private String getToolPathByParent(File installParentDir) {
        String resultPath = null;
        if (null == installParentDir) {
            LOGGER.error("getToolPathByParent failed,file is null");
            return resultPath;
        }
        if (!installParentDir.exists()) {
            LOGGER.error("getToolPathByParent failed,path:{}", (Object)FilePathUtils.getCanonicalPath((File)installParentDir));
            return resultPath;
        }
        resultPath = this.getToolIniPath(installParentDir);
        return resultPath;
    }

    private String getToolIniPath(File installParentDir) {
        String result = null;
        File[] files = installParentDir.listFiles();
        if (null != files) {
            for (File file : files) {
                if (!file.isDirectory() && "tool.ini".equals(file.getName())) {
                    result = file.getParent();
                    break;
                }
                if (file.isDirectory() && null != (result = this.getToolIniPath(file))) break;
            }
        }
        return result;
    }

    public ToolEntry getEntry(Tool tool) {
        String toolPath = ApplicationContext.getInstance().getExtToolsPath() + File.separator + tool.getId();
        ToolEntry entry = new ToolEntry(toolPath);
        entry.setId(tool.getId());
        Version curVer = tool.getCurVersion();
        Version newVer = tool.getNewVersion();
        if (null != newVer) {
            entry.setVersion(newVer.getVerNumber());
            entry.setReleaseDate(newVer.getReleaseDate());
        } else {
            entry.setVersion(curVer.getVerNumber());
            entry.setReleaseDate(curVer.getReleaseDate());
        }
        entry.setNameZh(tool.getName(Locale.CHINESE));
        entry.setNameEn(tool.getName(Locale.ENGLISH));
        entry.setDescZh(tool.getDesc(Locale.CHINESE));
        entry.setDescEn(tool.getDesc(Locale.ENGLISH));
        entry.setCmdLineZh(tool.getCmd(Locale.CHINESE));
        entry.setCmdLineEn(tool.getCmd(Locale.ENGLISH));
        entry.setType(tool.getType());
        entry.setField(tool.getField());
        entry.setMapDatumEn(tool.getDatumMap(Locale.ENGLISH));
        entry.setMapDatumZh(tool.getDatumMap(Locale.CHINESE));
        entry.setIcon(tool.getImage());
        entry.setRunFlagIgnore(tool.isRunFlagIgnore());
        entry.setMultiPro(tool.isMultiPro());
        entry.setCmdStopEn(tool.getStopCmd(Locale.ENGLISH));
        entry.setCmdStopZh(tool.getStopCmd(Locale.CHINESE));
        entry.setIpPorts(tool.getIpPorts());
        entry.setShowScene(tool.getShowScene());
        entry.setShowSceneTipZh(tool.getShowSceneTipZh());
        entry.setShowSceneTipEn(tool.getShowSceneTipEn());
        entry.setShowSceneTip(tool.isShowSceneTip());
        entry.setShowSceneTipConfirm(tool.isShowSceneTipConfirm());
        return entry;
    }

    public IniReader getSoftIni(String iniPath) {
        File toolFile = new File(iniPath);
        IniReader ir = null;
        if (toolFile.exists()) {
            ir = new IniReader(toolFile);
        }
        return ir;
    }

    public List<Tool> getAllTools() {
        if (null == this.allToolsList) {
            this.allToolsList = new ArrayList<Tool>(20);
        }
        return this.allToolsList;
    }

    public void setAllTools(List<Tool> allTools) {
        this.allToolsList = allTools;
    }

    public SupportUserRight getSupportUserRight() {
        return this.supportUserRight;
    }

    public void setSupportUserRight(SupportUserRight supportUserRight) {
        this.supportUserRight = supportUserRight;
    }
}

