/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.ui;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class SceneJumpDialog
extends JDialog {
    private static final long serialVersionUID = -848624002800927072L;
    private static final int DISPLAY_PROMPT_DEFAULT_COLUMN = 26;
    private static final int GRID_X_0 = 0;
    private static final int GRID_Y_0 = 0;
    private static final int INSETS_EMPTY = 0;
    private static final double WEIGHT_X_1 = 0.1;
    private static final double WEIGHT_Y_1 = 0.1;
    private int dialogValue = -1;
    private JPanel dispPanel;
    private JLabel image;
    private JButton confirmBut = UiMethod.createButton(ResourceUtil.getString("tool.jump.scene.confirm"), 'O');
    private JButton continueBut = UiMethod.createButton(ResourceUtil.getString("tool.jump.scene.continue"), 'C');
    private Box buttonPanel;
    private IsmTextArea display;
    private JPanel maininfoPanel;
    private String desc;

    public SceneJumpDialog(Window parent, String description) {
        super(parent);
        this.desc = description;
        this.setUndecorated(true);
        this.setModal(true);
        this.setResizable(false);
        this.initUI();
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initUI() {
        this.toFront();
        this.dispPanel = new JPanel();
        this.image = new JLabel();
        this.display = new IsmTextArea();
        this.display.setEditable(false);
        this.display.setColumns(26);
        this.maininfoPanel = new JPanel();
        this.initComponent();
        this.initListen();
        super.setTitle(ResourceUtil.getString("tool.jump.scene.title"));
        ImageIcon imageIcon = ResourceManager.getImage((String)"Information.png");
        this.image.setIcon(imageIcon);
        this.pack();
        this.display.setText(this.desc);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.putParentCenter((Window)this, (Window)this.getOwner());
        SwingUtil.setName((Container)this);
    }

    protected void initComponent() {
        int margin = 8;
        this.setDefaultCloseOperation(2);
        this.maininfoPanel.setLayout(new GridBagLayout());
        this.add((Component)this.maininfoPanel, "Center");
        this.setDisplayPanel();
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new ArmorSeparator();
        }
        GridBagConstraints gridBagConstraint = new GridBagConstraints();
        gridBagConstraint.gridx = 0;
        gridBagConstraint.gridy = 2;
        gridBagConstraint.anchor = 15;
        gridBagConstraint.fill = 2;
        gridBagConstraint.insets = new Insets(10, 0, 0, 0);
        gridBagConstraint.weightx = 0.1;
        Box innerBox = Box.createVerticalBox();
        innerBox.add(separator);
        JComponent boxStruts = (JComponent)Box.createVerticalStrut(margin);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            boxStruts.setOpaque(true);
            boxStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        innerBox.add(boxStruts);
        this.maininfoPanel.add((Component)innerBox, gridBagConstraint);
        this.setButtonPanel();
        this.dispPanel.setLayout(new GridBagLayout());
        gridBagConstraint = new GridBagConstraints();
        gridBagConstraint.gridx = 0;
        gridBagConstraint.gridy = 0;
        gridBagConstraint.anchor = 10;
        gridBagConstraint.insets = new Insets(0, 3, 12, 0);
        this.dispPanel.add((Component)this.image, gridBagConstraint);
        this.display.setBorder(UCD.createEmptyBorder());
        gridBagConstraint = new GridBagConstraints();
        gridBagConstraint.gridx = 1;
        gridBagConstraint.gridy = 0;
        gridBagConstraint.anchor = 10;
        gridBagConstraint.insets = new Insets(0, 3, 12, 0);
        this.dispPanel.add((Component)this.display, gridBagConstraint);
        this.display.setMargin(new Insets(0, 0, 0, 0));
    }

    private void setDisplayPanel() {
        GridBagConstraints gridBagConstraint = new GridBagConstraints();
        gridBagConstraint.gridx = 0;
        gridBagConstraint.gridy = 0;
        gridBagConstraint.fill = 1;
        gridBagConstraint.insets = new Insets(12, 9, 0, 12);
        gridBagConstraint.weightx = 0.1;
        gridBagConstraint.weighty = 0.1;
        this.maininfoPanel.add((Component)this.dispPanel, gridBagConstraint);
    }

    private void setButtonPanel() {
        GridBagConstraints gridBagConstraint = new GridBagConstraints();
        gridBagConstraint.gridx = 0;
        gridBagConstraint.gridy = 3;
        gridBagConstraint.anchor = 11;
        gridBagConstraint.fill = 2;
        gridBagConstraint.insets = new Insets(0, 0, 0, 0);
        gridBagConstraint.weightx = 0.1;
        this.buttonPanel = UCD.buildHBoxCentert((Component[])new Component[]{this.confirmBut, this.continueBut});
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        JComponent bottomStruts = (JComponent)Box.createVerticalStrut(12);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            bottomStruts.setOpaque(true);
            bottomStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(this.buttonPanel);
        bottomPanel.add(bottomStruts);
        this.maininfoPanel.add((Component)bottomPanel, gridBagConstraint);
    }

    public int getValue() {
        return this.dialogValue;
    }

    private void initListen() {
        this.confirmBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SceneJumpDialog.this.confimButtonAction(actionEvent);
            }
        });
        this.continueBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SceneJumpDialog.this.continueButtonAction(actionEvent);
            }
        });
    }

    private void confimButtonAction(ActionEvent e) {
        this.dialogValue = 0;
        this.dispose();
    }

    private void continueButtonAction(ActionEvent e) {
        this.dialogValue = 1;
        this.dispose();
    }

    @Override
    public final void dispose() {
        Window window = this.getOwner();
        super.dispose();
        SwingUtil.postEvent((Window)window);
    }

    private static final class ArmorSeparator
    extends JSeparator {
        private static final long serialVersionUID = -6149201948604054011L;

        private ArmorSeparator() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(0xCECECE));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }
    }
}

